/*
 * Decompiled with CFR 0.152.
 */
package zairus.weaponcaseloot.item;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zairus.weaponcaseloot.WCLConfig;
import zairus.weaponcaseloot.WCLConstants;
import zairus.weaponcaseloot.WeaponCaseLoot;
import zairus.weaponcaseloot.effects.WCLEffectHandler;
import zairus.weaponcaseloot.item.WCLItem;
import zairus.weaponcaseloot.item.WCLItems;
import zairus.weaponcaseloot.sound.WCLSoundEvents;

@Optional.Interface(modid="Baubles", iface="baubles.api.IBauble")
public class WCLItemBauble
extends WCLItem
implements IBauble {
    public WCLItemBauble() {
        this.field_77777_bU = 1;
        this.setUnlocalizedName("baublering");
        this.func_77637_a(WeaponCaseLoot.weaponCaseLootTab);
        this.func_77627_a(true);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int i1, boolean b1) {
        NBTTagCompound tag;
        if ((stack = WCLItem.correctNameColor(stack)).func_77942_o() && (tag = stack.func_77978_p()).func_74764_b("weapon_looptimer")) {
            stack = WCLItem.loop(stack, "Case Ring", WCLSoundEvents.power, WCLConfig.ring_rarity, world, entity, 0, 12);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTab, List list) {
        for (int i = 0; i < 12; ++i) {
            list.add(this.getRingFromId(i, 4));
        }
    }

    public ItemStack getRingFromId(int ringId, int quality) {
        ItemStack ring = new ItemStack(WCLItems.bauble, 1, 0);
        int rarity = WCLConfig.ring_rarity[ringId];
        NBTTagCompound weaponData = new NBTTagCompound();
        weaponData.func_74778_a("weapon_state", WCLConstants.weapon_quality[quality]);
        weaponData.func_74778_a("weapon_rarity", WCLConstants.weapon_rarity[rarity]);
        weaponData.func_74776_a("weapon_looptimer", 100.0f);
        weaponData.func_74768_a("weapon_index", ringId);
        ring.func_77982_d(weaponData);
        ring.func_151001_c(this.getNameFromId(ringId));
        return ring;
    }

    public String getNameFromId(int ringId) {
        int rarity = WCLConfig.ring_rarity[ringId];
        String[] levels_colors = new String[]{"\u00a7b", "\u00a7a", "\u00a7e", "\u00a76"};
        String name = levels_colors[rarity] + WCLConfig.ring_names[ringId];
        return name;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean b1) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && !tag.func_74764_b("temp_looping")) {
            list.add("Fourth edition case loot.");
            if (tag.func_74764_b("weapon_rarity")) {
                list.add("Rarity: " + tag.func_74779_i("weapon_rarity"));
            }
            list.add("Provides:");
            int id = tag.func_74762_e("weapon_index");
            WCLEffectHandler.effectType[] effects = WCLConfig.ring_effects.get(id);
            for (int i = 0; i < effects.length; ++i) {
                list.add(effects[i].getDisplayName());
            }
        }
    }

    public boolean canEquip(ItemStack stack, EntityLivingBase entity) {
        return true;
    }

    public boolean canUnequip(ItemStack stack, EntityLivingBase entity) {
        return true;
    }

    public BaubleType getBaubleType(ItemStack stack) {
        return BaubleType.RING;
    }

    public void onEquipped(ItemStack stack, EntityLivingBase entity) {
    }

    public void onUnequipped(ItemStack stack, EntityLivingBase entity) {
    }

    public void onWornTick(ItemStack stack, EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            this.setEffect(stack, (EntityPlayer)entity, true);
        }
    }

    private void setEffect(ItemStack stack, EntityPlayer entity, boolean add) {
        NBTTagCompound tag;
        if (stack.func_77942_o() && (tag = stack.func_77978_p()).func_74764_b("weapon_index")) {
            int id = tag.func_74762_e("weapon_index");
            for (int i = 0; i < WCLConfig.ring_effects.get(id).length; ++i) {
                WCLEffectHandler.instance.applyEffect(entity, WCLConfig.ring_effects.get(id)[i], add);
            }
        }
    }
}

