/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.simplegenerators.tile.generator;

import com.valkyrieofnight.simplegenerators.core.SGConfig;
import com.valkyrieofnight.simplegenerators.tile.TileGeneratorFluid;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TileLavaGen
extends TileGeneratorFluid {
    private static int TOTAL_GEN = 4000;

    public TileLavaGen() {
        super(SGConfig.lava_buffer);
    }

    @Override
    public int getRFTFromFluid(FluidStack fluid) {
        if (fluid == null) {
            return 0;
        }
        if (fluid.getFluid() == FluidRegistry.LAVA) {
            return SGConfig.lava_rft;
        }
        return 0;
    }

    @Override
    public int getDurationFromFluid(FluidStack fluid) {
        if (fluid != null && fluid.getFluid() == FluidRegistry.LAVA) {
            return TOTAL_GEN / this.getRFTFromFluid(fluid);
        }
        return 0;
    }

    @Override
    public boolean isValidFuel(FluidStack fluid) {
        if (fluid == null) {
            return false;
        }
        return fluid.getFluid() == FluidRegistry.LAVA;
    }

    @Override
    public boolean shouldConsumeAndGen(FluidStack fluid) {
        return false;
    }

    @Override
    public int getConsumptionPerDuration(FluidStack fluid) {
        return SGConfig.lava_mb_per_operation;
    }

    @Override
    public EnumFacing[] validConectionDirections() {
        return EnumFacing.values();
    }
}

