/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSBlocks;
import com.raoulvdberge.refinedstorage.RSUtils;
import com.raoulvdberge.refinedstorage.api.network.INetworkMaster;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.item.IItemStorage;
import com.raoulvdberge.refinedstorage.api.storage.item.IItemStorageProvider;
import com.raoulvdberge.refinedstorage.apiimpl.storage.item.ItemStorageNBT;
import com.raoulvdberge.refinedstorage.block.BlockStorage;
import com.raoulvdberge.refinedstorage.block.EnumItemStorageType;
import com.raoulvdberge.refinedstorage.inventory.IItemValidator;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerBasic;
import com.raoulvdberge.refinedstorage.tile.IStorageGui;
import com.raoulvdberge.refinedstorage.tile.TileNode;
import com.raoulvdberge.refinedstorage.tile.config.IAccessType;
import com.raoulvdberge.refinedstorage.tile.config.IComparable;
import com.raoulvdberge.refinedstorage.tile.config.IExcessVoidable;
import com.raoulvdberge.refinedstorage.tile.config.IFilterable;
import com.raoulvdberge.refinedstorage.tile.config.IPrioritizable;
import com.raoulvdberge.refinedstorage.tile.data.ITileDataProducer;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileStorage
extends TileNode
implements IItemStorageProvider,
IStorageGui,
IComparable,
IFilterable,
IPrioritizable,
IExcessVoidable,
IAccessType {
    public static final TileDataParameter<Integer> PRIORITY = IPrioritizable.createParameter();
    public static final TileDataParameter<Integer> COMPARE = IComparable.createParameter();
    public static final TileDataParameter<Integer> MODE = IFilterable.createParameter();
    public static final TileDataParameter<AccessType> ACCESS_TYPE = IAccessType.createParameter();
    public static final TileDataParameter<Integer> STORED = new TileDataParameter<Integer>(DataSerializers.field_187192_b, 0, new ITileDataProducer<Integer, TileStorage>(){

        @Override
        public Integer getValue(TileStorage tile) {
            return ItemStorageNBT.getStoredFromNBT(tile.storageTag);
        }
    });
    public static final TileDataParameter<Boolean> VOID_EXCESS = IExcessVoidable.createParameter();
    public static final String NBT_STORAGE = "Storage";
    private static final String NBT_PRIORITY = "Priority";
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_VOID_EXCESS = "VoidExcess";
    private ItemHandlerBasic filters = new ItemHandlerBasic(9, this, new IItemValidator[0]);
    private NBTTagCompound storageTag = ItemStorageNBT.createNBT();
    private ItemStorage storage;
    private EnumItemStorageType type;
    private AccessType accessType = AccessType.INSERT_EXTRACT;
    private int priority = 0;
    private int compare = 3;
    private int mode = 0;
    private boolean voidExcess = false;

    public TileStorage() {
        this.dataManager.addWatchedParameter(PRIORITY);
        this.dataManager.addWatchedParameter(COMPARE);
        this.dataManager.addWatchedParameter(MODE);
        this.dataManager.addWatchedParameter(STORED);
        this.dataManager.addWatchedParameter(VOID_EXCESS);
        this.dataManager.addWatchedParameter(ACCESS_TYPE);
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.storageUsage;
    }

    @Override
    public void updateNode() {
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.storage == null && this.storageTag != null) {
            this.storage = new ItemStorage();
            if (this.network != null) {
                this.network.getItemStorageCache().invalidate();
            }
        }
    }

    public void onBreak() {
        if (this.storage != null) {
            this.storage.writeToNBT();
        }
    }

    @Override
    public void onConnectionChange(INetworkMaster network, boolean state) {
        super.onConnectionChange(network, state);
        network.getItemStorageCache().invalidate();
    }

    @Override
    public void addItemStorages(List<IItemStorage> storages) {
        if (this.storage != null) {
            storages.add(this.storage);
        }
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        if (tag.func_74764_b(NBT_STORAGE)) {
            this.storageTag = tag.func_74775_l(NBT_STORAGE);
        }
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        if (this.storage != null) {
            this.storage.writeToNBT();
        }
        tag.func_74782_a(NBT_STORAGE, (NBTBase)this.storageTag);
        return tag;
    }

    @Override
    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        RSUtils.writeItems((IItemHandler)this.filters, 0, tag);
        tag.func_74768_a(NBT_PRIORITY, this.priority);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_MODE, this.mode);
        tag.func_74757_a(NBT_VOID_EXCESS, this.voidExcess);
        RSUtils.writeAccessType(tag, this.accessType);
        return tag;
    }

    @Override
    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
        RSUtils.readItems((IItemHandlerModifiable)this.filters, 0, tag);
        if (tag.func_74764_b(NBT_PRIORITY)) {
            this.priority = tag.func_74762_e(NBT_PRIORITY);
        }
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = tag.func_74762_e(NBT_MODE);
        }
        if (tag.func_74764_b(NBT_VOID_EXCESS)) {
            this.voidExcess = tag.func_74767_n(NBT_VOID_EXCESS);
        }
        this.accessType = RSUtils.readAccessType(tag);
    }

    public EnumItemStorageType getType() {
        if (this.type == null && this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c() == RSBlocks.STORAGE) {
            this.type = (EnumItemStorageType)((Object)this.func_145831_w().func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockStorage.TYPE));
        }
        return this.type == null ? EnumItemStorageType.TYPE_1K : this.type;
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.func_70296_d();
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public void setMode(int mode) {
        this.mode = mode;
        this.func_70296_d();
    }

    @Override
    public boolean getVoidExcess() {
        return this.voidExcess;
    }

    @Override
    public void setVoidExcess(boolean voidExcess) {
        this.voidExcess = voidExcess;
        this.func_70296_d();
    }

    @Override
    public String getGuiTitle() {
        return "block.refinedstorage:storage." + this.getType().getId() + ".name";
    }

    @Override
    public TileDataParameter<Integer> getTypeParameter() {
        return null;
    }

    @Override
    public TileDataParameter<Integer> getRedstoneModeParameter() {
        return REDSTONE_MODE;
    }

    @Override
    public TileDataParameter<Integer> getCompareParameter() {
        return COMPARE;
    }

    @Override
    public TileDataParameter<Integer> getFilterParameter() {
        return MODE;
    }

    @Override
    public TileDataParameter<Integer> getPriorityParameter() {
        return PRIORITY;
    }

    @Override
    public TileDataParameter<Boolean> getVoidExcessParameter() {
        return VOID_EXCESS;
    }

    @Override
    public TileDataParameter<AccessType> getAccessTypeParameter() {
        return ACCESS_TYPE;
    }

    @Override
    public String getVoidExcessType() {
        return "items";
    }

    public NBTTagCompound getStorageTag() {
        return this.storageTag;
    }

    public void setStorageTag(NBTTagCompound storageTag) {
        this.storageTag = storageTag;
    }

    public ItemStorageNBT getStorage() {
        return this.storage;
    }

    public ItemHandlerBasic getFilters() {
        return this.filters;
    }

    @Override
    public AccessType getAccessType() {
        return this.accessType;
    }

    @Override
    public void setAccessType(AccessType value) {
        this.accessType = value;
        if (this.network != null) {
            this.network.getItemStorageCache().invalidate();
        }
        this.func_70296_d();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
        this.func_70296_d();
    }

    @Override
    public int getStored() {
        return STORED.getValue();
    }

    @Override
    public int getCapacity() {
        return this.getType().getCapacity();
    }

    class ItemStorage
    extends ItemStorageNBT {
        public ItemStorage() {
            super(TileStorage.this.getStorageTag(), TileStorage.this.getCapacity(), TileStorage.this);
        }

        @Override
        public int getPriority() {
            return TileStorage.this.priority;
        }

        @Override
        public ItemStack insertItem(ItemStack stack, int size, boolean simulate) {
            if (!IFilterable.canTake((IItemHandler)TileStorage.this.filters, TileStorage.this.mode, TileStorage.this.compare, stack)) {
                return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
            }
            ItemStack result = super.insertItem(stack, size, simulate);
            if (TileStorage.this.voidExcess && result != null) {
                result.field_77994_a = -result.field_77994_a;
            }
            return result;
        }

        @Override
        public AccessType getAccessType() {
            return TileStorage.this.accessType;
        }
    }
}

