/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.render;

import com.google.common.collect.ImmutableMap;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.CraftingPattern;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.item.ItemPattern;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class BakedModelPattern
implements IBakedModel,
IPerspectiveAwareModel {
    private static final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> TRANSFORMS = ImmutableMap.builder().put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)BakedModelPattern.get(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)BakedModelPattern.get(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)BakedModelPattern.get(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)BakedModelPattern.get(1.13f, 3.2f, 1.13f, 0.0f, 90.0f, -25.0f, 0.68f)).put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)BakedModelPattern.get(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f)).put((Object)ItemCameraTransforms.TransformType.HEAD, (Object)BakedModelPattern.get(0.0f, 13.0f, 7.0f, 0.0f, 180.0f, 0.0f, 1.0f)).build();
    private IBakedModel patternModel;

    private static TRSRTransformation get(float tx, float ty, float tz, float ax, float ay, float az, float s) {
        return new TRSRTransformation(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(ax, ay, az)), new Vector3f(s, s, s), null);
    }

    public BakedModelPattern(IBakedModel patternModel) {
        this.patternModel = patternModel;
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        return this.patternModel.func_188616_a(state, side, rand);
    }

    public boolean func_177555_b() {
        return this.patternModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.patternModel.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.patternModel.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.patternModel.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.patternModel.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return new ItemOverrideList((List)this.patternModel.func_188617_f().getOverrides()){

            public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
                CraftingPattern pattern = ItemPattern.getPatternFromCache(world, stack);
                if (BakedModelPattern.canDisplayPatternOutput(pattern)) {
                    return Minecraft.func_71410_x().func_175599_af().func_184393_a(pattern.getOutputs().get(0), world, entity);
                }
                return super.handleItemState(originalModel, stack, world, entity);
            }
        };
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return Pair.of((Object)this, (Object)(TRANSFORMS.get((Object)cameraTransformType) != null ? ((TRSRTransformation)TRANSFORMS.get((Object)cameraTransformType)).getMatrix() : BakedModelPattern.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f).getMatrix()));
    }

    public static boolean canDisplayPatternOutput(CraftingPattern pattern) {
        return GuiBase.func_146272_n() && pattern.isValid() && pattern.getOutputs().size() == 1;
    }
}

