/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.container.ContainerProcessingPatternEncoder;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.network.MessageGridPatternCreate;
import com.raoulvdberge.refinedstorage.network.MessageProcessingPatternEncoderClear;
import com.raoulvdberge.refinedstorage.tile.TileProcessingPatternEncoder;
import com.raoulvdberge.refinedstorage.tile.data.TileDataManager;
import java.io.IOException;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiProcessingPatternEncoder
extends GuiBase {
    private TileProcessingPatternEncoder encoder;
    private GuiCheckBox oredictPattern;

    public GuiProcessingPatternEncoder(ContainerProcessingPatternEncoder container, TileProcessingPatternEncoder encoder) {
        super(container, 176, 183);
        this.encoder = encoder;
    }

    @Override
    public void init(int x, int y) {
        this.oredictPattern = this.addCheckBox(x + 7, y + 76, I18n.func_135052_a((String)"misc.refinedstorage:oredict", (Object[])new Object[0]), TileProcessingPatternEncoder.OREDICT_PATTERN.getValue());
    }

    @Override
    public void update(int x, int y) {
    }

    private boolean isOverCreatePattern(int mouseX, int mouseY) {
        return this.inBounds(152, 38, 16, 16, mouseX, mouseY) && this.encoder.canCreatePattern();
    }

    private boolean isOverClear(int mouseX, int mouseY) {
        return this.inBounds(80, 19, 7, 7, mouseX, mouseY);
    }

    @Override
    public void drawBackground(int x, int y, int mouseX, int mouseY) {
        this.bindTexture("gui/processing_pattern_encoder.png");
        this.drawTexture(x, y, 0, 0, this.screenWidth, this.screenHeight);
        int ty = 0;
        if (this.isOverCreatePattern(mouseX - this.field_147003_i, mouseY - this.field_147009_r)) {
            ty = 1;
        }
        if (!this.encoder.canCreatePattern()) {
            ty = 2;
        }
        this.drawTexture(x + 152, y + 38, 178, ty * 16, 16, 16);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        this.drawString(7, 7, GuiProcessingPatternEncoder.t("gui.refinedstorage:processing_pattern_encoder", new Object[0]));
        this.drawString(7, 90, GuiProcessingPatternEncoder.t("container.inventory", new Object[0]));
        if (this.isOverCreatePattern(mouseX, mouseY)) {
            this.drawTooltip(mouseX, mouseY, GuiProcessingPatternEncoder.t("gui.refinedstorage:processing_pattern_encoder.pattern_create", new Object[0]));
        }
        if (this.isOverClear(mouseX, mouseY)) {
            this.drawTooltip(mouseX, mouseY, GuiProcessingPatternEncoder.t("misc.refinedstorage:clear", new Object[0]));
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button == this.oredictPattern) {
            TileDataManager.setParameter(TileProcessingPatternEncoder.OREDICT_PATTERN, this.oredictPattern.isChecked());
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.isOverCreatePattern(mouseX - this.field_147003_i, mouseY - this.field_147009_r)) {
            RS.INSTANCE.network.sendToServer((IMessage)new MessageGridPatternCreate(this.encoder.func_174877_v().func_177958_n(), this.encoder.func_174877_v().func_177956_o(), this.encoder.func_174877_v().func_177952_p()));
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        } else if (this.isOverClear(mouseX - this.field_147003_i, mouseY - this.field_147009_r)) {
            RS.INSTANCE.network.sendToServer((IMessage)new MessageProcessingPatternEncoderClear(this.encoder));
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        }
    }

    public void updateOredictPattern(boolean checked) {
        if (this.oredictPattern != null) {
            this.oredictPattern.setIsChecked(checked);
        }
    }
}

