/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.network;

import com.minemaarten.signals.network.IDescSynced;
import com.minemaarten.signals.network.LocationIntPacket;
import com.minemaarten.signals.network.PacketUpdateGui;
import com.minemaarten.signals.network.SyncedField;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class PacketDescription
extends LocationIntPacket<PacketDescription> {
    private byte[] types;
    private Object[] values;
    private NBTTagCompound extraData;
    private IDescSynced.Type type;

    public PacketDescription() {
    }

    public PacketDescription(IDescSynced te) {
        super(te.getPosition());
        this.type = te.getSyncType();
        this.values = new Object[te.getDescriptionFields().size()];
        this.types = new byte[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = te.getDescriptionFields().get(i).getValue();
            this.types[i] = PacketUpdateGui.getType(te.getDescriptionFields().get(i));
        }
        this.extraData = new NBTTagCompound();
        te.writeToPacket(this.extraData);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeByte(this.type.ordinal());
        buf.writeInt(this.values.length);
        for (int i = 0; i < this.types.length; ++i) {
            buf.writeByte((int)this.types[i]);
            PacketUpdateGui.writeField(buf, this.values[i], this.types[i]);
        }
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.extraData);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.type = IDescSynced.Type.values()[buf.readByte()];
        int dataAmount = buf.readInt();
        this.types = new byte[dataAmount];
        this.values = new Object[dataAmount];
        for (int i = 0; i < dataAmount; ++i) {
            this.types[i] = buf.readByte();
            this.values[i] = PacketUpdateGui.readField(buf, this.types[i]);
        }
        this.extraData = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public static Object getSyncableForType(LocationIntPacket message, EntityPlayer player, IDescSynced.Type type, NBTTagCompound extraData) {
        switch (type) {
            case TILE_ENTITY: {
                return message.getTileEntity(player.field_70170_p);
            }
        }
        return null;
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        Object syncable;
        if (player.field_70170_p.func_175667_e(this.pos) && (syncable = PacketDescription.getSyncableForType(this, player, this.type, this.extraData)) instanceof IDescSynced) {
            IDescSynced descSynced = (IDescSynced)syncable;
            List<SyncedField> descFields = descSynced.getDescriptionFields();
            if (descFields != null && descFields.size() == this.types.length) {
                for (int i = 0; i < descFields.size(); ++i) {
                    descFields.get(i).setValue(this.values[i]);
                }
            }
            descSynced.readFromPacket(this.extraData);
            descSynced.onDescUpdate();
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

