/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.lib;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class SignalsUtils {
    public static List<String> convertStringIntoList(String text, int maxCharPerLine) {
        StringTokenizer tok = new StringTokenizer(text, " ");
        StringBuilder output = new StringBuilder(text.length());
        ArrayList<String> textList = new ArrayList<String>();
        String color = "";
        int lineLen = 0;
        while (tok.hasMoreTokens()) {
            String word = tok.nextToken();
            if (word.contains("\u00a7")) {
                for (int i = 0; i < word.length() - 1; ++i) {
                    if (!word.substring(i, i + 2).contains("\u00a7")) continue;
                    color = word.substring(i, i + 2);
                }
                lineLen -= 2;
            }
            if (lineLen + word.length() > maxCharPerLine || word.contains("\\n")) {
                word = word.replace("\\n", "");
                textList.add(output.toString());
                output.delete(0, output.length());
                output.append(color);
                lineLen = 0;
            } else if (lineLen > 0) {
                output.append(" ");
                ++lineLen;
            }
            output.append(word);
            lineLen += word.length();
        }
        textList.add(output.toString());
        return textList;
    }

    public static void writeInventoryToNBT(NBTTagCompound tag, ItemStack[] stacks) {
        SignalsUtils.writeInventoryToNBT(tag, stacks, "Items");
    }

    public static void writeInventoryToNBT(NBTTagCompound tag, IInventory inv) {
        SignalsUtils.writeInventoryToNBT(tag, inv, "Items");
    }

    public static void writeInventoryToNBT(NBTTagCompound tag, IInventory inventory, String tagName) {
        ItemStack[] stacks = new ItemStack[inventory.func_70302_i_()];
        for (int i = 0; i < stacks.length; ++i) {
            stacks[i] = inventory.func_70301_a(i);
        }
        SignalsUtils.writeInventoryToNBT(tag, stacks, tagName);
    }

    public static void writeInventoryToNBT(NBTTagCompound tag, ItemStack[] stacks, String tagName) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < stacks.length; ++i) {
            if (stacks[i] == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            stacks[i].func_77955_b(itemTag);
            itemTag.func_74774_a("Slot", (byte)i);
            tagList.func_74742_a((NBTBase)itemTag);
        }
        tag.func_74782_a(tagName, (NBTBase)tagList);
    }

    public static void readInventoryFromNBT(NBTTagCompound tag, ItemStack[] stacks) {
        SignalsUtils.readInventoryFromNBT(tag, stacks, "Items");
    }

    public static void readInventoryFromNBT(NBTTagCompound tag, IInventory inv) {
        SignalsUtils.readInventoryFromNBT(tag, inv, "Items");
    }

    public static void readInventoryFromNBT(NBTTagCompound tag, IInventory inventory, String tagName) {
        ItemStack[] stacks = new ItemStack[inventory.func_70302_i_()];
        SignalsUtils.readInventoryFromNBT(tag, stacks, tagName);
        for (int i = 0; i < stacks.length; ++i) {
            inventory.func_70299_a(i, stacks[i]);
        }
    }

    public static void readInventoryFromNBT(NBTTagCompound tag, ItemStack[] stacks, String tagName) {
        for (int i = 0; i < stacks.length; ++i) {
            stacks[i] = null;
        }
        NBTTagList tagList = tag.func_150295_c(tagName, 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound itemTag = tagList.func_150305_b(i);
            byte slot = itemTag.func_74771_c("Slot");
            if (slot < 0 || slot >= stacks.length) continue;
            stacks[slot] = ItemStack.func_77949_a((NBTTagCompound)itemTag);
        }
    }
}

