/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.capabilities;

import com.minemaarten.signals.block.BlockSignalBase;
import com.minemaarten.signals.init.ModItems;
import com.minemaarten.signals.lib.SignalsUtils;
import com.minemaarten.signals.network.GuiSynced;
import com.minemaarten.signals.network.NetworkHandler;
import com.minemaarten.signals.network.PacketSpawnParticle;
import com.minemaarten.signals.network.PacketUpdateMinecartEngineState;
import com.minemaarten.signals.network.PacketUpdateMinecartPath;
import com.minemaarten.signals.rail.DestinationPathFinder;
import com.minemaarten.signals.rail.RailCacheManager;
import com.minemaarten.signals.rail.RailWrapper;
import com.minemaarten.signals.tileentity.IGUITextFieldSensitive;
import com.minemaarten.signals.tileentity.TileEntitySignalBase;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.entity.minecart.MinecartUpdateEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;

public class CapabilityMinecartDestination
implements IGUITextFieldSensitive {
    @CapabilityInject(value=CapabilityMinecartDestination.class)
    public static Capability<CapabilityMinecartDestination> INSTANCE;
    private static final Pattern EMPTY_PATTERN;
    @GuiSynced
    private String destinationStations = "";
    private Pattern[] destinationRegexes = new Pattern[0];
    @GuiSynced
    private int curDestinationIndex;
    @GuiSynced
    private String invalidDestinations = "";
    private DestinationPathFinder.AStarRailNode curPath;
    private List<BlockPos> nbtLoadedPath;
    private boolean motorized;
    @GuiSynced
    private int fuelLeft;
    @GuiSynced
    private int totalBurnTime;
    private int hopperTimer;
    private InventoryBasic fuelInv = new InventoryBasic("cartEngineInv", true, 5){

        public boolean func_94041_b(int index, ItemStack stack) {
            return stack == null || TileEntityFurnace.func_145954_b((ItemStack)stack);
        }
    };
    private boolean motorActive;
    public boolean travelingBetweenDimensions;

    public static void register() {
        CapabilityManager.INSTANCE.register(CapabilityMinecartDestination.class, (Capability.IStorage)new Capability.IStorage<CapabilityMinecartDestination>(){

            public NBTBase writeNBT(Capability<CapabilityMinecartDestination> capability, CapabilityMinecartDestination instance, EnumFacing side) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a("destinations", instance.destinationStations);
                tag.func_74768_a("destIndex", instance.curDestinationIndex);
                if (instance.curPath != null) {
                    NBTTagList nodeList = new NBTTagList();
                    for (DestinationPathFinder.AStarRailNode curNode = instance.curPath; curNode != null; curNode = curNode.getNextNode()) {
                        NBTTagCompound nodeTag = new NBTTagCompound();
                        nodeTag.func_74768_a("x", curNode.getRail().func_177958_n());
                        nodeTag.func_74768_a("y", curNode.getRail().func_177956_o());
                        nodeTag.func_74768_a("z", curNode.getRail().func_177952_p());
                        nodeList.func_74742_a((NBTBase)nodeTag);
                    }
                    tag.func_74782_a("path", (NBTBase)nodeList);
                }
                tag.func_74757_a("motorized", instance.motorized);
                if (instance.motorized) {
                    tag.func_74768_a("fuelLeft", instance.fuelLeft);
                    tag.func_74768_a("totalBurnTime", instance.totalBurnTime);
                    SignalsUtils.writeInventoryToNBT(tag, (IInventory)instance.fuelInv);
                }
                return tag;
            }

            public void readNBT(Capability<CapabilityMinecartDestination> capability, CapabilityMinecartDestination instance, EnumFacing side, NBTBase base) {
                NBTTagCompound tag = (NBTTagCompound)base;
                instance.destinationStations = tag.func_74779_i("destinations");
                instance.recompileRegexes();
                instance.curDestinationIndex = tag.func_74762_e("destIndex");
                if (tag.func_74764_b("path")) {
                    instance.nbtLoadedPath = new ArrayList();
                    NBTTagList nodeList = tag.func_150295_c("path", 10);
                    for (int i = 0; i < nodeList.func_74745_c(); ++i) {
                        NBTTagCompound nodeTag = nodeList.func_150305_b(i);
                        instance.nbtLoadedPath.add(new BlockPos(nodeTag.func_74762_e("x"), nodeTag.func_74762_e("y"), nodeTag.func_74762_e("z")));
                    }
                } else {
                    instance.curPath = null;
                }
                instance.motorized = tag.func_74767_n("motorized");
                if (instance.motorized) {
                    instance.fuelLeft = tag.func_74762_e("fuelLeft");
                    instance.totalBurnTime = tag.func_74762_e("totalBurnTime");
                    SignalsUtils.readInventoryFromNBT(tag, (IInventory)instance.fuelInv);
                }
            }
        }, (Callable)new Callable<CapabilityMinecartDestination>(){

            @Override
            public CapabilityMinecartDestination call() throws Exception {
                return new CapabilityMinecartDestination();
            }
        });
    }

    @Override
    public void setText(int textFieldID, String text) {
        this.destinationStations = text;
        this.recompileRegexes();
    }

    private void recompileRegexes() {
        String[] destinations = this.getDestinations();
        this.destinationRegexes = new Pattern[destinations.length];
        this.invalidDestinations = "";
        for (int i = 0; i < destinations.length; ++i) {
            try {
                this.destinationRegexes[i] = Pattern.compile(destinations[i]);
                continue;
            }
            catch (PatternSyntaxException e) {
                if (!this.invalidDestinations.equals("")) {
                    this.invalidDestinations = this.invalidDestinations + ",";
                }
                this.invalidDestinations = this.invalidDestinations + "" + i;
                this.destinationRegexes[i] = EMPTY_PATTERN;
            }
        }
    }

    public int[] getInvalidDestinationIndeces() {
        if (this.invalidDestinations.equals("")) {
            return new int[0];
        }
        String[] strings = this.invalidDestinations.split(",");
        int[] ints = new int[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            ints[i] = Integer.parseInt(strings[i]);
        }
        return ints;
    }

    @Override
    public String getText(int textFieldID) {
        return this.destinationStations;
    }

    public String getDestination(int index) {
        return this.getDestinations()[index];
    }

    private String[] getDestinations() {
        return this.destinationStations.equals("") ? new String[]{} : this.destinationStations.split("\n");
    }

    public int getTotalDestinations() {
        return this.getDestinations().length;
    }

    public String getCurrentDestination() {
        String[] destinations = this.getDestinations();
        if (this.curDestinationIndex >= destinations.length || this.curDestinationIndex == -1) {
            this.nextDestination();
        }
        return this.curDestinationIndex >= 0 ? destinations[this.curDestinationIndex] : "";
    }

    public int getDestinationIndex() {
        return this.curDestinationIndex;
    }

    public void nextDestination() {
        String[] destinations = this.getDestinations();
        if (++this.curDestinationIndex >= destinations.length) {
            this.curDestinationIndex = destinations.length > 0 ? 0 : -1;
        }
    }

    public Pattern getCurrentDestinationRegex() {
        this.getCurrentDestination();
        return this.curDestinationIndex >= 0 ? this.destinationRegexes[this.curDestinationIndex] : EMPTY_PATTERN;
    }

    public void setPath(EntityMinecart cart, DestinationPathFinder.AStarRailNode path) {
        this.curPath = path;
        this.nbtLoadedPath = null;
        this.sendUpdatePacket(cart);
    }

    private void sendUpdatePacket(EntityMinecart cart) {
        NetworkHandler.sendToAll(new PacketUpdateMinecartPath(cart));
    }

    public DestinationPathFinder.AStarRailNode getPath(World world) {
        if (this.nbtLoadedPath != null) {
            DestinationPathFinder.AStarRailNode prevNode = null;
            for (int i = this.nbtLoadedPath.size() - 1; i >= 0; --i) {
                DestinationPathFinder.AStarRailNode curNode = new DestinationPathFinder.AStarRailNode(RailCacheManager.getInstance(world).getRail(world, this.nbtLoadedPath.get(i)), null, null);
                if (prevNode != null) {
                    curNode.checkImprovementAndUpdate(prevNode);
                }
                prevNode = curNode;
            }
            this.curPath = prevNode;
            this.nbtLoadedPath = null;
        }
        return this.curPath;
    }

    public List<BlockPos> getNBTPath() {
        return this.nbtLoadedPath;
    }

    public void setMotorized() {
        this.motorized = true;
    }

    public boolean isMotorized() {
        return this.motorized;
    }

    public boolean useFuel(EntityMinecart cart) {
        if (this.motorized) {
            if (this.fuelLeft == 0) {
                for (int i = 0; i < this.fuelInv.func_70302_i_(); ++i) {
                    int fuelValue;
                    ItemStack fuel = this.fuelInv.func_70301_a(i);
                    if (fuel == null || (fuelValue = TileEntityFurnace.func_145952_a((ItemStack)fuel)) <= 0) continue;
                    --fuel.field_77994_a;
                    if (fuel.field_77994_a <= 0) {
                        this.fuelInv.func_70299_a(i, fuel.func_77973_b().getContainerItem(fuel));
                    }
                    this.fuelLeft += fuelValue;
                    this.totalBurnTime = fuelValue;
                    break;
                }
            }
            if (this.fuelLeft > 0) {
                --this.fuelLeft;
                double randX = cart.func_174791_d().field_72450_a + (cart.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.5;
                double randY = cart.func_174791_d().field_72448_b + (cart.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.5;
                double randZ = cart.func_174791_d().field_72449_c + (cart.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.5;
                NetworkHandler.sendToAllAround(new PacketSpawnParticle(EnumParticleTypes.SMOKE_LARGE, randX, randY, randZ, 0.0, 0.0, 0.0), cart.field_70170_p);
                return true;
            }
        }
        return false;
    }

    public InventoryBasic getFuelInv() {
        return this.fuelInv;
    }

    public int getScaledFuel(int barLength) {
        return this.totalBurnTime == 0 ? 0 : barLength * this.fuelLeft / this.totalBurnTime;
    }

    public void onCartBroken(EntityMinecart cart) {
        if (this.motorized && !this.travelingBetweenDimensions) {
            this.motorized = false;
            cart.func_145779_a(ModItems.cartEngine, 1);
            for (int i = 0; i < this.fuelInv.func_70302_i_(); ++i) {
                ItemStack fuel = this.fuelInv.func_70301_a(i);
                if (fuel == null) continue;
                cart.func_70099_a(fuel, 0.0f);
            }
        }
        this.travelingBetweenDimensions = false;
    }

    public void setEngineActive(boolean active) {
        this.motorActive = active;
    }

    public void onCartUpdate(MinecartUpdateEvent event) {
        EntityMinecart cart = event.getMinecart();
        if (!cart.field_70170_p.field_72995_K) {
            if (this.isMotorized()) {
                boolean shouldRun = true;
                EnumFacing cartDir = cart.func_184172_bi();
                Vec3d vec3d = new Vec3d(cart.field_70159_w, cart.field_70181_x, cart.field_70179_y);
                if (vec3d.func_72433_c() < 0.05) {
                    shouldRun = false;
                    if (this.hopperTimer > 0) {
                        --this.hopperTimer;
                    }
                    if (this.hopperTimer == 0) {
                        this.hopperTimer = this.extractFuelFromHopper(cart, event.getPos()) ? 8 : 40;
                    }
                } else {
                    this.hopperTimer = 0;
                    RailWrapper rail = RailCacheManager.getInstance(cart.field_70170_p).getRail(cart.field_70170_p, event.getPos());
                    if (rail == null) {
                        shouldRun = false;
                    } else {
                        TileEntitySignalBase signal = TileEntitySignalBase.getNeighborSignal(rail, cartDir.func_176734_d());
                        boolean bl = shouldRun = signal == null || signal.getLampStatus() != BlockSignalBase.EnumLampStatus.RED;
                        if (!shouldRun) {
                            cart.field_70159_w = 0.0;
                            cart.field_70179_y = 0.0;
                        }
                    }
                }
                if (shouldRun && this.useFuel(cart)) {
                    if (!this.motorActive) {
                        NetworkHandler.sendToAllAround(new PacketUpdateMinecartEngineState(cart, true), new NetworkRegistry.TargetPoint(cart.field_70170_p.field_73011_w.getDimension(), cart.func_174791_d().field_72450_a, cart.func_174791_d().field_72448_b, cart.func_174791_d().field_72449_c, 64.0));
                    }
                    this.motorActive = true;
                    double acceleration = 0.03;
                    cart.field_70159_w += (double)cartDir.func_82601_c() * acceleration;
                    cart.field_70179_y += (double)cartDir.func_82599_e() * acceleration;
                    cart.field_70159_w = MathHelper.func_151237_a((double)cart.field_70159_w, (double)(-cart.getMaxCartSpeedOnRail()), (double)cart.getMaxCartSpeedOnRail());
                    cart.field_70179_y = MathHelper.func_151237_a((double)cart.field_70179_y, (double)(-cart.getMaxCartSpeedOnRail()), (double)cart.getMaxCartSpeedOnRail());
                } else {
                    if (this.motorActive) {
                        NetworkHandler.sendToAllAround(new PacketUpdateMinecartEngineState(cart, true), new NetworkRegistry.TargetPoint(cart.field_70170_p.field_73011_w.getDimension(), cart.func_174791_d().field_72450_a, cart.func_174791_d().field_72448_b, cart.func_174791_d().field_72449_c, 64.0));
                    }
                    this.motorActive = false;
                }
            }
        } else if (this.motorActive) {
            cart.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, cart.func_174791_d().field_72450_a, cart.func_174791_d().field_72448_b, cart.func_174791_d().field_72449_c, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    private boolean extractFuelFromHopper(EntityMinecart cart, BlockPos pos) {
        boolean foundHopper = false;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            BlockPos neighbor = pos;
            for (int offsetTimes = 0; offsetTimes < (dir == EnumFacing.UP ? 2 : 1); ++offsetTimes) {
                EnumFacing hopperDir;
                TileEntity te = cart.field_70170_p.func_175625_s(neighbor = neighbor.func_177972_a(dir));
                if (!(te instanceof TileEntityHopper) || (hopperDir = (EnumFacing)cart.field_70170_p.func_180495_p(neighbor).func_177229_b((IProperty)BlockHopper.field_176430_a)).func_176734_d() != dir) continue;
                TileEntityHopper hopper = (TileEntityHopper)te;
                for (int i = 0; i < hopper.func_70302_i_(); ++i) {
                    ItemStack stack = hopper.func_70301_a(i);
                    if (stack == null || !this.getFuelInv().func_94041_b(0, stack)) continue;
                    InvWrapper invWrapper = new InvWrapper((IInventory)this.getFuelInv());
                    ItemStack inserted = stack.func_77946_l();
                    inserted.field_77994_a = 1;
                    ItemStack left = ItemHandlerHelper.insertItemStacked((IItemHandler)invWrapper, (ItemStack)inserted, (boolean)false);
                    if (left != null) continue;
                    --stack.field_77994_a;
                    if (stack.field_77994_a <= 0) {
                        hopper.func_70299_a(i, null);
                    }
                    hopper.func_70296_d();
                    return true;
                }
                foundHopper = true;
            }
        }
        return foundHopper;
    }

    static {
        EMPTY_PATTERN = Pattern.compile("");
    }

    public static class Provider
    implements ICapabilitySerializable<NBTBase> {
        private final CapabilityMinecartDestination cap = new CapabilityMinecartDestination();

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == INSTANCE;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (this.hasCapability(capability, facing)) {
                return (T)this.cap;
            }
            return null;
        }

        public NBTBase serializeNBT() {
            return INSTANCE.getStorage().writeNBT(INSTANCE, (Object)this.cap, null);
        }

        public void deserializeNBT(NBTBase nbt) {
            INSTANCE.getStorage().readNBT(INSTANCE, (Object)this.cap, null, nbt);
        }
    }
}

