/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.capabilities;

import com.minemaarten.signals.api.tileentity.IDestinationProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class CapabilityDestinationProvider {
    @CapabilityInject(value=CapabilityDestinationProvider.class)
    public static Capability<CapabilityDestinationProvider> INSTANCE;
    private List<IDestinationProvider> destinationProviders = new ArrayList<IDestinationProvider>();

    public static void register() {
        CapabilityManager.INSTANCE.register(CapabilityDestinationProvider.class, (Capability.IStorage)new Capability.IStorage<CapabilityDestinationProvider>(){

            public NBTBase writeNBT(Capability<CapabilityDestinationProvider> capability, CapabilityDestinationProvider instance, EnumFacing side) {
                NBTTagCompound tag = new NBTTagCompound();
                for (IDestinationProvider provider : instance.destinationProviders) {
                    provider.writeToNBT(tag);
                }
                return tag;
            }

            public void readNBT(Capability<CapabilityDestinationProvider> capability, CapabilityDestinationProvider instance, EnumFacing side, NBTBase base) {
                NBTTagCompound tag = (NBTTagCompound)base;
                for (IDestinationProvider provider : instance.destinationProviders) {
                    provider.readFromNBT(tag);
                }
            }
        }, (Callable)new Callable<CapabilityDestinationProvider>(){

            @Override
            public CapabilityDestinationProvider call() throws Exception {
                return new CapabilityDestinationProvider();
            }
        });
    }

    public void addDestinationProvider(IDestinationProvider provider) {
        this.destinationProviders.add(provider);
    }

    public List<IDestinationProvider> getApplicableDestinationProviders() {
        return this.destinationProviders;
    }

    public <T extends IDestinationProvider> T getProvider(Class<T> type) {
        for (IDestinationProvider provider : this.destinationProviders) {
            if (!type.isAssignableFrom(provider.getClass())) continue;
            return (T)provider;
        }
        return null;
    }

    public boolean isCartApplicable(TileEntity te, EntityMinecart cart, Pattern destinationRegex) {
        for (IDestinationProvider provider : this.destinationProviders) {
            if (!provider.isCartApplicable(te, cart, destinationRegex)) continue;
            return true;
        }
        return false;
    }

    public static class Provider
    implements ICapabilitySerializable<NBTBase> {
        private final CapabilityDestinationProvider cap = new CapabilityDestinationProvider();

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == INSTANCE;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (this.hasCapability(capability, facing)) {
                return (T)this.cap;
            }
            return null;
        }

        public NBTBase serializeNBT() {
            return INSTANCE.getStorage().writeNBT(INSTANCE, (Object)this.cap, null);
        }

        public void deserializeNBT(NBTBase nbt) {
            INSTANCE.getStorage().readNBT(INSTANCE, (Object)this.cap, null, nbt);
        }
    }
}

