/*
 * Decompiled with CFR 0.152.
 */
package net.quetzi.morpheus.commands;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.quetzi.morpheus.Morpheus;
import net.quetzi.morpheus.MorpheusRegistry;

public class CommandMorpheus
extends CommandBase {
    private final List<String> aliases = new ArrayList<String>();

    public CommandMorpheus() {
        this.aliases.add("sleepvote");
    }

    @Nonnull
    public String func_71517_b() {
        return "morpheus";
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "/morpheus <alert : version> | /morpheus percent <percentage> | /morpheus disable <dimension number>";
    }

    @Nonnull
    public List<String> func_71514_a() {
        return this.aliases;
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws NumberInvalidException {
        if (args.length == 0) {
            sender.func_145747_a(new TextComponentString("Usage: /morpheus <alert : version> | /morpheus percent <percentage> | /morpheus disable <dimension number>").func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            return;
        }
        if (args[0].equalsIgnoreCase("alert")) {
            if (Morpheus.isAlertEnabled()) {
                Morpheus.setAlertPlayers(false);
                sender.func_145747_a((ITextComponent)new TextComponentString("Text alerts turned off"));
            } else {
                Morpheus.setAlertPlayers(true);
                sender.func_145747_a((ITextComponent)new TextComponentString("Text alerts turned on"));
            }
        } else if (args[0].equalsIgnoreCase("version")) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Morpheus version: 1.10.2-3.1.13"));
        } else {
            boolean setPercent = args[0].equalsIgnoreCase("percent");
            if (setPercent || args[0].equalsIgnoreCase("disable")) {
                if (args.length > 1) {
                    if (this.isPlayerOpped(sender)) {
                        if (setPercent) {
                            int newPercent = CommandMorpheus.func_175755_a((String)args[1]);
                            if (newPercent > 0 && newPercent <= 100) {
                                Morpheus.perc = newPercent;
                                Morpheus.config.get("settings", "SleeperPerc", 50).set(newPercent);
                                Morpheus.config.save();
                                sender.func_145747_a((ITextComponent)new TextComponentString("Sleep vote percentage set to " + Morpheus.perc + "%"));
                            } else {
                                sender.func_145747_a((ITextComponent)new TextComponentString("Invalid percentage value, round numbers between 0 and 100 are acceptable."));
                            }
                        } else {
                            int ageToDisable = CommandMorpheus.func_175755_a((String)args[1]);
                            if (Morpheus.register.isDimRegistered(ageToDisable)) {
                                Morpheus.register.unregisterHandler(ageToDisable);
                                sender.func_145747_a((ITextComponent)new TextComponentString("Disabled sleep vote checks in dimension " + ageToDisable));
                            } else {
                                sender.func_145747_a((ITextComponent)new TextComponentString("Sleep vote checks are already disabled in dimension " + ageToDisable));
                            }
                        }
                    } else {
                        sender.func_145747_a((ITextComponent)new TextComponentString("You must be opped to " + (setPercent ? "set the sleep vote percentage." : "disable dimensions.")));
                    }
                } else {
                    sender.func_145747_a(new TextComponentString(setPercent ? "Usage: /morpheus percent <percentage>" : "Usage: /morpheus disable <dimension number>").func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                }
            }
        }
    }

    public boolean func_184882_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender) {
        return true;
    }

    private boolean isPlayerOpped(ICommandSender sender) {
        if (sender instanceof EntityPlayer) {
            for (String player : sender.func_184102_h().func_184103_al().func_152606_n()) {
                if (!player.equals(sender.func_70005_c_())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Nonnull
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return CommandMorpheus.func_71530_a((String[])args, (String[])new String[]{"alert", "disable", "percent", "version"});
        }
        List<String> options = new ArrayList<String>();
        if (args[0].equalsIgnoreCase("disable")) {
            for (Integer dimensionId : MorpheusRegistry.registry.keySet()) {
                options.add(dimensionId.toString());
            }
            options = CommandMorpheus.func_175762_a((String[])args, options);
        }
        return options;
    }
}

