/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.TileEntityLiquidTankElectricMachine;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotCharge;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.block.machine.tileentity.TileEntityMiner;
import ic2.core.gui.dynamic.DynamicContainer;
import ic2.core.gui.dynamic.DynamicGui;
import ic2.core.gui.dynamic.GuiParser;
import ic2.core.gui.dynamic.IGuiValueProvider;
import ic2.core.network.GuiSynced;
import ic2.core.upgrade.IUpgradableBlock;
import ic2.core.upgrade.IUpgradeItem;
import ic2.core.upgrade.UpgradableProperty;
import ic2.core.util.LiquidUtil;
import ic2.core.util.PumpUtil;
import ic2.core.util.Util;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.mutable.MutableObject;

public class TileEntityPump
extends TileEntityLiquidTankElectricMachine
implements IHasGui,
IUpgradableBlock,
IGuiValueProvider {
    public final int defaultTier;
    public int energyConsume = 1;
    public int operationsPerTick;
    public final int defaultEnergyStorage;
    public final int defaultEnergyConsume;
    public final int defaultOperationLength;
    private AudioSource audioSource;
    private TileEntityMiner miner = null;
    public boolean redstonePowered = false;
    public final InvSlotCharge chargeSlot = new InvSlotCharge(this, 1);
    public final InvSlotConsumableLiquid containerSlot = new InvSlotConsumableLiquid(this, "input", InvSlot.Access.I, 1, InvSlot.InvSide.TOP, InvSlotConsumableLiquid.OpType.Fill);
    public final InvSlotOutput outputSlot = new InvSlotOutput((TileEntityInventory)this, "output", 1, InvSlot.InvSide.SIDE);
    public final InvSlotUpgrade upgradeSlot = new InvSlotUpgrade(this, "upgrade", 4);
    public short progress = 0;
    public int operationLength = 20;
    @GuiSynced
    public float guiProgress;

    public TileEntityPump() {
        super(20, 1, 8);
        this.defaultEnergyConsume = 1;
        this.defaultOperationLength = 20;
        this.defaultTier = 1;
        this.defaultEnergyStorage = 1 * this.operationLength;
    }

    @Override
    protected void onLoaded() {
        super.onLoaded();
        if (!this.field_145850_b.field_72995_K) {
            this.setUpgradestat();
        }
    }

    @Override
    protected void onUnloaded() {
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
        }
        this.miner = null;
        super.onUnloaded();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.progress = nbt.func_74765_d("progress");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74777_a("progress", this.progress);
        return nbt;
    }

    @Override
    protected void updateEntityServer() {
        MutableObject output;
        super.updateEntityServer();
        boolean needsInvUpdate = false;
        if (this.canoperate() && this.energy.getEnergy() >= (double)(this.energyConsume * this.operationLength)) {
            if (this.progress < this.operationLength) {
                this.progress = (short)(this.progress + 1);
                this.energy.useEnergy(this.energyConsume);
            } else {
                this.progress = 0;
                this.operate(false);
            }
        }
        if (this.containerSlot.transferFromTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)(output = new MutableObject()), true) && (output.getValue() == null || this.outputSlot.canAdd((ItemStack)output.getValue()))) {
            this.containerSlot.transferFromTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)output, false);
            if (output.getValue() != null) {
                this.outputSlot.add((ItemStack)output.getValue());
            }
        }
        for (int i = 0; i < this.upgradeSlot.size(); ++i) {
            ItemStack stack = this.upgradeSlot.get(i);
            if (stack == null || !(stack.func_77973_b() instanceof IUpgradeItem) || !((IUpgradeItem)stack.func_77973_b()).onTick(stack, this)) continue;
            needsInvUpdate = true;
        }
        this.guiProgress = (float)this.progress / (float)this.operationLength;
        if (needsInvUpdate) {
            super.func_70296_d();
        }
    }

    public boolean canoperate() {
        return this.operate(true);
    }

    public boolean operate(boolean sim) {
        if (this.miner == null || this.miner.func_145837_r()) {
            this.miner = null;
            for (EnumFacing dir : Util.downSideFacings) {
                TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir));
                if (!(te instanceof TileEntityMiner)) continue;
                this.miner = (TileEntityMiner)te;
                break;
            }
        }
        FluidStack liquid = null;
        if (this.miner != null) {
            if (this.miner.canProvideLiquid) {
                liquid = this.pump(this.miner.liquidPos, sim, this.miner);
            }
        } else {
            EnumFacing dir;
            dir = this.getFacing();
            liquid = this.pump(this.field_174879_c.func_177972_a(dir), sim, this.miner);
        }
        if (liquid != null && this.getFluidTank().fill(liquid, false) > 0) {
            if (!sim) {
                this.getFluidTank().fill(liquid, true);
            }
            return true;
        }
        return false;
    }

    public FluidStack pump(BlockPos startPos, boolean sim, TileEntityMiner miner) {
        int freeSpace = this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount();
        if (miner == null && freeSpace > 0) {
            TileEntity te = this.field_145850_b.func_175625_s(startPos);
            EnumFacing side = this.getFacing().func_176734_d();
            if (te != null && LiquidUtil.isFluidTile(te, side)) {
                if (freeSpace > 1000) {
                    freeSpace = 1000;
                }
                return LiquidUtil.drainTile(te, side, freeSpace, sim);
            }
        }
        if (freeSpace >= 1000) {
            BlockPos cPos;
            if (miner != null && miner.canProvideLiquid) {
                assert (miner.liquidPos != null);
                cPos = miner.liquidPos;
            } else {
                cPos = PumpUtil.searchFluidSource(this.field_145850_b, startPos);
            }
            if (cPos != null) {
                return LiquidUtil.drainBlock(this.field_145850_b, cPos, sim);
            }
        }
        return null;
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        if (IC2.platform.isSimulating()) {
            this.setUpgradestat();
        }
    }

    public void setUpgradestat() {
        int extraProcessTime = 0;
        double processTimeMultiplier = 1.0;
        int extraEnergyDemand = 0;
        double energyDemandMultiplier = 1.0;
        int extraEnergyStorage = 0;
        double energyStorageMultiplier = 1.0;
        int extraTier = 0;
        for (int i = 0; i < this.upgradeSlot.size(); ++i) {
            ItemStack stack = this.upgradeSlot.get(i);
            if (stack == null || !(stack.func_77973_b() instanceof IUpgradeItem)) continue;
            IUpgradeItem upgrade = (IUpgradeItem)stack.func_77973_b();
            extraProcessTime += upgrade.getExtraProcessTime(stack, this) * stack.field_77994_a;
            processTimeMultiplier *= Math.pow(upgrade.getProcessTimeMultiplier(stack, this), stack.field_77994_a);
            extraEnergyDemand += upgrade.getExtraEnergyDemand(stack, this) * stack.field_77994_a;
            energyDemandMultiplier *= Math.pow(upgrade.getEnergyDemandMultiplier(stack, this), stack.field_77994_a);
            extraEnergyStorage += upgrade.getExtraEnergyStorage(stack, this) * stack.field_77994_a;
            energyStorageMultiplier *= Math.pow(upgrade.getEnergyStorageMultiplier(stack, this), stack.field_77994_a);
            extraTier += upgrade.getExtraTier(stack, this) * stack.field_77994_a;
        }
        double previousProgress = (double)this.progress / (double)this.operationLength;
        double stackOpLen = ((double)this.defaultOperationLength + (double)extraProcessTime) * 64.0 * processTimeMultiplier;
        this.operationsPerTick = (int)Math.min(Math.ceil(64.0 / stackOpLen), 2.147483647E9);
        this.operationLength = (int)Math.round(stackOpLen * (double)this.operationsPerTick / 64.0);
        this.energyConsume = TileEntityPump.applyModifier(this.defaultEnergyConsume, extraEnergyDemand, energyDemandMultiplier);
        this.energy.setSinkTier(TileEntityPump.applyModifier(this.defaultTier, extraTier, 1.0));
        this.energy.setCapacity(TileEntityPump.applyModifier(this.defaultEnergyStorage, extraEnergyStorage + this.operationLength * this.energyConsume, energyStorageMultiplier));
        if (this.operationLength < 1) {
            this.operationLength = 1;
        }
        this.progress = (short)Math.floor(previousProgress * (double)this.operationLength + 0.1);
    }

    private static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round(((double)base + (double)extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    public double getGuiValue(String name) {
        if (name.equals("progress")) {
            return this.guiProgress;
        }
        throw new IllegalArgumentException(this.getClass().getSimpleName() + " Cannot get value for " + name);
    }

    @Override
    public double getEnergy() {
        return this.energy.getEnergy();
    }

    @Override
    public boolean useEnergy(double amount) {
        return this.energy.useEnergy(amount);
    }

    public ContainerBase<TileEntityPump> getGuiContainer(EntityPlayer player) {
        return DynamicContainer.create(this, player, GuiParser.parse(this.teBlock));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return DynamicGui.create(this, player, GuiParser.parse(this.teBlock));
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active")) {
            if (this.audioSource == null) {
                this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, "Machines/PumpOp.ogg", true, false, IC2.audioManager.getDefaultVolume());
            }
            if (this.getActive()) {
                if (this.audioSource != null) {
                    this.audioSource.play();
                }
            } else if (this.audioSource != null) {
                this.audioSource.stop();
            }
        }
        super.onNetworkUpdate(field);
    }

    @Override
    public boolean canFill(EnumFacing from, Fluid fluid) {
        return false;
    }

    @Override
    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return true;
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, new UpgradableProperty[]{UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemConsuming, UpgradableProperty.ItemProducing, UpgradableProperty.FluidProducing});
    }
}

