/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.transfernodes;

import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.transfernodes.IUpgradeProvider;
import com.rwtema.extrautils2.utils.Lang;
import java.util.List;
import net.minecraft.item.ItemStack;

public enum Upgrade {
    STACK_SIZE(1, 5.0f),
    SPEED(20, 1.0f),
    MINING(1, 10.0f);

    static final float PENALTY = 0.26666668f;
    public final int maxLevel;
    public final float power;

    private Upgrade(int maxLevel, float power) {
        this.maxLevel = maxLevel;
        this.power = power;
    }

    public static void addTooltip(List<String> tooltip, ItemStack stack, IUpgradeProvider item) {
        Upgrade upgrade = item.getUpgrade(stack);
        if (upgrade != null) {
            int stackSize = StackHelper.getStacksize(stack);
            int maxLevel = upgrade.maxLevel;
            tooltip.add(Lang.translateArgs("Max Upgrades: %s", maxLevel));
            if (upgrade.power > 0.0f) {
                if (maxLevel == 1) {
                    tooltip.add(Lang.translateArgs("Power Penalty: +%s GP", Float.valueOf(upgrade.getPowerUse(1))));
                } else {
                    tooltip.add(Lang.translateArgs("Power Penalty (level 1): +%s GP", Float.valueOf(upgrade.getPowerUse(1))));
                    if (stackSize > 1 && maxLevel > 1) {
                        tooltip.add(Lang.translateArgs("Power Penalty (level %s): +%s GP", Math.min(stackSize, maxLevel), Float.valueOf(upgrade.getPowerUse(Math.min(stackSize, maxLevel)))));
                    }
                }
            }
        }
    }

    public int getModifierLevel(int level) {
        return level;
    }

    public float getPowerUse(int level) {
        return (float)level * this.power;
    }
}

