/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.gui.backend;

import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicWindow;
import com.rwtema.extrautils2.gui.backend.IWidget;
import com.rwtema.extrautils2.gui.backend.IWidgetClientTick;
import com.rwtema.extrautils2.gui.backend.IWidgetKeyInput;
import com.rwtema.extrautils2.gui.backend.IWidgetMouseInput;
import com.rwtema.extrautils2.gui.backend.WidgetButton;
import com.rwtema.extrautils2.utils.client.GLStateAttributes;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class DynamicGui
extends GuiContainer {
    public static final ResourceLocation texWidgets = new ResourceLocation("extrautils2", "textures/gui_widget.png");
    public final DynamicContainer container;
    public int mouseX;
    public int mouseY;
    TIntObjectHashMap<WidgetButton> buttonWidgets = new TIntObjectHashMap();

    public DynamicGui(DynamicContainer container) {
        super((Container)container);
        container.isClient = true;
        this.container = container;
        container.loadGuiDimensions(this);
    }

    public int nextButtonID() {
        return this.field_146292_n.size();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int y = 0;
        for (DynamicWindow dynamicWindow : this.container.getWindowWidgets().keySet()) {
            if (dynamicWindow == null) continue;
            Set iWidgets = this.container.getWindowWidgets().get((Object)dynamicWindow);
            dynamicWindow.crop(iWidgets);
            dynamicWindow.x = dynamicWindow.side == DynamicWindow.WindowSide.LEFT ? -dynamicWindow.w : this.container.width;
            dynamicWindow.y = y;
            for (IWidget widget : iWidgets) {
                if (!(widget instanceof Slot)) continue;
                Slot slot = (Slot)widget;
                slot.field_75223_e = widget.getX() + dynamicWindow.x + 1;
                slot.field_75221_f = widget.getY() + dynamicWindow.y + 1;
            }
        }
        this.container.loadGuiDimensions(this);
        for (IWidget widget : this.container.getWidgets()) {
            widget.addToGui(this);
        }
    }

    public void addButton(WidgetButton widgetButton, GuiButton button) {
        this.buttonWidgets.put(button.field_146127_k, (Object)widgetButton);
        this.field_146292_n.add(button);
    }

    public void func_73876_c() {
        super.func_73876_c();
        for (IWidgetClientTick clientTick : this.container.getWidgetClientTick()) {
            clientTick.updateClient();
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        WidgetButton widgetButton;
        super.func_146284_a(button);
        if (button.field_146124_l && (widgetButton = (WidgetButton)this.buttonWidgets.get(button.field_146127_k)) != null) {
            widgetButton.onClientClick();
        }
    }

    public float getZLevel() {
        return this.field_73735_i;
    }

    public int getXSize() {
        return this.field_146999_f;
    }

    public int getYSize() {
        return this.field_147000_g;
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public ResourceLocation getWidgetTexture() {
        return texWidgets;
    }

    public void drawScaledBox(ResourceLocation location, int x, int y, int w, int h) {
        this.field_146297_k.field_71446_o.func_110577_a(location);
        int dx = w / 2;
        int dy = h / 2;
        this.func_73729_b(this.field_147003_i + x, this.field_147009_r + y, 0, 0, dx, dy);
        this.func_73729_b(this.field_147003_i + x + dx, this.field_147009_r + y, 256 - dx, 0, dx, dy);
        this.func_73729_b(this.field_147003_i + x, this.field_147009_r + y + dy, 0, 256 - dy, dx, dy);
        this.func_73729_b(this.field_147003_i + x + dx, this.field_147009_r + y + dy, 256 - dx, 256 - dy, dx, dy);
    }

    protected void func_146976_a(float f, int a, int b) {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        for (DynamicWindow dynamicWindow : this.container.getWindowWidgets().keySet()) {
            GLStateAttributes glStateAttributes;
            if (dynamicWindow == null) {
                if (!this.container.drawBackgroundOverride(this)) {
                    this.field_146297_k.field_71446_o.func_110577_a(DynamicContainer.texBackground);
                    this.drawBasicBackground(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
                }
                this.field_146297_k.field_71446_o.func_110577_a(this.getWidgetTexture());
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                glStateAttributes = GLStateAttributes.loadStates();
                for (IWidget widget : this.container.getWindowWidgets().get(null)) {
                    widget.renderBackground(this.field_146297_k.field_71446_o, this, this.field_147003_i, this.field_147009_r);
                    glStateAttributes.restore();
                }
                continue;
            }
            if (!dynamicWindow.drawBackgroundOverride(this, this.container)) {
                this.field_146297_k.field_71446_o.func_110577_a(DynamicContainer.texBackground);
                GlStateManager.func_179124_c((float)dynamicWindow.r, (float)dynamicWindow.g, (float)dynamicWindow.b);
                this.drawBasicBackground(this.field_147003_i + dynamicWindow.x, this.field_147009_r + dynamicWindow.y, dynamicWindow.w, dynamicWindow.h);
            }
            this.field_146297_k.field_71446_o.func_110577_a(this.getWidgetTexture());
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            glStateAttributes = GLStateAttributes.loadStates();
            for (IWidget widget : this.container.getWindowWidgets().get((Object)dynamicWindow)) {
                widget.renderBackground(this.field_146297_k.field_71446_o, this, this.field_147003_i + dynamicWindow.x, this.field_147009_r + dynamicWindow.y);
                glStateAttributes.restore();
            }
        }
    }

    public void drawBasicBackground(int x, int y, int w, int h) {
        int w2 = w >> 1;
        int h2 = h >> 1;
        int w3 = w - w2;
        int h3 = h - h2;
        this.func_73729_b(x, y, 0, 0, w2, h2);
        this.func_73729_b(x + w2, y, 256 - w3, 0, w3, h2);
        this.func_73729_b(x, y + h2, 0, 256 - h3, w2, h3);
        this.func_73729_b(x + w2, y + h2, 256 - w3, 256 - h3, w3, h3);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        List<String> tooltip = null;
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GLStateAttributes glStateAttributes = GLStateAttributes.loadStates();
        for (DynamicWindow dynamicWindow : this.container.getWindowWidgets().keySet()) {
            tooltip = dynamicWindow == null ? this.renderForeground(mouseX, mouseY, tooltip, null, this.field_147003_i, this.field_147009_r) : this.renderForeground(mouseX, mouseY, tooltip, dynamicWindow, this.field_147003_i + dynamicWindow.x, this.field_147009_r + dynamicWindow.y);
            glStateAttributes.restore();
        }
        if (tooltip != null) {
            FontRenderer fontRenderer = this.getFontRenderer();
            ArrayList strings = new ArrayList();
            int w = 1000;
            for (String s : tooltip) {
                strings.addAll(fontRenderer.func_78271_c(s, w));
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(-this.field_147003_i), (float)(-this.field_147009_r), (float)0.0f);
            this.drawHoveringText(strings, mouseX, mouseY, fontRenderer);
            GlStateManager.func_179121_F();
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
        }
        RenderHelper.func_74520_c();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
    }

    private List<String> renderForeground(int mouseX, int mouseY, List<String> tooltip, DynamicWindow dynamicWindow, int guiX, int guiY) {
        for (IWidget widget : this.container.getWindowWidgets().get((Object)dynamicWindow)) {
            List<String> t;
            this.field_146297_k.field_71446_o.func_110577_a(this.getWidgetTexture());
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            widget.renderForeground(this.field_146297_k.field_71446_o, this, guiX - this.field_147003_i, guiY - this.field_147009_r);
            if (!this.isInArea(mouseX, mouseY, widget) || (t = widget.getToolTip()) == null) continue;
            if (tooltip == null) {
                tooltip = new ArrayList<String>();
            }
            tooltip.addAll(t);
        }
        return tooltip;
    }

    public boolean isInArea(int x, int y, IWidget w) {
        DynamicWindow dynamicWindow = this.container.getWindowOwner().get(w);
        if (dynamicWindow == null) {
            x -= this.field_147003_i;
            y -= this.field_147009_r;
        } else {
            x -= dynamicWindow.x + this.field_147003_i;
            y -= dynamicWindow.y + this.field_147009_r;
        }
        return x >= w.getX() && x < w.getX() + w.getW() && y >= w.getY() && y < w.getY() + w.getH();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        for (IWidgetKeyInput input : this.container.getWidgetKeyInputs()) {
            if (!input.keyTyped(typedChar, keyCode)) continue;
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    public void func_146274_d() throws IOException {
        this.mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        this.mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        for (IWidgetMouseInput widgetMouseInput : this.container.getWidgetMouseInputs()) {
            widgetMouseInput.mouseTick(x, y, this.isInArea(x, y, widgetMouseInput));
        }
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        for (IWidgetMouseInput widgetMouseInput : this.container.getWidgetMouseInputs()) {
            widgetMouseInput.mouseWheelScroll(i, this.isInArea(x, y, widgetMouseInput));
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int mouseButton) {
        super.func_146286_b(mouseX, mouseY, mouseButton);
        for (IWidgetMouseInput mouseInput : this.container.getWidgetMouseInputs()) {
            mouseInput.mouseReleased(mouseX, mouseY, mouseButton, this.isInArea(mouseX, mouseY, mouseInput));
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        for (IWidgetMouseInput mouseInput : this.container.getWidgetMouseInputs()) {
            mouseInput.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick, this.isInArea(mouseX, mouseY, mouseInput));
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (IWidgetMouseInput mouseInput : this.container.getWidgetMouseInputs()) {
            mouseInput.mouseClicked(mouseX, mouseY, mouseButton, this.isInArea(mouseX, mouseY, mouseInput));
        }
    }

    public void func_73730_a(int startX, int endX, int y, int color) {
        super.func_73730_a(startX, endX, y, color);
    }

    public void func_73728_b(int x, int startY, int endY, int color) {
        super.func_73728_b(x, startY, endY, color);
    }

    public void func_73733_a(int left, int top, int right, int bottom, int startColor, int endColor) {
        super.func_73733_a(left, top, right, bottom, startColor, endColor);
    }

    public void func_73732_a(FontRenderer fontRendererIn, @Nonnull String text, int x, int y, int color) {
        super.func_73732_a(fontRendererIn, text, x, y, color);
    }

    public void func_73731_b(FontRenderer fontRendererIn, @Nonnull String text, int x, int y, int color) {
        super.func_73731_b(fontRendererIn, text, x, y, color);
    }

    public void func_73729_b(int x, int y, int textureX, int textureY, int width, int height) {
        super.func_73729_b(x, y, textureX, textureY, width, height);
    }

    public void func_175174_a(float xCoord, float yCoord, int minU, int minV, int maxU, int maxV) {
        super.func_175174_a(xCoord, yCoord, minU, minV, maxU, maxV);
    }

    public void func_175175_a(int xCoord, int yCoord, TextureAtlasSprite textureSprite, int widthIn, int heightIn) {
        super.func_175175_a(xCoord, yCoord, textureSprite, widthIn, heightIn);
    }

    public void drawTexturedModalRect(double xCoord, double yCoord, float w, float h, double minU, double minV, double maxU, double maxV) {
        float f = 1.0f;
        float f1 = 1.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b(xCoord + 0.0, yCoord + (double)h, (double)this.field_73735_i).func_187315_a(minU * (double)f, maxV * (double)f1).func_181675_d();
        vertexbuffer.func_181662_b(xCoord + (double)w, yCoord + (double)h, (double)this.field_73735_i).func_187315_a(maxU * (double)f, maxV * (double)f1).func_181675_d();
        vertexbuffer.func_181662_b(xCoord + (double)w, yCoord + 0.0, (double)this.field_73735_i).func_187315_a(maxU * (double)f, minV * (double)f1).func_181675_d();
        vertexbuffer.func_181662_b(xCoord + 0.0, yCoord + 0.0, (double)this.field_73735_i).func_187315_a(minU * (double)f, minV * (double)f1).func_181675_d();
        tessellator.func_78381_a();
    }

    public void renderStack(ItemStack stack, int x, int y, String altText) {
        if (StackHelper.isNull(stack)) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 200.0f;
        this.field_146296_j.field_77023_b = 200.0f;
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = this.field_146289_q;
        }
        this.field_146296_j.func_180450_b(stack, x, y);
        this.field_146296_j.func_180453_a(font, stack, x, y, altText);
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
        GlStateManager.func_179121_F();
    }

    public void drawRectangle(int x, int y, int w, int h, int color) {
        DynamicGui.func_73734_a((int)x, (int)y, (int)(x + w), (int)(y + h), (int)color);
    }

    public void drawSlotBackground(int x, int y) {
        this.func_73729_b(x, y, 0, 0, 18, 18);
    }

    public void renderSmallStackText(ItemStack stack, String s, int x, int y) {
        if (StackHelper.isNull(stack)) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 200.0f;
        this.field_146296_j.field_77023_b = 200.0f;
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = this.field_146289_q;
        }
        this.field_146296_j.func_180450_b(stack, x, y);
        this.field_146296_j.func_180453_a(font, stack, x, y, "");
        if (!StringUtils.func_151246_b((String)s)) {
            float scaledFontWidth;
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179084_k();
            float scale = 2.0f;
            while (true) {
                float f;
                scaledFontWidth = (float)this.field_146289_q.func_78256_a(s) / scale;
                if (!(f >= 15.0f)) break;
                scale += 1.0f;
            }
            GlStateManager.func_179109_b((float)((float)(x + 16) - scaledFontWidth), (float)((float)(y + 17) - 9.0f / scale), (float)0.0f);
            GlStateManager.func_179152_a((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
            this.field_146289_q.func_175063_a(s, 0.0f, 0.0f, 0xFFFFFF);
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
        }
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
        GlStateManager.func_179121_F();
    }

    public void renderFluidTiled(FluidStack fluidStack, TextureManager manager, int x, int y, int w, int h) {
        if (fluidStack == null) {
            return;
        }
        Fluid fluid = fluidStack.getFluid();
        if (w == 0 || h == 0) {
            return;
        }
        ResourceLocation fluidStill = fluid.getStill(fluidStack);
        if (fluidStill == null) {
            return;
        }
        TextureAtlasSprite sprite = null;
        sprite = Minecraft.func_71410_x().func_147117_R().getTextureExtry(fluidStill.toString());
        if (sprite == null) {
            sprite = Textures.MISSING_SPRITE;
        }
        manager.func_110577_a(TextureMap.field_110575_b);
        int color = fluid.getColor(fluidStack);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179124_c((float)red, (float)green, (float)blue);
        for (int dx1 = x; dx1 < x + w; dx1 += 16) {
            for (int dy1 = y; dy1 < y + h; dy1 += 16) {
                int dx2 = Math.min(dx1 + 16, x + w);
                int dy2 = Math.min(dy1 + 16, y + h);
                int w1 = dx2 - dx1;
                int h1 = dy2 - dy1;
                this.drawTexturedModalRect(dx1, dy1, w1, h1, sprite.func_94209_e(), sprite.func_94206_g(), sprite.func_94214_a((double)w1), sprite.func_94207_b((double)h1));
            }
        }
    }
}

