/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.init;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.StringUtils;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import team.chisel.api.render.BlockRenderType;
import team.chisel.api.render.IBlockRenderType;

public class TextureTypeRegistry {
    private static Map<String, IBlockRenderType> map = Maps.newHashMap();

    public static void preInit(FMLPreInitializationEvent event) {
        Set annots = event.getAsmData().getAll(BlockRenderType.class.getName());
        for (ASMDataTable.ASMData data : annots) {
            String name = (String)data.getAnnotationInfo().get("value");
            if (StringUtils.func_151246_b((String)name)) {
                name = data.getObjectName();
                name = name.substring(name.lastIndexOf(46) + 1);
            }
            try {
                TextureTypeRegistry.register(name, (IBlockRenderType)Class.forName(data.getClassName()).newInstance());
            }
            catch (InstantiationException e) {
                try {
                    Class<?> c = Class.forName(data.getClassName());
                    TextureTypeRegistry.register(name, (IBlockRenderType)c.getDeclaredField(data.getObjectName()).get(null));
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e1) {
                    Throwables.propagate((Throwable)e1);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException e) {
                Throwables.propagate((Throwable)e);
            }
        }
    }

    public static void register(String name, IBlockRenderType type) {
        String key = name.toUpperCase(Locale.US);
        if (map.containsKey(key) && map.get(key) != type) {
            throw new IllegalArgumentException("Render Type with name " + key + " has already been registered!");
        }
        if (map.get(key) != type) {
            map.put(key, type);
        }
    }

    public static IBlockRenderType getType(String name) {
        String key = name.toUpperCase(Locale.US);
        return map.get(key);
    }

    public static boolean isValid(String name) {
        return map.containsKey(name);
    }
}

