/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.render.texture;

import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ResourceLocation;
import team.chisel.api.render.IBlockRenderType;
import team.chisel.api.render.IChiselTexture;
import team.chisel.api.render.TextureInfo;
import team.chisel.api.render.TextureSpriteCallback;

public abstract class AbstractChiselTexture<T extends IBlockRenderType>
implements IChiselTexture<T> {
    protected T type;
    protected BlockRenderLayer layer;
    protected TextureSpriteCallback[] sprites;
    protected boolean fullbright;
    protected Optional<JsonObject> info;

    public AbstractChiselTexture(T type, BlockRenderLayer layer, TextureSpriteCallback ... sprites) {
        this.type = type;
        this.layer = layer;
        this.sprites = sprites;
    }

    public AbstractChiselTexture(T type, TextureInfo info) {
        this.type = type;
        this.layer = info.getRenderLayer();
        this.sprites = info.getSprites();
        this.fullbright = info.getFullbright();
        this.info = info.getInfo();
    }

    @Override
    public TextureAtlasSprite getParticle() {
        return this.sprites[0].getSprite();
    }

    @Override
    public Collection<ResourceLocation> getTextures() {
        return Arrays.stream(this.sprites).map(TextureSpriteCallback::getLocation).collect(Collectors.toList());
    }

    @Override
    public T getType() {
        return this.type;
    }

    @Override
    public BlockRenderLayer getLayer() {
        return this.layer;
    }
}

