/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.render.ctx;

import com.google.common.base.Preconditions;
import java.util.EnumMap;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.vecmath.Point2i;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import team.chisel.client.render.ctx.BlockRenderContextPosition;
import team.chisel.client.render.texture.ChiselTextureMap;

@ParametersAreNonnullByDefault
public abstract class BlockRenderContextGridTexture
extends BlockRenderContextPosition {
    private final EnumMap<EnumFacing, Point2i> textureCoords = new EnumMap(EnumFacing.class);
    private final long serialized;

    public BlockRenderContextGridTexture(BlockPos pos, ChiselTextureMap tex) {
        super(pos);
        Preconditions.checkArgument((tex.getXSize() * tex.getYSize() < 1024 ? 1 : 0) != 0, (String)"V* Texture size too large for texture %s", (Object[])new Object[]{tex.getParticle()});
        long serialized = 0L;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            Point2i coords = this.calculateTextureCoord(pos, tex, side);
            this.textureCoords.put(side, coords);
            serialized |= (long)(coords.x + coords.y * tex.getXSize() << 10 * side.ordinal());
        }
        this.serialized = serialized;
    }

    protected abstract Point2i calculateTextureCoord(BlockPos var1, ChiselTextureMap var2, EnumFacing var3);

    public Point2i getTextureCoords(EnumFacing side) {
        return this.textureCoords.get(side);
    }

    @Override
    public long getCompressedData() {
        return this.serialized;
    }

    public static class Random
    extends BlockRenderContextGridTexture {
        private static final java.util.Random rand = new java.util.Random();

        public Random(BlockPos pos, ChiselTextureMap tex) {
            super(pos, tex);
        }

        @Override
        protected Point2i calculateTextureCoord(BlockPos pos, ChiselTextureMap tex, EnumFacing side) {
            rand.setSeed(MathHelper.func_180186_a((Vec3i)pos) + (long)side.ordinal());
            rand.nextBoolean();
            int w = tex.getXSize();
            int h = tex.getYSize();
            int tx = rand.nextInt(w) + 1;
            int ty = rand.nextInt(h) + 1;
            return new Point2i(tx, ty);
        }
    }

    public static class Patterned
    extends BlockRenderContextGridTexture {
        public Patterned(BlockPos pos, ChiselTextureMap tex) {
            super(pos, tex);
        }

        @Override
        protected Point2i calculateTextureCoord(BlockPos pos, ChiselTextureMap tex, EnumFacing side) {
            int ty;
            int tx;
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            if (side.func_176740_k().func_176720_b()) {
                tx = x % tex.getXSize();
                ty = (side.func_96559_d() * z + 1) % tex.getYSize();
            } else if (side.func_176740_k() == EnumFacing.Axis.Z) {
                tx = x % tex.getXSize();
                ty = -y % tex.getYSize();
            } else {
                tx = (z + 1) % tex.getXSize();
                ty = -y % tex.getYSize();
            }
            if (side == EnumFacing.NORTH || side == EnumFacing.EAST) {
                tx = (tex.getXSize() - tx - 1) % tex.getXSize();
            }
            if (tx < 0) {
                tx += tex.getXSize();
            }
            if (ty < 0) {
                ty += tex.getYSize();
            }
            return new Point2i(tx, ty);
        }
    }
}

