/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.render.ctm;

import com.google.common.base.Optional;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import team.chisel.api.IFacade;
import team.chisel.client.render.ConnectionLocations;
import team.chisel.client.render.ctm.ISubmap;
import team.chisel.client.render.ctm.Submap;
import team.chisel.common.util.Dir;

@ParametersAreNonnullByDefault
public class CTM {
    public static final ISubmap[] uvs = new ISubmap[]{new Submap(4.0f, 4.0f, 0.0f, 0.0f), new Submap(4.0f, 4.0f, 4.0f, 0.0f), new Submap(4.0f, 4.0f, 8.0f, 0.0f), new Submap(4.0f, 4.0f, 12.0f, 0.0f), new Submap(4.0f, 4.0f, 0.0f, 4.0f), new Submap(4.0f, 4.0f, 4.0f, 4.0f), new Submap(4.0f, 4.0f, 8.0f, 4.0f), new Submap(4.0f, 4.0f, 12.0f, 4.0f), new Submap(4.0f, 4.0f, 0.0f, 8.0f), new Submap(4.0f, 4.0f, 4.0f, 8.0f), new Submap(4.0f, 4.0f, 8.0f, 8.0f), new Submap(4.0f, 4.0f, 12.0f, 8.0f), new Submap(4.0f, 4.0f, 0.0f, 12.0f), new Submap(4.0f, 4.0f, 4.0f, 12.0f), new Submap(4.0f, 4.0f, 8.0f, 12.0f), new Submap(4.0f, 4.0f, 12.0f, 12.0f), new Submap(8.0f, 8.0f, 0.0f, 0.0f), new Submap(8.0f, 8.0f, 8.0f, 0.0f), new Submap(8.0f, 8.0f, 0.0f, 8.0f), new Submap(8.0f, 8.0f, 8.0f, 8.0f)};
    public static final ISubmap FULL_TEXTURE = new Submap(16.0f, 16.0f, 0.0f, 0.0f);
    protected static int[] submapOffsets = new int[]{4, 5, 1, 0};
    public static boolean disableObscuredFaceCheckConfig = false;
    public Optional<Boolean> disableObscuredFaceCheck = Optional.absent();
    protected static final Dir[][] submapMap = new Dir[][]{{Dir.BOTTOM, Dir.LEFT, Dir.BOTTOM_LEFT}, {Dir.BOTTOM, Dir.RIGHT, Dir.BOTTOM_RIGHT}, {Dir.TOP, Dir.RIGHT, Dir.TOP_RIGHT}, {Dir.TOP, Dir.LEFT, Dir.TOP_LEFT}};
    protected byte connectionMap;
    protected int[] submapCache = new int[]{18, 19, 17, 16};
    protected boolean ignoreStates;

    public static CTM getInstance() {
        return new CTM();
    }

    public int[] createSubmapIndices(@Nullable IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (world == null) {
            return this.submapCache;
        }
        this.buildConnectionMap(world, pos, side);
        for (int i = 0; i < 4; ++i) {
            this.fillSubmaps(i);
        }
        return this.submapCache;
    }

    public int[] createSubmapIndices(long data, EnumFacing side) {
        this.submapCache = new int[]{18, 19, 17, 16};
        this.buildConnectionMap(data, side);
        for (int i = 0; i < 4; ++i) {
            this.fillSubmaps(i);
        }
        return this.submapCache;
    }

    public int[] getSubmapIndices() {
        return this.submapCache;
    }

    public long serialized() {
        return Byte.toUnsignedLong(this.connectionMap);
    }

    public static boolean isDefaultTexture(int id) {
        return id == 16 || id == 17 || id == 18 || id == 19;
    }

    protected void setConnectedState(Dir dir, boolean connected) {
        this.connectionMap = connected ? (byte)(this.connectionMap | 1 << dir.ordinal()) : (byte)(this.connectionMap & ~(1 << dir.ordinal()));
    }

    public void buildConnectionMap(IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_185894_c(world, pos, side)) {
            for (Dir dir : Dir.VALUES) {
                this.setConnectedState(dir, dir.isConnected(this, world, pos, side, state));
            }
        }
    }

    public void buildConnectionMap(long data, EnumFacing side) {
        this.connectionMap = 0;
        List<ConnectionLocations> connections = ConnectionLocations.decode(data);
        for (ConnectionLocations loc : connections) {
            Dir dir;
            if (loc.getDirForSide(side) == null || (dir = loc.getDirForSide(side)) == null) continue;
            this.setConnectedState(dir, true);
        }
    }

    private void fillSubmaps(int idx) {
        Dir[] dirs = submapMap[idx];
        if (this.connectedOr(dirs[0], dirs[1])) {
            this.submapCache[idx] = this.connectedAnd(dirs) ? submapOffsets[idx] : submapOffsets[idx] + (this.connected(dirs[0]) ? 2 : 0) + (this.connected(dirs[1]) ? 8 : 0);
        }
    }

    public boolean connected(Dir dir) {
        return (this.connectionMap >> dir.ordinal() & 1) == 1;
    }

    public boolean connectedAnd(Dir ... dirs) {
        for (Dir dir : dirs) {
            if (this.connected(dir)) continue;
            return false;
        }
        return true;
    }

    public boolean connectedOr(Dir ... dirs) {
        for (Dir dir : dirs) {
            if (!this.connected(dir)) continue;
            return true;
        }
        return false;
    }

    public boolean isConnected(IBlockAccess world, BlockPos current, BlockPos connection, EnumFacing dir) {
        IBlockState state = world.func_180495_p(current);
        return this.isConnected(world, current, connection, dir, state);
    }

    public boolean isConnected(IBlockAccess world, BlockPos current, BlockPos connection, EnumFacing dir, IBlockState state) {
        boolean ret;
        IBlockState obscuring;
        BlockPos pos2 = connection.func_177971_a(dir.func_176730_m());
        boolean disableObscured = (Boolean)this.disableObscuredFaceCheck.or((Object)disableObscuredFaceCheckConfig);
        IBlockState con = CTM.getBlockOrFacade(world, connection, dir);
        IBlockState iBlockState = obscuring = disableObscured ? null : CTM.getBlockOrFacade(world, pos2, dir);
        if (con == null) {
            throw new IllegalStateException("Error, received null blockstate as facade from block " + world.func_180495_p(connection));
        }
        boolean bl = this.ignoreStates ? con.func_177230_c() == state.func_177230_c() : (ret = con == state);
        if (obscuring == null) {
            return ret;
        }
        return ret &= !obscuring.equals(state);
    }

    public static IBlockState getBlockOrFacade(IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof IFacade) {
            return ((IFacade)state.func_177230_c()).getFacade(world, pos, side);
        }
        return state;
    }

    public CTM ignoreStates(boolean ignoreStates) {
        this.ignoreStates = ignoreStates;
        return this;
    }
}

