/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.cartography.render;

import java.awt.image.BufferedImage;
import journeymap.client.cartography.IChunkRenderer;
import journeymap.client.cartography.RGB;
import journeymap.client.cartography.Strata;
import journeymap.client.cartography.Stratum;
import journeymap.client.cartography.render.BaseRenderer;
import journeymap.client.log.StatTimer;
import journeymap.client.model.BlockCoordIntPair;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.MapType;
import journeymap.client.render.ComparableBufferedImage;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.util.math.BlockPos;
import org.apache.logging.log4j.Level;

public class SurfaceRenderer
extends BaseRenderer
implements IChunkRenderer {
    protected StatTimer renderSurfaceTimer = StatTimer.get("SurfaceRenderer.renderSurface");
    protected StatTimer renderSurfacePrepassTimer = StatTimer.get("SurfaceRenderer.renderSurface.CavePrepass");
    protected Strata strata = new Strata("Surface", 40, 8, false);
    protected float maxDepth = 8.0f;

    public SurfaceRenderer() {
        this.updateOptions(null, null);
    }

    @Override
    protected boolean updateOptions(ChunkMD chunkMd, MapType mapType) {
        if (super.updateOptions(chunkMd, mapType)) {
            this.ambientColor = RGB.floats(this.tweakSurfaceAmbientColor);
            return true;
        }
        return false;
    }

    @Override
    public int getBlockHeight(ChunkMD chunkMd, BlockPos blockPos) {
        Integer y = this.getBlockHeight(chunkMd, blockPos.func_177958_n() & 0xF, null, blockPos.func_177952_p() & 0xF, null, null);
        return y == null ? blockPos.func_177956_o() : y.intValue();
    }

    @Override
    public boolean render(ComparableBufferedImage dayChunkImage, ChunkMD chunkMd, Integer ignored) {
        return this.render(dayChunkImage, null, chunkMd, null, false);
    }

    public boolean render(ComparableBufferedImage dayChunkImage, BufferedImage nightChunkImage, ChunkMD chunkMd) {
        return this.render(dayChunkImage, nightChunkImage, chunkMd, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean render(ComparableBufferedImage dayChunkImage, BufferedImage nightChunkImage, ChunkMD chunkMd, Integer vSlice, boolean cavePrePass) {
        StatTimer timer = cavePrePass ? this.renderSurfacePrepassTimer : this.renderSurfaceTimer;
        try {
            timer.start();
            this.updateOptions(chunkMd, MapType.from(MapType.Name.surface, null, chunkMd.getDimension()));
            if (!this.hasSlopes(chunkMd, vSlice)) {
                this.populateSlopes(chunkMd, vSlice, this.getSlopes(chunkMd, vSlice));
            }
            boolean bl = this.renderSurface(dayChunkImage, nightChunkImage, chunkMd, vSlice, cavePrePass);
            return bl;
        }
        catch (Throwable e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            this.strata.reset();
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean renderSurface(BufferedImage dayChunkImage, BufferedImage nightChunkImage, ChunkMD chunkMd, Integer vSlice, boolean cavePrePass) {
        boolean chunkOk = false;
        try {
            int sliceMaxY = 0;
            if (cavePrePass) {
                int[] sliceBounds = this.getVSliceBounds(chunkMd, vSlice);
                sliceMaxY = sliceBounds[1];
            }
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    this.strata.reset();
                    BlockMD topBlockMd = null;
                    int standardY = Math.max(0, this.getBlockHeight(chunkMd, x, null, z, null, null));
                    if (standardY == 0) {
                        this.paintVoidBlock(dayChunkImage, x, z);
                        if (!cavePrePass && nightChunkImage != null) {
                            this.paintVoidBlock(nightChunkImage, x, z);
                        }
                        chunkOk = true;
                        continue;
                    }
                    if (cavePrePass && standardY > sliceMaxY && (float)(standardY - sliceMaxY) > this.maxDepth) {
                        chunkOk = true;
                        this.paintBlackBlock(dayChunkImage, x, z);
                        continue;
                    }
                    int roofY = 0;
                    int y = standardY;
                    roofY = Math.max(0, chunkMd.getPrecipitationHeight(x, z));
                    if (standardY < roofY) {
                        for (int checkY = roofY; checkY > standardY; --checkY) {
                            topBlockMd = BlockMD.getBlockMDFromChunkLocal(chunkMd, x, checkY, z);
                            if (!topBlockMd.isTransparentRoof()) continue;
                            y = Math.max(standardY, checkY);
                            break;
                        }
                    }
                    if (roofY == 0 || standardY == 0) {
                        this.paintVoidBlock(dayChunkImage, x, z);
                        if (!cavePrePass && nightChunkImage != null) {
                            this.paintVoidBlock(nightChunkImage, x, z);
                        }
                        chunkOk = true;
                        continue;
                    }
                    if (this.mapBathymetry) {
                        Integer[][] waterHeights = this.getWaterHeights(chunkMd, null);
                        Integer waterHeight = waterHeights[z][x];
                        if (waterHeight == null) {
                            waterHeights[z][x] = standardY;
                        } else {
                            standardY = waterHeight;
                        }
                    }
                    if ((topBlockMd = chunkMd.getTopBlockMD(x, standardY, z)) == null) {
                        this.paintBadBlock(dayChunkImage, x, standardY, z);
                        this.paintBadBlock(nightChunkImage, x, standardY, z);
                        continue;
                    }
                    if (this.mapPlants || this.mapCrops) {
                        BlockMD temp = chunkMd.getTopBlockMD(x, standardY + 1, z);
                        if (this.mapPlants && temp.hasFlag(BlockMD.Flag.Plant) || this.mapCrops && temp.hasFlag(BlockMD.Flag.Crop)) {
                            ++standardY;
                        }
                    }
                    this.buildStrata(this.strata, roofY, chunkMd, x, standardY, z);
                    chunkOk = this.paintStrata(this.strata, dayChunkImage, nightChunkImage, chunkMd, topBlockMd, vSlice, x, y, z, cavePrePass) || chunkOk;
                }
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().log(Level.WARN, LogFormatter.toString(t));
        }
        finally {
            this.strata.reset();
        }
        return chunkOk;
    }

    public int getSurfaceBlockHeight(ChunkMD chunkMd, int x, int z, BlockCoordIntPair offset, int defaultVal) {
        ChunkMD targetChunkMd = this.getOffsetChunk(chunkMd, x, z, offset);
        int newX = (chunkMd.getCoord().field_77276_a << 4) + (x + offset.x) & 0xF;
        int newZ = (chunkMd.getCoord().field_77275_b << 4) + (z + offset.z) & 0xF;
        if (targetChunkMd != null) {
            Integer height = this.getBlockHeight(targetChunkMd, newX, null, newZ, null, null);
            if (height == null) {
                return defaultVal;
            }
            return height;
        }
        return defaultVal;
    }

    @Override
    public Integer getBlockHeight(ChunkMD chunkMd, int localX, Integer vSlice, int localZ, Integer sliceMinY, Integer sliceMaxY) {
        Integer[][] heights = this.getHeights(chunkMd, null);
        if (heights == null) {
            return null;
        }
        Integer y = heights[localX][localZ];
        if (y != null) {
            return y;
        }
        y = Math.max(0, chunkMd.getPrecipitationHeight(localX, localZ));
        if (y == 0) {
            return 0;
        }
        boolean propUnsetWaterHeight = true;
        try {
            while (y > 0) {
                Integer n;
                Integer n2;
                BlockMD blockMD = BlockMD.getBlockMDFromChunkLocal(chunkMd, localX, y, localZ);
                if (blockMD.isAir()) {
                    n2 = y;
                    n = y = Integer.valueOf(y - 1);
                    continue;
                }
                if (blockMD.isWater()) {
                    if (this.mapBathymetry) {
                        if (propUnsetWaterHeight) {
                            this.getWaterHeights((ChunkMD)chunkMd, null)[localZ][localX] = y;
                            propUnsetWaterHeight = false;
                        }
                        n2 = y;
                        n = y = Integer.valueOf(y - 1);
                        continue;
                    }
                } else if (blockMD.hasFlag(BlockMD.Flag.Plant)) {
                    if (!this.mapPlants) {
                        n2 = y;
                        n = y = Integer.valueOf(y - 1);
                        continue;
                    }
                    if (!this.mapPlantShadows || !blockMD.hasNoShadow()) {
                        n2 = y;
                        n = y = Integer.valueOf(y - 1);
                    }
                } else if (blockMD.hasFlag(BlockMD.Flag.Crop)) {
                    if (!this.mapCrops) {
                        n2 = y;
                        n = y = Integer.valueOf(y - 1);
                        continue;
                    }
                    if (!this.mapPlantShadows || !blockMD.hasNoShadow()) {
                        n2 = y;
                        n = y = Integer.valueOf(y - 1);
                    }
                } else if (!blockMD.isLava() && blockMD.hasNoShadow()) {
                    n2 = y;
                    n = y = Integer.valueOf(y - 1);
                }
                break;
            }
        }
        catch (Exception e) {
            Journeymap.getLogger().warn(String.format("Couldn't get safe surface block height for %s coords %s,%s: %s", chunkMd, localX, localZ, LogFormatter.toString(e)));
        }
        heights[localX][localZ] = y = Integer.valueOf(Math.max(0, y));
        return y;
    }

    protected void buildStrata(Strata strata, int roofY, ChunkMD chunkMd, int x, int y, int z) {
        BlockMD blockMD;
        if (roofY > y) {
            while (roofY > y) {
                blockMD = BlockMD.getBlockMDFromChunkLocal(chunkMd, x, roofY, z);
                if (!blockMD.isAir() && blockMD.isTransparentRoof()) {
                    strata.push(chunkMd, blockMD, x, roofY, z);
                    if (!this.mapTransparency) break;
                }
                --roofY;
            }
        }
        if (this.mapTransparency || strata.isEmpty()) {
            while (y >= 0) {
                blockMD = BlockMD.getBlockMDFromChunkLocal(chunkMd, x, y, z);
                if (!blockMD.isAir()) {
                    strata.push(chunkMd, blockMD, x, y, z);
                    if (blockMD.getAlpha() == 1.0f || !this.mapTransparency) break;
                }
                --y;
            }
        }
    }

    protected boolean paintStrata(Strata strata, BufferedImage dayChunkImage, BufferedImage nightChunkImage, ChunkMD chunkMd, BlockMD topBlockMd, Integer vSlice, int x, int y, int z, boolean cavePrePass) {
        float slope;
        if (strata.isEmpty()) {
            if (dayChunkImage != null) {
                this.paintBadBlock(dayChunkImage, x, y, z);
            }
            if (nightChunkImage != null) {
                this.paintBadBlock(nightChunkImage, x, y, z);
            }
            return false;
        }
        while (!strata.isEmpty()) {
            Stratum stratum = strata.nextUp(this, true);
            if (strata.getRenderDayColor() == null || strata.getRenderNightColor() == null) {
                strata.setRenderDayColor(stratum.getDayColor());
                if (!cavePrePass) {
                    strata.setRenderNightColor(stratum.getNightColor());
                }
            } else {
                strata.setRenderDayColor(RGB.blendWith(strata.getRenderDayColor(), stratum.getDayColor(), stratum.getBlockMD().getAlpha()));
                if (!cavePrePass) {
                    strata.setRenderNightColor(RGB.blendWith(strata.getRenderNightColor(), stratum.getNightColor(), stratum.getBlockMD().getAlpha()));
                }
            }
            strata.release(stratum);
        }
        if (strata.getRenderDayColor() == null) {
            this.paintBadBlock(dayChunkImage, x, y, z);
            this.paintBadBlock(nightChunkImage, x, y, z);
            return false;
        }
        if (nightChunkImage != null && strata.getRenderNightColor() == null) {
            this.paintBadBlock(nightChunkImage, x, y, z);
            return false;
        }
        if ((topBlockMd.isWater() && this.mapBathymetry || !topBlockMd.hasNoShadow()) && (slope = this.getSlope(chunkMd, topBlockMd, x, null, z)) != 1.0f) {
            strata.setRenderDayColor(RGB.bevelSlope(strata.getRenderDayColor(), slope));
            if (!cavePrePass) {
                strata.setRenderNightColor(RGB.bevelSlope(strata.getRenderNightColor(), slope));
            }
        }
        this.paintBlock(dayChunkImage, x, z, strata.getRenderDayColor());
        if (nightChunkImage != null) {
            this.paintBlock(nightChunkImage, x, z, strata.getRenderNightColor());
        }
        return true;
    }
}

