/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.models;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.block.model.VariantList;
import net.minecraft.client.renderer.block.model.WeightedBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelProcessingHelper;
import net.minecraftforge.client.model.MultiModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class SimpleModel
implements IRetexturableModel {
    private static final ModelResourceLocation MISSING = new ModelResourceLocation("builtin/missing", "missing");
    private final List<Variant> variants;
    private final List<ResourceLocation> locations = new ArrayList<ResourceLocation>();
    private final Set<ResourceLocation> textures = Sets.newHashSet();
    private final List<IModel> models = new ArrayList<IModel>();
    private final IModelState defaultState;

    public SimpleModel(List<ResourceLocation> locations, List<IModel> models, List<Variant> variants, IModelState defaultState) {
        this.locations.addAll(locations);
        this.models.addAll(models);
        this.variants = variants;
        this.defaultState = defaultState;
        for (IModel model : models) {
            this.textures.addAll(model.getTextures());
        }
    }

    public SimpleModel(ResourceLocation parent, VariantList variants) throws Exception {
        this.variants = variants.func_188114_a();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Variant variant : this.variants) {
            ResourceLocation loc = variant.func_188046_a();
            this.locations.add(loc);
            IModel model = loc.equals((Object)MISSING) ? ModelLoaderRegistry.getMissingModel() : ModelLoaderRegistry.getModel((ResourceLocation)loc);
            model = variant.process(model);
            for (ResourceLocation location : model.getDependencies()) {
                ModelLoaderRegistry.getModelOrMissing((ResourceLocation)location);
            }
            this.textures.addAll(model.getTextures());
            this.models.add(model);
            builder.add((Object)Pair.of((Object)model, (Object)variant.getState()));
        }
        if (this.models.size() == 0) {
            IModel missing = ModelLoaderRegistry.getMissingModel();
            this.models.add(missing);
            builder.add((Object)Pair.of((Object)missing, (Object)TRSRTransformation.identity()));
        }
        this.defaultState = new MultiModelState(builder.build());
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.copyOf(this.locations);
    }

    public Collection<ResourceLocation> getTextures() {
        return ImmutableSet.copyOf(this.textures);
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        if (this.variants.size() == 1) {
            IModel model = this.models.get(0);
            return model.bake(MultiModelState.getPartState((IModelState)state, (IModel)model, (int)0), format, bakedTextureGetter);
        }
        WeightedBakedModel.Builder builder = new WeightedBakedModel.Builder();
        for (int i = 0; i < this.variants.size(); ++i) {
            IModel model = this.models.get(i);
            builder.func_177677_a(model.bake(MultiModelState.getPartState((IModelState)state, (IModel)model, (int)i), format, bakedTextureGetter), this.variants.get(i).func_188047_d());
        }
        return builder.func_177676_a();
    }

    public IModelState getDefaultState() {
        return this.defaultState;
    }

    public IModel retexture(ImmutableMap<String, String> textures) {
        ArrayList<IModel> models = new ArrayList<IModel>();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Variant variant : this.variants) {
            IModel model;
            ResourceLocation loc = variant.func_188046_a();
            this.locations.add(loc);
            if (loc.equals((Object)MISSING)) {
                model = ModelLoaderRegistry.getMissingModel();
            } else {
                try {
                    model = ModelLoaderRegistry.getModel((ResourceLocation)loc);
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
            model = variant.process(model);
            for (ResourceLocation location : model.getDependencies()) {
                ModelLoaderRegistry.getModelOrMissing((ResourceLocation)location);
            }
            model = ModelProcessingHelper.retexture((IModel)model, textures);
            models.add(model);
            builder.add((Object)Pair.of((Object)model, (Object)variant.getState()));
        }
        if (models.isEmpty()) {
            IModel missing = ModelLoaderRegistry.getMissingModel();
            models.add(missing);
            builder.add((Object)Pair.of((Object)missing, (Object)TRSRTransformation.identity()));
        }
        return new SimpleModel(this.locations, models, this.variants, (IModelState)new MultiModelState(builder.build()));
    }
}

