/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool.terrasteel;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.RecipeSorter;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.ISequentialBreaker;
import vazkii.botania.api.mana.IManaGivingItem;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.sound.BotaniaSoundEvents;
import vazkii.botania.common.achievement.ModAchievements;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.crafting.recipe.TerraPickTippingRecipe;
import vazkii.botania.common.item.ItemTemperanceStone;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.equipment.tool.manasteel.ItemManasteelPick;
import vazkii.botania.common.item.relic.ItemLokiRing;
import vazkii.botania.common.item.relic.ItemThorRing;

public class ItemTerraPick
extends ItemManasteelPick
implements IManaItem,
ISequentialBreaker {
    private static final String TAG_ENABLED = "enabled";
    private static final String TAG_MANA = "mana";
    private static final String TAG_TIPPED = "tipped";
    private static final int MAX_MANA = Integer.MAX_VALUE;
    private static final int MANA_PER_DAMAGE = 100;
    private static final Material[] MATERIALS = new Material[]{Material.field_151576_e, Material.field_151573_f, Material.field_151588_w, Material.field_151592_s, Material.field_76233_E, Material.field_151574_g, Material.field_151577_b, Material.field_151578_c, Material.field_151595_p, Material.field_151597_y, Material.field_151596_z, Material.field_151571_B};
    public static final int[] LEVELS = new int[]{0, 10000, 1000000, 10000000, 100000000, 1000000000};
    private static final int[] CREATIVE_MANA = new int[]{9999, 999999, 9999999, 99999999, 999999999, 0x7FFFFFFE};

    public ItemTerraPick() {
        super(BotaniaAPI.terrasteelToolMaterial, "terraPick");
        GameRegistry.addRecipe((IRecipe)new TerraPickTippingRecipe());
        RecipeSorter.register((String)"botania:terraPickTipping", TerraPickTippingRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
        this.func_185043_a(new ResourceLocation("botania", TAG_TIPPED), (itemStack, world, entityLivingBase) -> ItemTerraPick.isTipped(itemStack) ? 1.0f : 0.0f);
        this.func_185043_a(new ResourceLocation("botania", TAG_ENABLED), (itemStack, world, entityLivingBase) -> ItemTerraPick.isEnabled(itemStack) ? 1.0f : 0.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@Nonnull Item item, CreativeTabs tab, List<ItemStack> list) {
        for (int mana : CREATIVE_MANA) {
            ItemStack stack = new ItemStack(item);
            ItemTerraPick.setMana(stack, mana);
            list.add(stack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer player, List<String> stacks, boolean par4) {
        String rank = I18n.func_135052_a((String)("botania.rank" + ItemTerraPick.getLevel(par1ItemStack)), (Object[])new Object[0]);
        String rankFormat = I18n.func_135052_a((String)"botaniamisc.toolRank", (Object[])new Object[]{rank});
        stacks.add(rankFormat.replaceAll("&", "\u00a7"));
        if (this.getMana(par1ItemStack) == Integer.MAX_VALUE) {
            stacks.add(TextFormatting.RED + I18n.func_135052_a((String)"botaniamisc.getALife", (Object[])new Object[0]));
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull ItemStack par1ItemStack, World world, EntityPlayer player, EnumHand hand) {
        this.getMana(par1ItemStack);
        int level = ItemTerraPick.getLevel(par1ItemStack);
        if (level != 0) {
            this.setEnabled(par1ItemStack, !ItemTerraPick.isEnabled(par1ItemStack));
            if (!world.field_72995_K) {
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, BotaniaSoundEvents.terraPickMode, SoundCategory.PLAYERS, 0.5f, 0.4f);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)par1ItemStack);
    }

    @Override
    @Nonnull
    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float sx, float sy, float sz) {
        return player.func_70093_af() ? super.func_180614_a(stack, player, world, pos, hand, side, sx, sy, sz) : EnumActionResult.PASS;
    }

    @Override
    public void func_77663_a(ItemStack par1ItemStack, World world, Entity par3Entity, int par4, boolean par5) {
        super.func_77663_a(par1ItemStack, world, par3Entity, par4, par5);
        if (ItemTerraPick.isEnabled(par1ItemStack)) {
            int level = ItemTerraPick.getLevel(par1ItemStack);
            if (level == 0) {
                this.setEnabled(par1ItemStack, false);
            } else if (par3Entity instanceof EntityPlayer && !((EntityPlayer)par3Entity).field_82175_bq) {
                this.addMana(par1ItemStack, -level);
            }
        }
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        RayTraceResult raycast = ToolCommons.raytraceFromEntity(player.field_70170_p, (Entity)player, true, 10.0);
        if (!player.field_70170_p.field_72995_K && raycast != null) {
            this.breakOtherBlock(player, stack, pos, pos, raycast.field_178784_b);
            ItemLokiRing.breakOnAllCursors(player, (Item)this, stack, pos, raycast.field_178784_b);
        }
        return false;
    }

    @Override
    public int getManaPerDmg() {
        return 100;
    }

    @Override
    public void breakOtherBlock(EntityPlayer player, ItemStack stack, BlockPos pos, BlockPos originPos, EnumFacing side) {
        if (!ItemTerraPick.isEnabled(stack)) {
            return;
        }
        World world = player.field_70170_p;
        Material mat = world.func_180495_p(pos).func_185904_a();
        if (!ToolCommons.isRightMaterial(mat, MATERIALS)) {
            return;
        }
        if (world.func_175623_d(pos)) {
            return;
        }
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)player.func_184614_ca());
        boolean silk = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)player.func_184614_ca()) > 0;
        boolean thor = ItemThorRing.getThorRing(player) != null;
        boolean doX = thor || side.func_82601_c() == 0;
        boolean doY = thor || side.func_96559_d() == 0;
        boolean doZ = thor || side.func_82599_e() == 0;
        int origLevel = ItemTerraPick.getLevel(stack);
        int level = origLevel + (thor ? 1 : 0);
        if (ItemTemperanceStone.hasTemperanceActive(player) && level > 2) {
            level = 2;
        }
        int range = level - 1;
        int rangeY = Math.max(1, range);
        if (range == 0 && level != 1) {
            return;
        }
        BlockPos beginDiff = new BlockPos(doX ? -range : 0, doY ? -1 : 0, doZ ? -range : 0);
        BlockPos endDiff = new BlockPos(doX ? range : 0, doY ? rangeY * 2 - 1 : 0, doZ ? range : 0);
        ToolCommons.removeBlocksInIteration(player, stack, world, pos, beginDiff, endDiff, null, MATERIALS, silk, fortune, ItemTerraPick.isTipped(stack));
        if (origLevel == 5) {
            player.func_71064_a((StatBase)ModAchievements.rankSSPick, 1);
        }
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    public static boolean isTipped(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_TIPPED, false);
    }

    public static void setTipped(ItemStack stack) {
        ItemNBTHelper.setBoolean(stack, TAG_TIPPED, true);
    }

    public static boolean isEnabled(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_ENABLED, false);
    }

    void setEnabled(ItemStack stack, boolean enabled) {
        ItemNBTHelper.setBoolean(stack, TAG_ENABLED, enabled);
    }

    public static void setMana(ItemStack stack, int mana) {
        ItemNBTHelper.setInt(stack, TAG_MANA, mana);
    }

    @Override
    public int getMana(ItemStack stack) {
        return ItemTerraPick.getMana_(stack);
    }

    public static int getMana_(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_MANA, 0);
    }

    public static int getLevel(ItemStack stack) {
        int mana = ItemTerraPick.getMana_(stack);
        for (int i = LEVELS.length - 1; i > 0; --i) {
            if (mana < LEVELS[i]) continue;
            return i;
        }
        return 0;
    }

    @Override
    public int getMaxMana(ItemStack stack) {
        return Integer.MAX_VALUE;
    }

    @Override
    public void addMana(ItemStack stack, int mana) {
        ItemTerraPick.setMana(stack, Math.min(this.getMana(stack) + mana, Integer.MAX_VALUE));
    }

    @Override
    public boolean canReceiveManaFromPool(ItemStack stack, TileEntity pool) {
        return true;
    }

    @Override
    public boolean canReceiveManaFromItem(ItemStack stack, ItemStack otherStack) {
        return !(otherStack.func_77973_b() instanceof IManaGivingItem);
    }

    @Override
    public boolean canExportManaToPool(ItemStack stack, TileEntity pool) {
        return false;
    }

    @Override
    public boolean canExportManaToItem(ItemStack stack, ItemStack otherStack) {
        return false;
    }

    @Override
    public boolean isNoExport(ItemStack stack) {
        return true;
    }

    @Override
    public boolean func_82789_a(ItemStack par1ItemStack, @Nonnull ItemStack par2ItemStack) {
        return par2ItemStack.func_77973_b() == ModItems.manaResource && par2ItemStack.func_77952_i() == 4 ? true : super.func_82789_a(par1ItemStack, par2ItemStack);
    }

    @Override
    public boolean disposeOfTrashBlocks(ItemStack stack) {
        return ItemTerraPick.isTipped(stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack before, @Nonnull ItemStack after, boolean slotChanged) {
        return after.func_77973_b() != this || ItemTerraPick.isEnabled(before) != ItemTerraPick.isEnabled(after);
    }
}

