/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import baubles.api.BaubleType;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.RecipeSorter;
import vazkii.botania.api.item.IBaubleRender;
import vazkii.botania.api.item.ICosmeticBauble;
import vazkii.botania.client.core.handler.ModelHandler;
import vazkii.botania.common.crafting.recipe.CosmeticAttachRecipe;
import vazkii.botania.common.crafting.recipe.CosmeticRemoveRecipe;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;

public class ItemBaubleCosmetic
extends ItemBauble
implements ICosmeticBauble {
    private static final int SUBTYPES = 32;
    private ItemStack renderStack;

    public ItemBaubleCosmetic() {
        super("cosmetic");
        this.func_77627_a(true);
        GameRegistry.addRecipe((IRecipe)new CosmeticAttachRecipe());
        GameRegistry.addRecipe((IRecipe)new CosmeticRemoveRecipe());
        RecipeSorter.register((String)"botania:cosmeticAttach", CosmeticAttachRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
        RecipeSorter.register((String)"botania:cosmeticRemove", CosmeticRemoveRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
        this.renderStack = new ItemStack((Item)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@Nonnull Item item, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < 32; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @Nonnull
    public String func_77667_c(ItemStack par1ItemStack) {
        return super.func_77667_c(par1ItemStack) + par1ItemStack.func_77952_i();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addHiddenTooltip(ItemStack par1ItemStack, EntityPlayer player, List<String> stacks, boolean par4) {
        this.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.cosmeticBauble", (Object[])new Object[0]), stacks);
        super.addHiddenTooltip(par1ItemStack, player, stacks, par4);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelHandler.registerItemAppendMeta(this, 32, "cosmetic");
    }

    public BaubleType getBaubleType(ItemStack arg0) {
        return BaubleType.TRINKET;
    }

    @Override
    public void onPlayerBaubleRender(ItemStack stack, EntityPlayer player, IBaubleRender.RenderType type, float partialTicks) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        this.renderStack = stack;
        if (stack.func_77952_i() >= 32 || stack.func_77952_i() < 0) {
            return;
        }
        Variants variant = Variants.values()[stack.func_77952_i()];
        if (type == IBaubleRender.RenderType.HEAD) {
            IBaubleRender.Helper.translateToHeadLevel(player);
            IBaubleRender.Helper.translateToFace();
            IBaubleRender.Helper.defaultTransforms();
            switch (variant) {
                case RED_GLASSES: {
                    GlStateManager.func_179139_a((double)1.25, (double)1.25, (double)1.25);
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.085f, (float)0.045f);
                    this.renderItem();
                    break;
                }
                case ENGINEER_GOGGLES: {
                    GlStateManager.func_179139_a((double)1.25, (double)1.25, (double)1.25);
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.085f, (float)0.045f);
                    this.renderItem();
                    break;
                }
                case EYEPATCH: {
                    this.scale(0.55f);
                    GlStateManager.func_179109_b((float)-0.45f, (float)-0.25f, (float)0.0f);
                    this.renderItem();
                    break;
                }
                case WICKED_EYEPATCH: {
                    this.scale(0.55f);
                    GlStateManager.func_179109_b((float)0.45f, (float)-0.25f, (float)0.0f);
                    this.renderItem();
                    break;
                }
                case RED_RIBBONS: {
                    this.scale(0.9f);
                    GlStateManager.func_179109_b((float)0.0f, (float)0.75f, (float)1.0f);
                    this.renderItem();
                    break;
                }
                case PINK_FLOWER_BUD: {
                    GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179109_b((float)0.4f, (float)0.6f, (float)0.45f);
                    this.renderItem();
                    break;
                }
                case POLKA_DOTTED_BOWS: {
                    GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179109_b((float)0.65f, (float)0.3f, (float)0.5f);
                    this.renderItem();
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
                    this.renderItem();
                    break;
                }
                case BLUE_BUTTERFLY: {
                    GlStateManager.func_179109_b((float)-0.75f, (float)0.1f, (float)1.0f);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    this.renderItem();
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.75f);
                    GlStateManager.func_179114_b((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    this.renderItem();
                    break;
                }
                case CAT_EARS: {
                    GlStateManager.func_179109_b((float)0.0f, (float)0.25f, (float)0.25f);
                    this.renderItem();
                    break;
                }
                case GOOGLY_EYES: {
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179152_a((float)1.5f, (float)1.5f, (float)1.0f);
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.05f, (float)-0.15f);
                    this.renderItem();
                    break;
                }
                case CLOCK_EYE: {
                    this.scale(0.75f);
                    GlStateManager.func_179109_b((float)-0.25f, (float)-0.1f, (float)0.0f);
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    this.renderItem();
                    break;
                }
                case UNICORN_HORN: {
                    this.scale(1.25f);
                    GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179109_b((float)0.0f, (float)0.4f, (float)0.0f);
                    this.renderItem();
                    break;
                }
                case DEVIL_HORNS: {
                    GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.25f);
                    this.renderItem();
                    break;
                }
                case HYPER_PLUS: {
                    this.scale(0.35f);
                    GlStateManager.func_179109_b((float)-0.7f, (float)1.0f, (float)-0.5f);
                    this.renderItem();
                    GlStateManager.func_179109_b((float)1.45f, (float)0.0f, (float)0.0f);
                    this.renderItem();
                    break;
                }
                case ANCIENT_MASK: {
                    this.scale(1.25f);
                    GlStateManager.func_179109_b((float)0.0f, (float)0.025f, (float)0.01f);
                    this.renderItem();
                    break;
                }
                case EERIE_MASK: {
                    this.renderItem();
                    break;
                }
                case ALIEN_ANTENNA: {
                    this.scale(0.9f);
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179109_b((float)0.0f, (float)0.75f, (float)-1.0f);
                    this.renderItem();
                    break;
                }
                case ANAGLYPH_GLASSES: {
                    this.scale(1.25f);
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.025f, (float)0.0f);
                    this.renderItem();
                    break;
                }
                case ORANGE_SHADES: {
                    this.scale(1.25f);
                    GlStateManager.func_179109_b((float)0.0f, (float)0.04f, (float)0.0f);
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179112_b((int)770, (int)771);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);
                    this.renderItem();
                    break;
                }
                case GROUCHO_GLASSES: {
                    this.scale(1.5f);
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.2125f, (float)0.0f);
                    this.renderItem();
                    break;
                }
                case THICK_EYEBROWS: {
                    this.scale(0.5f);
                    GlStateManager.func_179109_b((float)-0.4f, (float)0.05f, (float)0.0f);
                    this.renderItem();
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179109_b((float)-0.775f, (float)0.0f, (float)0.0f);
                    this.renderItem();
                    break;
                }
                case TINY_POTATO_MASK: {
                    this.scale(1.25f);
                    GlStateManager.func_179109_b((float)0.0f, (float)0.025f, (float)0.0f);
                    this.renderItem();
                    break;
                }
                case QUESTGIVER_MARK: {
                    this.scale(0.8f);
                    GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.3f);
                    this.renderItem();
                    break;
                }
            }
        } else {
            IBaubleRender.Helper.rotateIfSneaking(player);
            IBaubleRender.Helper.translateToChest();
            IBaubleRender.Helper.defaultTransforms();
            switch (variant) {
                case BLACK_BOWTIE: {
                    GlStateManager.func_179109_b((float)0.0f, (float)0.15f, (float)0.0f);
                    this.renderItem();
                    break;
                }
                case BLACK_TIE: {
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.15f, (float)0.0f);
                    this.renderItem();
                    break;
                }
                case PUFFY_SCARF: {
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.15f, (float)0.0f);
                    this.renderItem();
                    break;
                }
                case WITCH_PIN: {
                    this.scale(0.35f);
                    GlStateManager.func_179109_b((float)-0.35f, (float)0.35f, (float)0.15f);
                    this.renderItem();
                    break;
                }
                case DEVIL_TAIL: {
                    GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179109_b((float)0.5f, (float)-0.75f, (float)0.0f);
                    this.renderItem();
                    break;
                }
                case KAMUI_EYE: {
                    this.scale(0.9f);
                    GlStateManager.func_179109_b((float)0.9f, (float)0.35f, (float)0.0f);
                    this.renderItem();
                    GlStateManager.func_179109_b((float)-1.3f, (float)-0.5f, (float)0.5f);
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    this.renderKamuiBlack();
                    break;
                }
                case FOUR_LEAF_CLOVER: {
                    this.scale(0.5f);
                    GlStateManager.func_179109_b((float)0.35f, (float)0.3f, (float)-0.075f);
                    this.renderItem();
                    break;
                }
                case BOTANIST_EMBLEM: {
                    this.scale(0.5f);
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.75f, (float)0.0f);
                    this.renderItem();
                    break;
                }
                case LUSITANIC_SHIELD: {
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179109_b((float)0.035f, (float)-0.2f, (float)0.55f);
                    GlStateManager.func_179114_b((float)8.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    this.renderItem();
                    break;
                }
            }
        }
    }

    public void scale(float f) {
        GlStateManager.func_179152_a((float)f, (float)f, (float)f);
    }

    public void renderItem() {
        GlStateManager.func_179094_E();
        Minecraft.func_71410_x().func_175599_af().func_181564_a(this.renderStack, ItemCameraTransforms.TransformType.NONE);
        GlStateManager.func_179121_F();
    }

    public void renderKamuiBlack() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        Minecraft.func_71410_x().field_71446_o.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(this.renderStack);
        GlStateManager.func_179091_B();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179094_E();
        model = ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.NONE, (boolean)false);
        this.renderModel(model, this.renderStack, -16777140);
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        GlStateManager.func_179121_F();
        GlStateManager.func_179101_C();
        GlStateManager.func_179084_k();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        Minecraft.func_71410_x().field_71446_o.func_110581_b(TextureMap.field_110575_b).func_174935_a();
    }

    private void renderModel(IBakedModel model, ItemStack stack, int color) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (EnumFacing enumfacing : EnumFacing.values()) {
            this.renderQuads(worldrenderer, model.func_188616_a(null, enumfacing, 0L), color, stack);
        }
        this.renderQuads(worldrenderer, model.func_188616_a(null, null, 0L), color, stack);
        tessellator.func_78381_a();
    }

    private void renderQuads(VertexBuffer renderer, List<BakedQuad> quads, int color, ItemStack stack) {
        boolean flag = color == -1 && stack != null;
        int j = quads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = quads.get(i);
            int k = color;
            if (flag && bakedquad.func_178212_b()) {
                k = Minecraft.func_71410_x().getItemColors().func_186728_a(stack, bakedquad.func_178211_c());
                if (EntityRenderer.field_78517_a) {
                    k = TextureUtil.func_177054_c((int)k);
                }
                k |= 0xFF000000;
            }
            LightUtil.renderQuadColor((VertexBuffer)renderer, (BakedQuad)bakedquad, (int)k);
        }
    }

    public static enum Variants {
        BLACK_BOWTIE,
        BLACK_TIE,
        RED_GLASSES,
        PUFFY_SCARF,
        ENGINEER_GOGGLES,
        EYEPATCH,
        WICKED_EYEPATCH,
        RED_RIBBONS,
        PINK_FLOWER_BUD,
        POLKA_DOTTED_BOWS,
        BLUE_BUTTERFLY,
        CAT_EARS,
        WITCH_PIN,
        DEVIL_TAIL,
        KAMUI_EYE,
        GOOGLY_EYES,
        FOUR_LEAF_CLOVER,
        CLOCK_EYE,
        UNICORN_HORN,
        DEVIL_HORNS,
        HYPER_PLUS,
        BOTANIST_EMBLEM,
        ANCIENT_MASK,
        EERIE_MASK,
        ALIEN_ANTENNA,
        ANAGLYPH_GLASSES,
        ORANGE_SHADES,
        GROUCHO_GLASSES,
        THICK_EYEBROWS,
        LUSITANIC_SHIELD,
        TINY_POTATO_MASK,
        QUESTGIVER_MARK;

    }
}

