/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.Items;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import romelo333.notenoughwands.Config;
import romelo333.notenoughwands.Items.GenericWand;
import romelo333.notenoughwands.varia.Tools;

public class DisplacementWand
extends GenericWand {
    private float maxHardness = 50.0f;
    public static final int MODE_FIRST = 0;
    public static final int MODE_3X3 = 0;
    public static final int MODE_5X5 = 1;
    public static final int MODE_7X7 = 2;
    public static final int MODE_SINGLE = 3;
    public static final int MODE_LAST = 3;
    public static final String[] descriptions = new String[]{"3x3", "5x5", "7x7", "single"};
    public static final int[] amount = new int[]{9, 9, 25, 1};

    public DisplacementWand() {
        this.setup("displacement_wand").xpUsage(1).availability(AVAILABILITY_NORMAL).loot(3);
    }

    @Override
    public void initConfig(Configuration cfg) {
        super.initConfig(cfg);
        this.maxHardness = (float)cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_maxHardness", (double)this.maxHardness, "Max hardness this block can move.)").getDouble();
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean b) {
        super.func_77624_a(stack, player, list, b);
        list.add(TextFormatting.GREEN + "Mode: " + descriptions[this.getMode(stack)]);
        list.add("Right click to push blocks forward.");
        list.add("Sneak right click to pull blocks.");
        this.showModeKeyDescription(list, "switch mode");
    }

    @Override
    public void toggleMode(EntityPlayer player, ItemStack stack) {
        int mode = this.getMode(stack);
        if (++mode > 3) {
            mode = 0;
        }
        Tools.notify(player, "Switched to " + descriptions[mode] + " mode");
        Tools.getTagCompound(stack).func_74768_a("mode", mode);
    }

    private int getMode(ItemStack stack) {
        return Tools.getTagCompound(stack).func_74762_e("mode");
    }

    protected EnumActionResult clOnItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                this.pullBlocks(stack, player, world, pos, side);
            } else {
                this.pushBlocks(stack, player, world, pos, side);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    private void pullBlocks(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        if (!this.checkUsage(stack, player, 1.0f)) {
            return;
        }
        Set<BlockPos> coordinates = this.findSuitableBlocks(stack, world, side, pos);
        int cnt = this.moveBlocks(player, world, coordinates, side);
        if (cnt > 0) {
            this.registerUsage(stack, player, 1.0f);
        }
    }

    private void pushBlocks(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        if (!this.checkUsage(stack, player, 1.0f)) {
            return;
        }
        Set<BlockPos> coordinates = this.findSuitableBlocks(stack, world, side, pos);
        int cnt = this.moveBlocks(player, world, coordinates, side.func_176734_d());
        if (cnt > 0) {
            this.registerUsage(stack, player, 1.0f);
        }
    }

    private int moveBlocks(EntityPlayer player, World world, Set<BlockPos> coordinates, EnumFacing direction) {
        int cnt = 0;
        for (BlockPos coordinate : coordinates) {
            double cost;
            IBlockState state = world.func_180495_p(coordinate);
            Block block = state.func_177230_c();
            BlockPos otherC = coordinate.func_177972_a(direction);
            IBlockState otherState = world.func_180495_p(otherC);
            Block otherBlock = otherState.func_177230_c();
            if (!otherBlock.func_176200_f((IBlockAccess)world, otherC) || !((cost = GenericWand.checkPickup(player, world, otherC, block, this.maxHardness)) >= 0.0)) continue;
            ++cnt;
            int meta = block.func_176201_c(state);
            Tools.playSound(world, block.func_185467_w().func_185844_d(), (double)coordinate.func_177958_n(), (double)coordinate.func_177956_o(), (double)coordinate.func_177952_p(), 1.0, 1.0);
            TileEntity tileEntity = world.func_175625_s(coordinate);
            NBTTagCompound tc = null;
            if (tileEntity != null) {
                tc = new NBTTagCompound();
                tileEntity.func_189515_b(tc);
                world.func_175713_t(coordinate);
            }
            world.func_175698_g(coordinate);
            IBlockState blockState = block.func_176203_a(meta);
            world.func_180501_a(otherC, blockState, 3);
            if (tc == null) continue;
            tc.func_74768_a("x", otherC.func_177958_n());
            tc.func_74768_a("y", otherC.func_177956_o());
            tc.func_74768_a("z", otherC.func_177952_p());
            tileEntity = TileEntity.func_190200_a((World)world, (NBTTagCompound)tc);
            if (tileEntity == null) continue;
            world.func_175726_f(otherC).func_150813_a(tileEntity);
            tileEntity.func_70296_d();
            world.func_184138_a(otherC, blockState, blockState, 3);
        }
        return cnt;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderOverlay(RenderWorldLastEvent evt, EntityPlayerSP player, ItemStack wand) {
        BlockPos blockPos;
        World world;
        IBlockState state;
        Block block;
        RayTraceResult mouseOver = Minecraft.func_71410_x().field_71476_x;
        if (mouseOver != null && mouseOver.func_178782_a() != null && mouseOver.field_178784_b != null && (block = (state = (world = player.func_130014_f_()).func_180495_p(blockPos = mouseOver.func_178782_a())).func_177230_c()) != null && block.func_149688_o(state) != Material.field_151579_a) {
            Set<BlockPos> coordinates = this.findSuitableBlocks(wand, world, mouseOver.field_178784_b, blockPos);
            DisplacementWand.renderOutlines(evt, player, coordinates, 200, 230, 180);
        }
    }

    private Set<BlockPos> findSuitableBlocks(ItemStack stack, World world, EnumFacing sideHit, BlockPos pos) {
        HashSet<BlockPos> coordinates = new HashSet<BlockPos>();
        int mode = this.getMode(stack);
        int dim = 0;
        switch (mode) {
            case 3: {
                coordinates.add(pos);
                return coordinates;
            }
            case 0: {
                dim = 1;
                break;
            }
            case 1: {
                dim = 2;
                break;
            }
            case 2: {
                dim = 3;
            }
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        switch (sideHit) {
            case UP: 
            case DOWN: {
                for (int dx = x - dim; dx <= x + dim; ++dx) {
                    for (int dz = z - dim; dz <= z + dim; ++dz) {
                        this.checkAndAddBlock(world, dx, y, dz, coordinates);
                    }
                }
                break;
            }
            case SOUTH: 
            case NORTH: {
                for (int dx = x - dim; dx <= x + dim; ++dx) {
                    for (int dy = y - dim; dy <= y + dim; ++dy) {
                        this.checkAndAddBlock(world, dx, dy, z, coordinates);
                    }
                }
                break;
            }
            case EAST: 
            case WEST: {
                for (int dy = y - dim; dy <= y + dim; ++dy) {
                    for (int dz = z - dim; dz <= z + dim; ++dz) {
                        this.checkAndAddBlock(world, x, dy, dz, coordinates);
                    }
                }
                break;
            }
        }
        return coordinates;
    }

    private void checkAndAddBlock(World world, int x, int y, int z, Set<BlockPos> coordinates) {
        BlockPos pos = new BlockPos(x, y, z);
        if (!world.func_175623_d(pos)) {
            coordinates.add(pos);
        }
    }

    @Override
    protected void setupCraftingInt(Item wandcore) {
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)this), (Object[])new Object[]{"eb ", "bw ", "  w", Character.valueOf('e'), Items.field_151079_bi, Character.valueOf('b'), Items.field_151118_aC, Character.valueOf('w'), wandcore});
    }
}

