/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.registry.IIngredientHandler;
import com.jaquadro.minecraft.storagedrawers.api.registry.IRecipeHandler;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.config.CompTierRegistry;
import com.jaquadro.minecraft.storagedrawers.config.ConfigManager;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawersComp;
import com.jaquadro.minecraft.storagedrawers.network.CountUpdateMessage;
import com.jaquadro.minecraft.storagedrawers.storage.BaseDrawerData;
import com.jaquadro.minecraft.storagedrawers.storage.CompDrawerData;
import com.jaquadro.minecraft.storagedrawers.storage.DrawerData;
import com.jaquadro.minecraft.storagedrawers.storage.ICentralInventory;
import com.jaquadro.minecraft.storagedrawers.util.UniqueMetaIdentifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;

public class TileEntityDrawersComp
extends TileEntityDrawers {
    private static InventoryLookup lookup1 = new InventoryLookup(1, 1);
    private static InventoryLookup lookup2 = new InventoryLookup(2, 2);
    private static InventoryLookup lookup3 = new InventoryLookup(3, 3);
    private ICentralInventory centralInventory;
    private int pooledCount;
    private int lookupSizeResult;
    private ItemStack[] protoStack = new ItemStack[this.getDrawerCount()];
    private int[] convRate = new int[this.getDrawerCount()];

    public TileEntityDrawersComp() {
        super(3);
    }

    protected ICentralInventory getCentralInventory() {
        if (this.centralInventory == null) {
            this.centralInventory = new CompCentralInventory();
        }
        return this.centralInventory;
    }

    public int getStoredItemRemainder(int slot) {
        int count = this.centralInventory.getStoredItemCount(slot);
        if (slot > 0 && this.convRate[slot] > 0) {
            count -= this.centralInventory.getStoredItemCount(slot - 1) * (this.convRate[slot - 1] / this.convRate[slot]);
        }
        return count;
    }

    @Override
    protected IDrawer createDrawer(int slot) {
        return new CompDrawerData(this.getCentralInventory(), slot);
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerDrawersComp(playerInventory, this);
    }

    public String func_174875_k() {
        return "StorageDrawers:compDrawers";
    }

    @Override
    public IDrawer getDrawerIfEnabled(int slot) {
        if (slot > 0 && slot < this.convRate.length && this.convRate[slot] == 0) {
            return null;
        }
        return super.getDrawerIfEnabled(slot);
    }

    @Override
    public int putItemsIntoSlot(int slot, ItemStack stack, int count) {
        int added = 0;
        if (stack != null && this.convRate != null && this.convRate[0] == 0) {
            int i;
            this.populateSlots(stack);
            for (i = 0; i < this.getDrawerCount(); ++i) {
                if (!BaseDrawerData.areItemsEqual(this.protoStack[i], stack)) continue;
                added = super.putItemsIntoSlot(i, stack, count);
            }
            for (i = 0; i < this.getDrawerCount(); ++i) {
                IDrawer drawer = this.getDrawer(i);
                if (!(drawer instanceof CompDrawerData)) continue;
                ((CompDrawerData)drawer).refresh();
            }
        }
        return added + super.putItemsIntoSlot(slot, stack, count);
    }

    @Override
    public void readFromPortableNBT(NBTTagCompound tag) {
        int i;
        this.pooledCount = 0;
        for (i = 0; i < this.getDrawerCount(); ++i) {
            this.protoStack[i] = null;
            this.convRate[i] = 0;
        }
        super.readFromPortableNBT(tag);
        this.pooledCount = tag.func_74762_e("Count");
        if (tag.func_74764_b("Conv0")) {
            this.convRate[0] = tag.func_74771_c("Conv0");
        }
        if (tag.func_74764_b("Conv1")) {
            this.convRate[1] = tag.func_74771_c("Conv1");
        }
        if (tag.func_74764_b("Conv2")) {
            this.convRate[2] = tag.func_74771_c("Conv2");
        }
        for (i = 0; i < this.getDrawerCount(); ++i) {
            IDrawer drawer = this.getDrawer(i);
            if (!(drawer instanceof CompDrawerData)) continue;
            ((CompDrawerData)drawer).refresh();
        }
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }

    @Override
    public NBTTagCompound writeToPortableNBT(NBTTagCompound tag) {
        super.writeToPortableNBT(tag);
        tag.func_74768_a("Count", this.pooledCount);
        if (this.convRate[0] > 0) {
            tag.func_74774_a("Conv0", (byte)this.convRate[0]);
        }
        if (this.convRate[1] > 0) {
            tag.func_74774_a("Conv1", (byte)this.convRate[1]);
        }
        if (this.convRate[2] > 0) {
            tag.func_74774_a("Conv2", (byte)this.convRate[2]);
        }
        return tag;
    }

    @Override
    public void clientUpdateCount(int slot, int count) {
        if (count != this.pooledCount) {
            this.pooledCount = count;
        }
    }

    @Override
    public String func_70005_c_() {
        return this.func_145818_k_() ? super.func_70005_c_() : "storageDrawers.container.compDrawers";
    }

    private void populateSlots(ItemStack stack) {
        int index = 0;
        ItemStack uTier1 = this.findHigherTier(stack);
        if (uTier1 != null) {
            if (!this.func_145831_w().field_72995_K && StorageDrawers.config.cache.debugTrace) {
                FMLLog.log((String)"StorageDrawers", (Level)Level.INFO, (String)("Picked candidate " + uTier1.toString() + " with conv=" + this.lookupSizeResult), (Object[])new Object[0]);
            }
            int uCount1 = this.lookupSizeResult;
            ItemStack uTier2 = this.findHigherTier(uTier1);
            if (uTier2 != null) {
                if (!this.func_145831_w().field_72995_K && StorageDrawers.config.cache.debugTrace) {
                    FMLLog.log((String)"StorageDrawers", (Level)Level.INFO, (String)("Picked candidate " + uTier2.toString() + " with conv=" + this.lookupSizeResult), (Object[])new Object[0]);
                }
                this.populateSlot(index++, uTier2, this.lookupSizeResult * uCount1);
            }
            this.populateSlot(index++, uTier1, uCount1);
        }
        this.populateSlot(index++, stack, 1);
        if (index == 3) {
            return;
        }
        ItemStack lTier1 = this.findLowerTier(stack);
        if (lTier1 != null) {
            if (!this.func_145831_w().field_72995_K && StorageDrawers.config.cache.debugTrace) {
                FMLLog.log((String)"StorageDrawers", (Level)Level.INFO, (String)("Picked candidate " + lTier1.toString() + " with conv=" + this.lookupSizeResult), (Object[])new Object[0]);
            }
            this.populateSlot(index++, lTier1, 1);
            int i = 0;
            while (i < index - 1) {
                int n = i++;
                this.convRate[n] = this.convRate[n] * this.lookupSizeResult;
            }
        }
        if (index == 3 || lTier1 == null) {
            return;
        }
        ItemStack lTier2 = this.findLowerTier(lTier1);
        if (lTier2 != null) {
            if (!this.func_145831_w().field_72995_K && StorageDrawers.config.cache.debugTrace) {
                FMLLog.log((String)"StorageDrawers", (Level)Level.INFO, (String)("Picked candidate " + lTier2.toString() + " with conv=" + this.lookupSizeResult), (Object[])new Object[0]);
            }
            this.populateSlot(index++, lTier2, 1);
            int i = 0;
            while (i < index - 1) {
                int n = i++;
                this.convRate[n] = this.convRate[n] * this.lookupSizeResult;
            }
        }
    }

    private void populateSlot(int slot, ItemStack stack, int conversion) {
        this.convRate[slot] = conversion;
        this.protoStack[slot] = stack.func_77946_l();
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }

    private ItemStack findHigherTier(ItemStack stack) {
        ItemStack modMatch;
        CompTierRegistry.Record record;
        if (!this.func_145831_w().field_72995_K && StorageDrawers.config.cache.debugTrace) {
            FMLLog.log((String)"StorageDrawers", (Level)Level.INFO, (String)("Finding ascending candidates for " + stack.toString()), (Object[])new Object[0]);
        }
        if ((record = StorageDrawers.compRegistry.findHigherTier(stack)) != null) {
            if (!this.func_145831_w().field_72995_K && StorageDrawers.config.cache.debugTrace) {
                FMLLog.log((String)"StorageDrawers", (Level)Level.INFO, (String)("Found " + record.upper.toString() + " in registry with conv=" + record.convRate), (Object[])new Object[0]);
            }
            this.lookupSizeResult = record.convRate;
            return record.upper;
        }
        CraftingManager cm = CraftingManager.func_77594_a();
        ArrayList<ItemStack> candidates = new ArrayList<ItemStack>();
        this.setupLookup(lookup3, stack);
        List<ItemStack> fwdCandidates = this.findAllMatchingRecipes(lookup3);
        if (fwdCandidates.size() == 0) {
            this.setupLookup(lookup2, stack);
            fwdCandidates = this.findAllMatchingRecipes(lookup2);
        }
        if (fwdCandidates.size() > 0) {
            int size = this.lookupSizeResult;
            int n1 = fwdCandidates.size();
            block0: for (int i = 0; i < n1; ++i) {
                ItemStack match = fwdCandidates.get(i);
                this.setupLookup(lookup1, match);
                List<ItemStack> backCandidates = this.findAllMatchingRecipes(lookup1);
                int n2 = backCandidates.size();
                for (int j = 0; j < n2; ++j) {
                    ItemStack comp = backCandidates.get(j);
                    if (comp.field_77994_a != size || !DrawerData.areItemsEqual(comp, stack, false)) continue;
                    candidates.add(match);
                    if (this.func_145831_w().field_72995_K || !StorageDrawers.config.cache.debugTrace) continue block0;
                    FMLLog.log((String)"StorageDrawers", (Level)Level.INFO, (String)("Found ascending candidate for " + stack.toString() + ": " + match.toString() + " size=" + this.lookupSizeResult + ", inverse=" + comp.toString()), (Object[])new Object[0]);
                    continue block0;
                }
            }
            this.lookupSizeResult = size;
        }
        if ((modMatch = this.findMatchingModCandidate(stack, candidates)) != null) {
            return modMatch;
        }
        if (candidates.size() > 0) {
            return (ItemStack)candidates.get(0);
        }
        if (!this.func_145831_w().field_72995_K && StorageDrawers.config.cache.debugTrace) {
            FMLLog.log((String)"StorageDrawers", (Level)Level.INFO, (String)"No candidates found", (Object[])new Object[0]);
        }
        return null;
    }

    private List<ItemStack> findAllMatchingRecipes(InventoryCrafting crafting) {
        ArrayList<ItemStack> candidates = new ArrayList<ItemStack>();
        CraftingManager cm = CraftingManager.func_77594_a();
        List recipeList = cm.func_77592_b();
        int n = recipeList.size();
        for (int i = 0; i < n; ++i) {
            ItemStack result;
            IRecipe recipe = (IRecipe)recipeList.get(i);
            if (!recipe.func_77569_a(crafting, this.func_145831_w()) || (result = recipe.func_77572_b(crafting)) == null || result.func_77973_b() == null) continue;
            candidates.add(result);
        }
        return candidates;
    }

    private ItemStack findLowerTier(ItemStack stack) {
        CompTierRegistry.Record record;
        if (!this.func_145831_w().field_72995_K && StorageDrawers.config.cache.debugTrace) {
            FMLLog.log((String)"StorageDrawers", (Level)Level.INFO, (String)("Finding descending candidates for " + stack.toString()), (Object[])new Object[0]);
        }
        if ((record = StorageDrawers.compRegistry.findLowerTier(stack)) != null) {
            if (!this.func_145831_w().field_72995_K && StorageDrawers.config.cache.debugTrace) {
                FMLLog.log((String)"StorageDrawers", (Level)Level.INFO, (String)("Found " + record.lower.toString() + " in registry with conv=" + record.convRate), (Object[])new Object[0]);
            }
            this.lookupSizeResult = record.convRate;
            return record.lower;
        }
        CraftingManager cm = CraftingManager.func_77594_a();
        List recipeList = cm.func_77592_b();
        ArrayList<ItemStack> candidates = new ArrayList<ItemStack>();
        HashMap<ItemStack, Integer> candidatesRate = new HashMap<ItemStack, Integer>();
        int n = recipeList.size();
        for (int i = 0; i < n; ++i) {
            IRecipe recipe = (IRecipe)recipeList.get(i);
            ItemStack match = null;
            ItemStack output = recipe.func_77571_b();
            if (!DrawerData.areItemsEqual(stack, output, true)) continue;
            IRecipeHandler handler = StorageDrawers.recipeHandlerRegistry.getRecipeHandler(recipe.getClass());
            if (handler != null) {
                Object[] itemArr = handler.getInputAsArray(recipe);
                if (itemArr != null) {
                    match = this.tryMatch(stack, itemArr);
                } else {
                    List itemList = handler.getInputAsList(recipe);
                    if (itemList != null) {
                        match = this.tryMatch(stack, itemList);
                    }
                }
            }
            if (match == null) continue;
            this.setupLookup(lookup1, output);
            List<ItemStack> compMatches = this.findAllMatchingRecipes(lookup1);
            for (ItemStack comp : compMatches) {
                if (DrawerData.areItemsEqual(match, comp, true) && comp.field_77994_a == recipe.func_77570_a()) {
                    this.lookupSizeResult = recipe.func_77570_a();
                    candidates.add(match);
                    candidatesRate.put(match, this.lookupSizeResult);
                    if (this.func_145831_w().field_72995_K || !StorageDrawers.config.cache.debugTrace) continue;
                    FMLLog.log((String)"StorageDrawers", (Level)Level.INFO, (String)("Found descending candidate for " + stack.toString() + ": " + match.toString() + " size=" + this.lookupSizeResult + ", inverse=" + comp.toString()), (Object[])new Object[0]);
                    continue;
                }
                if (this.func_145831_w().field_72995_K || !StorageDrawers.config.cache.debugTrace) continue;
                FMLLog.log((String)"StorageDrawers", (Level)Level.INFO, (String)("Back-check failed for " + match.toString() + " size=" + this.lookupSizeResult + ", inverse=" + comp.toString()), (Object[])new Object[0]);
            }
        }
        ItemStack modMatch = this.findMatchingModCandidate(stack, candidates);
        if (modMatch != null) {
            this.lookupSizeResult = (Integer)candidatesRate.get(modMatch);
            return modMatch;
        }
        if (candidates.size() > 0) {
            ItemStack match = (ItemStack)candidates.get(0);
            this.lookupSizeResult = (Integer)candidatesRate.get(match);
            return match;
        }
        if (!this.func_145831_w().field_72995_K && StorageDrawers.config.cache.debugTrace) {
            FMLLog.log((String)"StorageDrawers", (Level)Level.INFO, (String)"No candidates found", (Object[])new Object[0]);
        }
        return null;
    }

    private ItemStack findMatchingModCandidate(ItemStack reference, List<ItemStack> candidates) {
        String referenceName = GameData.getItemRegistry().getNameForObject((IForgeRegistryEntry)reference.func_77973_b()).toString();
        if (referenceName != null) {
            UniqueMetaIdentifier referneceID = new UniqueMetaIdentifier(referenceName);
            for (ItemStack candidate : candidates) {
                String matchName = GameData.getItemRegistry().getNameForObject((IForgeRegistryEntry)candidate.func_77973_b()).toString();
                if (matchName == null) continue;
                UniqueMetaIdentifier matchID = new UniqueMetaIdentifier(matchName);
                if (!referneceID.getModID().equals(matchID.getModID())) continue;
                return candidate;
            }
        }
        return null;
    }

    private ItemStack tryMatch(ItemStack stack, List list) {
        if (list.size() != 9 && list.size() != 4) {
            return null;
        }
        Object item = list.get(0);
        if (item instanceof ItemStack) {
            ItemStack item1 = (ItemStack)item;
            int n = list.size();
            for (int i = 1; i < n; ++i) {
                Object item2 = list.get(i);
                if (item2.getClass() != ItemStack.class) {
                    return null;
                }
                if (item1.func_77969_a((ItemStack)item2)) continue;
                return null;
            }
            return item1;
        }
        if (item instanceof List) {
            Object item1;
            int n = list.size();
            for (int i = 1; i < n; ++i) {
                if (item == list.get(i)) continue;
                return null;
            }
            List itemList = (List)item;
            if (itemList.size() > 0 && (item1 = itemList.get(0)) instanceof ItemStack) {
                return (ItemStack)item1;
            }
        }
        return null;
    }

    private ItemStack tryMatch(ItemStack stack, Object[] list) {
        if (list.length != 9 && list.length != 4) {
            return null;
        }
        Object item = list[0];
        if (item == null) {
            return null;
        }
        if (item instanceof ItemStack) {
            ItemStack item1 = (ItemStack)item;
            int n = list.length;
            for (int i = 1; i < n; ++i) {
                Object item2 = list[i];
                if (item2 == null || item2.getClass() != ItemStack.class) {
                    return null;
                }
                if (item1.func_77969_a((ItemStack)item2)) continue;
                return null;
            }
            return item1;
        }
        if (item instanceof List) {
            int n = list.length;
            for (int i = 1; i < n; ++i) {
                if (item == list[i]) continue;
                return null;
            }
            List itemList = (List)item;
            if (itemList.size() > 0) {
                Object item1 = this.findMatchingModCandidate(stack, itemList);
                if (item1 == null) {
                    item1 = itemList.get(0);
                }
                if (item1 instanceof ItemStack) {
                    return item1;
                }
            }
        } else {
            IIngredientHandler handler = StorageDrawers.recipeHandlerRegistry.getIngredientHandler(item.getClass());
            if (handler == null) {
                return null;
            }
            ItemStack item1 = handler.getItemStack(item);
            if (item1 == null) {
                return null;
            }
            int n = list.length;
            for (int i = 1; i < n; ++i) {
                Object item2 = list[i];
                if (item2 == null || item.getClass() != item2.getClass()) {
                    return null;
                }
                if ((item2 = handler.getItemStack(item2)) == null || item2.getClass() != ItemStack.class) {
                    return null;
                }
                if (item1.func_77969_a((ItemStack)item2)) continue;
                return null;
            }
            return item1;
        }
        return null;
    }

    private void setupLookup(InventoryLookup inv, ItemStack stack) {
        int n = inv.func_70302_i_();
        for (int i = 0; i < n; ++i) {
            inv.func_70299_a(i, stack);
        }
        this.lookupSizeResult = inv.func_70302_i_();
    }

    private static class InventoryLookup
    extends InventoryCrafting {
        private ItemStack[] stackList;

        public InventoryLookup(int width, int height) {
            super(null, width, height);
            this.stackList = new ItemStack[width * height];
        }

        public int func_70302_i_() {
            return this.stackList.length;
        }

        public ItemStack func_70301_a(int slot) {
            return slot >= this.func_70302_i_() ? null : this.stackList[slot];
        }

        public ItemStack func_70304_b(int slot) {
            return null;
        }

        public ItemStack func_70298_a(int slot, int count) {
            return null;
        }

        public void func_70299_a(int slot, ItemStack stack) {
            this.stackList[slot] = stack;
        }
    }

    private class CompCentralInventory
    implements ICentralInventory {
        private CompCentralInventory() {
        }

        @Override
        public ItemStack getStoredItemPrototype(int slot) {
            return TileEntityDrawersComp.this.protoStack[slot];
        }

        @Override
        public IDrawer setStoredItem(int slot, ItemStack itemPrototype, int amount) {
            if (itemPrototype != null && TileEntityDrawersComp.this.convRate != null && TileEntityDrawersComp.this.convRate[0] == 0) {
                int i;
                IDrawer target = null;
                TileEntityDrawersComp.this.populateSlots(itemPrototype);
                for (i = 0; i < TileEntityDrawersComp.this.getDrawerCount(); ++i) {
                    if (!BaseDrawerData.areItemsEqual(TileEntityDrawersComp.this.protoStack[i], itemPrototype)) continue;
                    target = TileEntityDrawersComp.this.getDrawer(i);
                    TileEntityDrawersComp.this.pooledCount = TileEntityDrawersComp.this.pooledCount % TileEntityDrawersComp.this.convRate[i] + TileEntityDrawersComp.this.convRate[i] * amount;
                }
                for (i = 0; i < TileEntityDrawersComp.this.getDrawerCount(); ++i) {
                    IDrawer drawer;
                    if (i == slot || !((drawer = TileEntityDrawersComp.this.getDrawer(i)) instanceof CompDrawerData)) continue;
                    ((CompDrawerData)drawer).refresh();
                }
                if (TileEntityDrawersComp.this.func_145831_w() != null && !TileEntityDrawersComp.this.func_145831_w().field_72995_K) {
                    IBlockState state = TileEntityDrawersComp.this.func_145831_w().func_180495_p(TileEntityDrawersComp.this.func_174877_v());
                    TileEntityDrawersComp.this.func_145831_w().func_184138_a(TileEntityDrawersComp.this.func_174877_v(), state, state, 3);
                }
                return target;
            }
            if (itemPrototype == null) {
                TileEntityDrawersComp.this.pooledCount = 0;
                this.clear();
                if (TileEntityDrawersComp.this.func_145831_w() != null && !TileEntityDrawersComp.this.func_145831_w().field_72995_K) {
                    IBlockState state = TileEntityDrawersComp.this.func_145831_w().func_180495_p(TileEntityDrawersComp.this.func_174877_v());
                    TileEntityDrawersComp.this.func_145831_w().func_184138_a(TileEntityDrawersComp.this.func_174877_v(), state, state, 3);
                }
            }
            return TileEntityDrawersComp.this.getDrawer(slot);
        }

        @Override
        public int getStoredItemCount(int slot) {
            if (TileEntityDrawersComp.this.convRate == null || TileEntityDrawersComp.this.convRate[slot] == 0) {
                return 0;
            }
            if (TileEntityDrawersComp.this.isVending()) {
                return Integer.MAX_VALUE;
            }
            return TileEntityDrawersComp.this.pooledCount / TileEntityDrawersComp.this.convRate[slot];
        }

        @Override
        public void setStoredItemCount(int slot, int amount) {
            if (TileEntityDrawersComp.this.convRate == null || TileEntityDrawersComp.this.convRate[slot] == 0) {
                return;
            }
            if (TileEntityDrawersComp.this.isVending()) {
                return;
            }
            int oldCount = TileEntityDrawersComp.this.pooledCount;
            TileEntityDrawersComp.this.pooledCount = TileEntityDrawersComp.this.pooledCount % TileEntityDrawersComp.this.convRate[slot] + TileEntityDrawersComp.this.convRate[slot] * amount;
            int poolMax = this.getMaxCapacity(0) * TileEntityDrawersComp.this.convRate[0];
            if (TileEntityDrawersComp.this.pooledCount > poolMax) {
                TileEntityDrawersComp.this.pooledCount = poolMax;
            }
            if (TileEntityDrawersComp.this.pooledCount != oldCount) {
                IBlockState state;
                if (TileEntityDrawersComp.this.pooledCount != 0 || TileEntityDrawersComp.this.isItemLocked(LockAttribute.LOCK_POPULATED)) {
                    this.markAmountDirty();
                } else {
                    this.clear();
                    if (TileEntityDrawersComp.this.func_145831_w() != null && !TileEntityDrawersComp.this.func_145831_w().field_72995_K) {
                        state = TileEntityDrawersComp.this.func_145831_w().func_180495_p(TileEntityDrawersComp.this.func_174877_v());
                        TileEntityDrawersComp.this.func_145831_w().func_184138_a(TileEntityDrawersComp.this.func_174877_v(), state, state, 3);
                    }
                }
                if (!TileEntityDrawersComp.this.func_145831_w().field_72995_K && TileEntityDrawersComp.this.isRedstone()) {
                    state = TileEntityDrawersComp.this.func_145831_w().func_180495_p(TileEntityDrawersComp.this.func_174877_v());
                    TileEntityDrawersComp.this.func_145831_w().func_175685_c(TileEntityDrawersComp.this.func_174877_v(), state.func_177230_c());
                    TileEntityDrawersComp.this.func_145831_w().func_175685_c(TileEntityDrawersComp.this.func_174877_v().func_177977_b(), state.func_177230_c());
                }
            }
        }

        @Override
        public int getMaxCapacity(int slot) {
            if (TileEntityDrawersComp.this.protoStack[slot] == null || TileEntityDrawersComp.this.convRate == null || TileEntityDrawersComp.this.convRate[slot] == 0) {
                return 0;
            }
            if (TileEntityDrawersComp.this.isUnlimited() || TileEntityDrawersComp.this.isVending()) {
                if (TileEntityDrawersComp.this.convRate == null || TileEntityDrawersComp.this.protoStack[slot] == null || TileEntityDrawersComp.this.convRate[slot] == 0) {
                    return Integer.MAX_VALUE;
                }
                return Integer.MAX_VALUE / TileEntityDrawersComp.this.convRate[slot];
            }
            return TileEntityDrawersComp.this.protoStack[0].func_77973_b().getItemStackLimit(TileEntityDrawersComp.this.protoStack[0]) * this.getStackCapacity(0) * this.getConversionRate(slot);
        }

        @Override
        public int getMaxCapacity(int slot, ItemStack itemPrototype) {
            if (itemPrototype == null || itemPrototype.func_77973_b() == null) {
                return 0;
            }
            if (TileEntityDrawersComp.this.isUnlimited() || TileEntityDrawersComp.this.isVending()) {
                if (TileEntityDrawersComp.this.convRate == null || TileEntityDrawersComp.this.protoStack[slot] == null || TileEntityDrawersComp.this.convRate[slot] == 0) {
                    return Integer.MAX_VALUE;
                }
                return Integer.MAX_VALUE / TileEntityDrawersComp.this.convRate[slot];
            }
            if (TileEntityDrawersComp.this.convRate == null || TileEntityDrawersComp.this.protoStack[0] == null || TileEntityDrawersComp.this.convRate[0] == 0) {
                return itemPrototype.func_77973_b().getItemStackLimit(itemPrototype) * this.getBaseStackCapacity();
            }
            if (BaseDrawerData.areItemsEqual(TileEntityDrawersComp.this.protoStack[slot], itemPrototype)) {
                return this.getMaxCapacity(slot);
            }
            return 0;
        }

        @Override
        public int getRemainingCapacity(int slot) {
            if (TileEntityDrawersComp.this.isVending()) {
                return Integer.MAX_VALUE;
            }
            return this.getMaxCapacity(slot) - this.getStoredItemCount(slot);
        }

        @Override
        public int getStoredItemStackSize(int slot) {
            if (TileEntityDrawersComp.this.protoStack[slot] == null || TileEntityDrawersComp.this.convRate == null || TileEntityDrawersComp.this.convRate[slot] == 0) {
                return 0;
            }
            return TileEntityDrawersComp.this.protoStack[slot].func_77973_b().getItemStackLimit(TileEntityDrawersComp.this.protoStack[slot]);
        }

        @Override
        public int getItemCapacityForInventoryStack(int slot) {
            if (TileEntityDrawersComp.this.isVoid()) {
                return Integer.MAX_VALUE;
            }
            return this.getMaxCapacity(slot);
        }

        @Override
        public int getConversionRate(int slot) {
            if (TileEntityDrawersComp.this.protoStack[slot] == null || TileEntityDrawersComp.this.convRate == null || TileEntityDrawersComp.this.convRate[slot] == 0) {
                return 0;
            }
            return TileEntityDrawersComp.this.convRate[0] / TileEntityDrawersComp.this.convRate[slot];
        }

        @Override
        public int getStoredItemRemainder(int slot) {
            return TileEntityDrawersComp.this.getStoredItemRemainder(slot);
        }

        @Override
        public boolean isSmallestUnit(int slot) {
            if (TileEntityDrawersComp.this.protoStack[slot] == null || TileEntityDrawersComp.this.convRate == null || TileEntityDrawersComp.this.convRate[slot] == 0) {
                return false;
            }
            return TileEntityDrawersComp.this.convRate[slot] == 1;
        }

        @Override
        public boolean isVoidSlot(int slot) {
            return TileEntityDrawersComp.this.isVoid();
        }

        @Override
        public boolean isShroudedSlot(int slot) {
            return TileEntityDrawersComp.this.isShrouded();
        }

        @Override
        public boolean setIsSlotShrouded(int slot, boolean state) {
            TileEntityDrawersComp.this.setIsShrouded(state);
            return true;
        }

        @Override
        public boolean isSlotShowingQuantity(int slot) {
            return TileEntityDrawersComp.this.isShowingQuantity();
        }

        @Override
        public boolean setIsSlotShowingQuantity(int slot, boolean state) {
            return TileEntityDrawersComp.this.setIsShowingQuantity(state);
        }

        @Override
        public boolean isLocked(int slot, LockAttribute attr) {
            return TileEntityDrawersComp.this.isItemLocked(attr);
        }

        @Override
        public void writeToNBT(int slot, NBTTagCompound tag) {
            ItemStack protoStack = this.getStoredItemPrototype(slot);
            if (protoStack != null && protoStack.func_77973_b() != null) {
                tag.func_74777_a("Item", (short)Item.func_150891_b((Item)protoStack.func_77973_b()));
                tag.func_74777_a("Meta", (short)protoStack.func_77952_i());
                tag.func_74768_a("Count", 0);
                if (protoStack.func_77978_p() != null) {
                    tag.func_74782_a("Tags", (NBTBase)protoStack.func_77978_p());
                }
            }
        }

        @Override
        public void readFromNBT(int slot, NBTTagCompound tag) {
            Item item;
            if (tag.func_74764_b("Item") && (item = Item.func_150899_d((int)tag.func_74765_d("Item"))) != null) {
                ItemStack stack = new ItemStack(item);
                stack.func_77964_b((int)tag.func_74765_d("Meta"));
                if (tag.func_74764_b("Tags")) {
                    stack.func_77982_d(tag.func_74775_l("Tags"));
                }
                ((TileEntityDrawersComp)TileEntityDrawersComp.this).protoStack[slot] = stack;
            }
        }

        private void clear() {
            for (int i = 0; i < TileEntityDrawersComp.this.getDrawerCount(); ++i) {
                ((TileEntityDrawersComp)TileEntityDrawersComp.this).protoStack[i] = null;
                ((TileEntityDrawersComp)TileEntityDrawersComp.this).convRate[i] = 0;
            }
            this.refresh();
            TileEntityDrawersComp.this.func_70296_d();
        }

        public void refresh() {
            for (int i = 0; i < TileEntityDrawersComp.this.getDrawerCount(); ++i) {
                IDrawer drawer = TileEntityDrawersComp.this.getDrawer(i);
                if (!(drawer instanceof CompDrawerData)) continue;
                ((CompDrawerData)drawer).refresh();
            }
        }

        private int getStackCapacity(int slot) {
            if (TileEntityDrawersComp.this.convRate == null || TileEntityDrawersComp.this.convRate[slot] == 0) {
                return 0;
            }
            int slotStacks = this.getBaseStackCapacity();
            int stackLimit = TileEntityDrawersComp.this.convRate[0] * slotStacks;
            return stackLimit / TileEntityDrawersComp.this.convRate[slot];
        }

        private int getBaseStackCapacity() {
            ConfigManager config = StorageDrawers.config;
            return TileEntityDrawersComp.this.getEffectiveStorageMultiplier() * TileEntityDrawersComp.this.getEffectiveDrawerCapacity();
        }

        public void markAmountDirty() {
            if (TileEntityDrawersComp.this.func_145831_w().field_72995_K) {
                return;
            }
            CountUpdateMessage message = new CountUpdateMessage(TileEntityDrawersComp.this.func_174877_v(), 0, TileEntityDrawersComp.this.pooledCount);
            NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(TileEntityDrawersComp.this.func_145831_w().field_73011_w.getDimension(), (double)TileEntityDrawersComp.this.func_174877_v().func_177958_n(), (double)TileEntityDrawersComp.this.func_174877_v().func_177956_o(), (double)TileEntityDrawersComp.this.func_174877_v().func_177952_p(), 500.0);
            StorageDrawers.network.sendToAllAround((IMessage)message, targetPoint);
        }

        public void markDirty(int slot) {
            if (TileEntityDrawersComp.this.func_145831_w().field_72995_K) {
                return;
            }
            IBlockState state = TileEntityDrawersComp.this.func_145831_w().func_180495_p(TileEntityDrawersComp.this.func_174877_v());
            TileEntityDrawersComp.this.func_145831_w().func_184138_a(TileEntityDrawersComp.this.func_174877_v(), state, state, 3);
        }
    }
}

