/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.EnergyStorage;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigStringListValues;
import de.ellpeck.actuallyadditions.mod.network.gui.IButtonReactor;
import de.ellpeck.actuallyadditions.mod.tile.ICustomEnergyReceiver;
import de.ellpeck.actuallyadditions.mod.tile.IEnergyDisplay;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomface;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityMiner
extends TileEntityInventoryBase
implements ICustomEnergyReceiver,
IButtonReactor,
IEnergyDisplay {
    public static final int ENERGY_USE_PER_BLOCK = 1500;
    public static final int DEFAULT_RANGE = 2;
    public final EnergyStorage storage = new EnergyStorage(200000);
    public int layerAt = -1;
    public boolean onlyMineOres;
    private int oldLayerAt;
    private int oldEnergy;

    public TileEntityMiner() {
        super(9, "miner");
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        this.storage.writeToNBT(compound);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("Layer", this.layerAt);
        }
        if (type != TileEntityBase.NBTType.SAVE_BLOCK || this.onlyMineOres) {
            compound.func_74757_a("OnlyOres", this.onlyMineOres);
        }
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        this.storage.readFromNBT(compound);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.layerAt = compound.func_74762_e("Layer");
        }
        this.onlyMineOres = compound.func_74767_n("OnlyOres");
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            if (this.layerAt == -1) {
                this.layerAt = this.func_174877_v().func_177956_o() - 1;
            }
            if (!this.isRedstonePowered && this.ticksElapsed % 5 == 0 && this.layerAt > 0 && this.mine(TileEntityPhantomface.upgradeRange(2, this.field_145850_b, this.field_174879_c))) {
                --this.layerAt;
            }
            if ((this.oldEnergy != this.storage.getEnergyStored() || this.oldLayerAt != this.layerAt) && this.sendUpdateWithInterval()) {
                this.oldEnergy = this.storage.getEnergyStored();
                this.oldLayerAt = this.layerAt;
            }
        }
    }

    private boolean mine(int range) {
        for (int anX = -range; anX <= range; ++anX) {
            for (int aZ = -range; aZ <= range; ++aZ) {
                int actualUse = 1500 * (this.onlyMineOres ? 5 : 1);
                if (this.storage.getEnergyStored() >= actualUse) {
                    BlockPos pos = new BlockPos(this.field_174879_c.func_177958_n() + anX, this.layerAt, this.field_174879_c.func_177952_p() + aZ);
                    IBlockState state = this.field_145850_b.func_180495_p(pos);
                    Block block = state.func_177230_c();
                    int meta = block.func_176201_c(state);
                    if (block.isAir(this.field_145850_b.func_180495_p(pos), (IBlockAccess)this.field_145850_b, pos) || block.getHarvestLevel(this.field_145850_b.func_180495_p(pos)) > 4 || !(state.func_185887_b(this.field_145850_b, pos) >= 0.0f) || block instanceof BlockLiquid || block instanceof IFluidBlock || !this.isMinable(block, meta)) continue;
                    List drops = block.getDrops((IBlockAccess)this.field_145850_b, pos, this.field_145850_b.func_180495_p(pos), 0);
                    float chance = WorldUtil.fireFakeHarvestEventsForDropChance(drops, this.field_145850_b, pos);
                    if (chance > 0.0f && this.field_145850_b.field_73012_v.nextFloat() <= chance && WorldUtil.addToInventory((IInventory)this, drops, false, true)) {
                        this.field_145850_b.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)this.field_145850_b.func_180495_p(pos)));
                        this.field_145850_b.func_175698_g(pos);
                        WorldUtil.addToInventory((IInventory)this, drops, true, true);
                        this.func_70296_d();
                        this.storage.extractEnergy(actualUse, false);
                        this.shootParticles(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    }
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    private boolean isMinable(Block block, int meta) {
        if (block != null && !this.isBlacklisted(block)) {
            if (!this.onlyMineOres) {
                return true;
            }
            ItemStack stack = new ItemStack(block, 1, meta);
            if (stack.func_77973_b() != null) {
                int[] ids;
                for (int id : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
                    String name = OreDictionary.getOreName((int)id);
                    if (!name.startsWith("ore") && !name.startsWith("denseore")) continue;
                    return true;
                }
                String reg = block.getRegistryName().toString();
                if (!reg.isEmpty()) {
                    for (String string : ConfigStringListValues.MINER_EXTRA_WHITELIST.getValue()) {
                        if (!reg.equals(string)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private void shootParticles(int endX, int endY, int endZ) {
        AssetUtil.spawnLaserWithTimeServer(this.field_145850_b, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), endX, endY, endZ, new float[]{0.25490198f, 0.5882353f, 0.007843138f}, 10, 120.0, 0.1f, 0.8f);
    }

    private boolean isBlacklisted(Block block) {
        String reg = block.getRegistryName().toString();
        if (!reg.isEmpty()) {
            for (String string : ConfigStringListValues.MINER_BLACKLIST.getValue()) {
                if (!reg.equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return false;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return true;
    }

    @Override
    public void onButtonPressed(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            this.onlyMineOres = !this.onlyMineOres;
            this.sendUpdate();
        } else if (buttonID == 1) {
            this.layerAt = -1;
        }
    }

    @Override
    public EnergyStorage getEnergyStorage() {
        return this.storage;
    }

    @Override
    public boolean needsHoldShift() {
        return false;
    }
}

