/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.EnergyStorage;
import de.ellpeck.actuallyadditions.api.misc.IDisplayStandItem;
import de.ellpeck.actuallyadditions.mod.tile.ICustomEnergyReceiver;
import de.ellpeck.actuallyadditions.mod.tile.IEnergyDisplay;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class TileEntityDisplayStand
extends TileEntityInventoryBase
implements IEnergyDisplay,
ICustomEnergyReceiver {
    public final EnergyStorage storage = new EnergyStorage(800000);
    private int oldEnergy;

    public TileEntityDisplayStand() {
        super(1, "displayStand");
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            IDisplayStandItem item;
            if (StackUtil.isValid(this.slots[0]) && !this.isRedstonePowered && (item = this.convertToDisplayStandItem(this.slots[0].func_77973_b())) != null) {
                int energy = item.getUsePerTick(this.slots[0], this, this.ticksElapsed);
                if (this.storage.getEnergyStored() >= energy && item.update(this.slots[0], this, this.ticksElapsed)) {
                    this.storage.extractEnergy(energy, false);
                }
            }
            if (this.oldEnergy != this.storage.getEnergyStored() && this.sendUpdateWithInterval()) {
                this.oldEnergy = this.storage.getEnergyStored();
            }
        }
    }

    @Override
    public boolean shouldSyncSlots() {
        return true;
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.sendUpdate();
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        return this.func_94041_b(index, stack);
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        this.storage.writeToNBT(compound);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        this.storage.readFromNBT(compound);
    }

    private IDisplayStandItem convertToDisplayStandItem(Item item) {
        Block block;
        if (item instanceof IDisplayStandItem) {
            return (IDisplayStandItem)item;
        }
        if (item instanceof ItemBlock && (block = Block.func_149634_a((Item)item)) instanceof IDisplayStandItem) {
            return (IDisplayStandItem)block;
        }
        return null;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }

    @Override
    public EnergyStorage getEnergyStorage() {
        return this.storage;
    }

    @Override
    public boolean needsHoldShift() {
        return false;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return from != EnumFacing.UP ? this.storage.receiveEnergy(maxReceive, simulate) : 0;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return from != EnumFacing.UP ? this.storage.getEnergyStored() : 0;
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return from != EnumFacing.UP ? this.storage.getMaxEnergyStored() : 0;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return from != EnumFacing.UP;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }
}

