/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.misc;

import de.ellpeck.actuallyadditions.mod.blocks.InitBlocks;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigBoolValues;
import de.ellpeck.actuallyadditions.mod.items.InitItems;
import de.ellpeck.actuallyadditions.mod.items.metalists.TheCrystals;
import de.ellpeck.actuallyadditions.mod.items.metalists.TheJams;
import de.ellpeck.actuallyadditions.mod.items.metalists.TheMiscItems;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetDamage;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class DungeonLoot {
    public static final ResourceLocation JAM_HOUSE = new ResourceLocation("actuallyadditions", "jamHouse");
    public static final ResourceLocation LUSH_CAVES = new ResourceLocation("actuallyadditions", "lushCaves");

    public DungeonLoot() {
        LootTableList.func_186375_a((ResourceLocation)JAM_HOUSE);
        LootTableList.func_186375_a((ResourceLocation)LUSH_CAVES);
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        if (ConfigBoolValues.DUNGEON_LOOT.isEnabled() && event.getName() != null && event.getTable() != null) {
            SetCount amount;
            SetMetadata damage;
            LootCondition[] noCondition = new LootCondition[]{};
            LootPool pool = event.getTable().getPool("main");
            if (pool == null) {
                pool = new LootPool(new LootEntry[0], noCondition, new RandomValueRange(3.0f, 6.0f), new RandomValueRange(0.0f), "main");
                event.getTable().addPool(pool);
            }
            boolean addCrystals = false;
            boolean addDrillCore = false;
            boolean addQuartz = false;
            boolean addBatWings = false;
            boolean addBook = false;
            if (LootTableList.field_186422_d.equals((Object)event.getName())) {
                addCrystals = true;
                addDrillCore = true;
                addQuartz = true;
            } else if (LootTableList.field_186424_f.equals((Object)event.getName())) {
                addCrystals = true;
                addDrillCore = true;
            } else if (LootTableList.field_186423_e.equals((Object)event.getName())) {
                addDrillCore = true;
                addQuartz = true;
                addBook = true;
            } else if (LootTableList.field_186426_h.equals((Object)event.getName())) {
                addBatWings = true;
                addBook = true;
            } else if (LootTableList.field_186431_m.equals((Object)event.getName())) {
                addBatWings = true;
            } else if (LootTableList.field_186429_k.equals((Object)event.getName())) {
                addDrillCore = true;
                addBatWings = true;
            } else if (LootTableList.field_186425_g.equals((Object)event.getName())) {
                addBatWings = true;
                addCrystals = true;
                addDrillCore = true;
                addBook = true;
            } else if (LootTableList.field_186421_c.equals((Object)event.getName())) {
                addBatWings = true;
                addCrystals = true;
                addDrillCore = true;
                addQuartz = true;
            } else if (JAM_HOUSE.equals((Object)event.getName())) {
                SetMetadata jamDamage = new SetMetadata(noCondition, new RandomValueRange(0.0f, (float)(TheJams.values().length - 1)));
                SetCount jamAmount = new SetCount(noCondition, new RandomValueRange(3.0f, 5.0f));
                pool.addEntry((LootEntry)new LootEntryItem(InitItems.itemJams, 2, 0, new LootFunction[]{jamDamage, jamAmount}, noCondition, "actuallyadditions:jams"));
                SetCount glassAmount = new SetCount(noCondition, new RandomValueRange(2.0f));
                pool.addEntry((LootEntry)new LootEntryItem(Items.field_151069_bo, 1, 0, new LootFunction[]{glassAmount}, noCondition, "actuallyadditions:bottles"));
            } else if (LUSH_CAVES.equals((Object)event.getName())) {
                addBook = true;
                addQuartz = true;
                addBatWings = true;
                addCrystals = true;
                pool.addEntry((LootEntry)new LootEntryItem(Items.field_151122_aG, 50, 0, new LootFunction[0], noCondition, "actuallyadditions:book"));
                SetCount bonesAmount = new SetCount(noCondition, new RandomValueRange(1.0f, 12.0f));
                pool.addEntry((LootEntry)new LootEntryItem(Items.field_151103_aS, 100, 0, new LootFunction[]{bonesAmount}, noCondition, "actuallyadditions:bones"));
                Item[] aiots = new Item[]{InitItems.woodenPaxel, InitItems.stonePaxel, InitItems.quartzPaxel, InitItems.itemPaxelCrystalBlack, InitItems.itemPaxelCrystalWhite};
                for (int i = 0; i < aiots.length; ++i) {
                    SetDamage damage2 = new SetDamage(noCondition, new RandomValueRange(0.0f, 0.25f));
                    pool.addEntry((LootEntry)new LootEntryItem(aiots[i], 30 - i * 5, 0, new LootFunction[]{damage2}, noCondition, "actuallyadditions:aiot" + i));
                }
                Item[] armor = new Item[]{Items.field_151024_Q, Items.field_151027_R, Items.field_151026_S, Items.field_151021_T};
                for (int i = 0; i < armor.length; ++i) {
                    SetDamage damage3 = new SetDamage(noCondition, new RandomValueRange(0.0f, 0.75f));
                    pool.addEntry((LootEntry)new LootEntryItem(armor[i], 50, 0, new LootFunction[]{damage3}, noCondition, "actuallyadditions:armor" + i));
                }
            }
            if (addCrystals) {
                damage = new SetMetadata(noCondition, new RandomValueRange(0.0f, (float)(TheCrystals.values().length - 1)));
                amount = new SetCount(noCondition, new RandomValueRange(1.0f, 3.0f));
                LootFunction[] functions = new LootFunction[]{damage, amount};
                pool.addEntry((LootEntry)new LootEntryItem(InitItems.itemCrystal, 20, 0, functions, noCondition, "actuallyadditions:crystalItems"));
                pool.addEntry((LootEntry)new LootEntryItem(Item.func_150898_a((Block)InitBlocks.blockCrystal), 3, 0, functions, noCondition, "actuallyadditions:crystalBlocks"));
            }
            if (addDrillCore) {
                damage = new SetMetadata(noCondition, new RandomValueRange((float)TheMiscItems.DRILL_CORE.ordinal()));
                pool.addEntry((LootEntry)new LootEntryItem(InitItems.itemMisc, 5, 0, new LootFunction[]{damage}, noCondition, "actuallyadditions:drillCore"));
            }
            if (addQuartz) {
                damage = new SetMetadata(noCondition, new RandomValueRange((float)TheMiscItems.QUARTZ.ordinal()));
                amount = new SetCount(noCondition, new RandomValueRange(1.0f, 5.0f));
                pool.addEntry((LootEntry)new LootEntryItem(InitItems.itemMisc, 20, 0, new LootFunction[]{damage, amount}, noCondition, "actuallyadditions:quartz"));
            }
            if (addBatWings) {
                damage = new SetMetadata(noCondition, new RandomValueRange((float)TheMiscItems.BAT_WING.ordinal()));
                amount = new SetCount(noCondition, new RandomValueRange(1.0f, 2.0f));
                pool.addEntry((LootEntry)new LootEntryItem(InitItems.itemMisc, 5, 0, new LootFunction[]{damage, amount}, noCondition, "actuallyadditions:batWings"));
            }
            if (addBook) {
                SetCount amount2 = new SetCount(noCondition, new RandomValueRange(1.0f));
                pool.addEntry((LootEntry)new LootEntryItem(InitItems.itemBooklet, 10, 0, new LootFunction[]{amount2}, noCondition, "actuallyadditions:booklet"));
            }
        }
    }
}

