/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.inventory;

import de.ellpeck.actuallyadditions.mod.inventory.slot.SlotDeletion;
import de.ellpeck.actuallyadditions.mod.inventory.slot.SlotFilter;
import de.ellpeck.actuallyadditions.mod.inventory.slot.SlotImmovable;
import de.ellpeck.actuallyadditions.mod.items.ItemBag;
import de.ellpeck.actuallyadditions.mod.items.ItemDrill;
import de.ellpeck.actuallyadditions.mod.network.gui.IButtonReactor;
import de.ellpeck.actuallyadditions.mod.tile.FilterSettings;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerBag
extends Container
implements IButtonReactor {
    public final FilterSettings filter = new FilterSettings(0, 4, false, true, false, false, 0, -1000);
    private final InventoryBag bagInventory;
    private final InventoryPlayer inventory;
    private final boolean isVoid;
    public boolean autoInsert;
    private boolean oldAutoInsert;

    public ContainerBag(InventoryPlayer inventory, boolean isVoid) {
        int j;
        int i;
        this.inventory = inventory;
        this.bagInventory = new InventoryBag(isVoid);
        this.isVoid = isVoid;
        for (i = 0; i < 4; ++i) {
            this.func_75146_a(new SlotFilter(this.bagInventory, i, 155, 10 + i * 18));
        }
        if (this.isVoid) {
            this.func_75146_a(new SlotDeletion(this.bagInventory, 4, 64, 65){

                public boolean func_75214_a(ItemStack stack) {
                    return ContainerBag.this.filter.check(stack, ((ContainerBag)ContainerBag.this).bagInventory.slots);
                }
            });
        } else {
            for (i = 0; i < 4; ++i) {
                for (j = 0; j < 7; ++j) {
                    this.func_75146_a(new Slot(this.bagInventory, j + i * 7 + 4, 10 + j * 18, 10 + i * 18){

                        public boolean func_75214_a(ItemStack stack) {
                            return ContainerBag.this.filter.check(stack, ((ContainerBag)ContainerBag.this).bagInventory.slots);
                        }
                    });
                }
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventory, j + i * 9 + 9, 8 + j * 18, 94 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            if (i == inventory.field_70461_c) {
                this.func_75146_a(new SlotImmovable((IInventory)inventory, i, 8 + i * 18, 152));
                continue;
            }
            this.func_75146_a(new Slot((IInventory)inventory, i, 8 + i * 18, 152));
        }
        ItemStack stack = inventory.func_70448_g();
        if (StackUtil.isValid(stack) && stack.func_77973_b() instanceof ItemBag) {
            ItemDrill.loadSlotsFromNBT(this.bagInventory.slots, inventory.func_70448_g());
            if (stack.func_77942_o()) {
                NBTTagCompound compound = stack.func_77978_p();
                this.filter.readFromNBT(compound, "Filter");
                this.autoInsert = compound.func_74767_n("AutoInsert");
            }
        }
    }

    public static int getSlotAmount(boolean isVoid) {
        return isVoid ? 5 : 32;
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.filter.needsUpdateSend() || this.autoInsert != this.oldAutoInsert) {
            for (IContainerListener listener : this.field_75149_d) {
                listener.func_71112_a((Container)this, 0, this.filter.isWhitelist ? 1 : 0);
                listener.func_71112_a((Container)this, 1, this.filter.respectMeta ? 1 : 0);
                listener.func_71112_a((Container)this, 2, this.filter.respectNBT ? 1 : 0);
                listener.func_71112_a((Container)this, 3, this.filter.respectOredict);
                listener.func_71112_a((Container)this, 4, this.autoInsert ? 1 : 0);
                listener.func_71112_a((Container)this, 5, this.filter.respectMod ? 1 : 0);
            }
            this.filter.updateLasts();
            this.oldAutoInsert = this.autoInsert;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int data) {
        if (id == 0) {
            this.filter.isWhitelist = data == 1;
        } else if (id == 1) {
            this.filter.respectMeta = data == 1;
        } else if (id == 2) {
            this.filter.respectNBT = data == 1;
        } else if (id == 3) {
            this.filter.respectOredict = data;
        } else if (id == 4) {
            this.autoInsert = data == 1;
        } else if (id == 5) {
            this.filter.respectMod = data == 1;
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int slot) {
        int inventoryStart = this.bagInventory.slots.length;
        int inventoryEnd = inventoryStart + 26;
        int hotbarStart = inventoryEnd + 1;
        int hotbarEnd = hotbarStart + 8;
        Slot theSlot = (Slot)this.field_75151_b.get(slot);
        if (theSlot != null && theSlot.func_75216_d()) {
            ItemStack newStack = theSlot.func_75211_c();
            ItemStack currentStack = newStack.func_77946_l();
            if (slot >= inventoryStart ? (this.isVoid || !this.filter.check(newStack, this.bagInventory.slots) || !this.func_75135_a(newStack, 4, 32, false)) && (slot >= inventoryStart && slot <= inventoryEnd ? !this.func_75135_a(newStack, hotbarStart, hotbarEnd + 1, false) : slot >= inventoryEnd + 1 && slot < hotbarEnd + 1 && !this.func_75135_a(newStack, inventoryStart, inventoryEnd + 1, false)) : !this.func_75135_a(newStack, inventoryStart, hotbarEnd + 1, false)) {
                return StackUtil.getNull();
            }
            if (!StackUtil.isValid(newStack)) {
                theSlot.func_75215_d(StackUtil.getNull());
            } else {
                theSlot.func_75218_e();
            }
            if (StackUtil.getStackSize(newStack) == StackUtil.getStackSize(currentStack)) {
                return StackUtil.getNull();
            }
            theSlot.func_82870_a(player, newStack);
            return currentStack;
        }
        return StackUtil.getNull();
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        if (slotId >= 0 && slotId < this.field_75151_b.size() && this.func_75139_a(slotId) instanceof SlotFilter) {
            return ((SlotFilter)this.func_75139_a(slotId)).slotClick(player);
        }
        if (clickTypeIn == ClickType.SWAP && dragType == this.inventory.field_70461_c) {
            return null;
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    public void func_75134_a(EntityPlayer player) {
        ItemStack stack = this.inventory.func_70448_g();
        if (StackUtil.isValid(stack) && stack.func_77973_b() instanceof ItemBag) {
            ItemDrill.writeSlotsToNBT(this.bagInventory.slots, this.inventory.func_70448_g());
            NBTTagCompound compound = stack.func_77978_p();
            this.filter.writeToNBT(compound, "Filter");
            compound.func_74757_a("AutoInsert", this.autoInsert);
        }
        super.func_75134_a(player);
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.bagInventory.func_70300_a(player);
    }

    @Override
    public void onButtonPressed(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            this.autoInsert = !this.autoInsert;
        } else {
            this.filter.onButtonPressed(buttonID);
        }
    }

    public static class InventoryBag
    implements IInventory {
        public ItemStack[] slots;

        public InventoryBag(boolean isVoid) {
            this.slots = new ItemStack[ContainerBag.getSlotAmount(isVoid)];
            Arrays.fill(this.slots, StackUtil.getNull());
        }

        public String func_70005_c_() {
            return "bag";
        }

        public int func_70297_j_() {
            return 64;
        }

        public void func_70296_d() {
        }

        public boolean func_70300_a(EntityPlayer player) {
            return true;
        }

        public void func_174889_b(EntityPlayer player) {
        }

        public void func_174886_c(EntityPlayer player) {
        }

        public boolean func_94041_b(int index, ItemStack stack) {
            return true;
        }

        public int func_174887_a_(int id) {
            return 0;
        }

        public void func_174885_b(int id, int value) {
        }

        public int func_174890_g() {
            return 0;
        }

        public void func_174888_l() {
            int length = this.slots.length;
            this.slots = new ItemStack[length];
            Arrays.fill(this.slots, StackUtil.getNull());
        }

        public void func_70299_a(int i, ItemStack stack) {
            this.slots[i] = stack;
            this.func_70296_d();
        }

        public int func_70302_i_() {
            return this.slots.length;
        }

        public ItemStack func_70301_a(int i) {
            if (i < this.func_70302_i_()) {
                return this.slots[i];
            }
            return StackUtil.getNull();
        }

        public ItemStack func_70298_a(int i, int j) {
            if (StackUtil.isValid(this.slots[i])) {
                if (StackUtil.getStackSize(this.slots[i]) <= j) {
                    ItemStack stackAt = this.slots[i];
                    this.slots[i] = StackUtil.getNull();
                    this.func_70296_d();
                    return stackAt;
                }
                ItemStack stackAt = this.slots[i].func_77979_a(j);
                if (StackUtil.getStackSize(this.slots[i]) <= 0) {
                    this.slots[i] = StackUtil.getNull();
                }
                this.func_70296_d();
                return stackAt;
            }
            return StackUtil.getNull();
        }

        public ItemStack func_70304_b(int index) {
            ItemStack stack = this.slots[index];
            this.slots[index] = StackUtil.getNull();
            return stack;
        }

        public boolean func_145818_k_() {
            return false;
        }

        public ITextComponent func_145748_c_() {
            return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
        }
    }
}

