/*
 * Decompiled with CFR 0.152.
 */
package jeresources.util;

import java.util.List;
import jeresources.entry.VillagerEntry;
import jeresources.registry.VillagerRegistry;
import jeresources.util.LogHelper;
import jeresources.util.ReflectionHelper;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class VillagersHelper {
    public static void initRegistry(VillagerRegistry reg) {
        int professionId = 0;
        for (VillagerRegistry.VillagerProfession profession : net.minecraftforge.fml.common.registry.VillagerRegistry.instance().getRegistry()) {
            for (VillagerRegistry.VillagerCareer career : VillagersHelper.getCareers(profession)) {
                try {
                    reg.addVillagerEntry(new VillagerEntry(career.getName(), professionId, VillagersHelper.getId(career), VillagersHelper.getTrades(career)));
                }
                catch (Exception e) {
                    LogHelper.warn("Failed loading villager %s registered at %s", career.getName(), profession.getRegistryName().toString());
                }
            }
            ++professionId;
        }
    }

    private static List<VillagerRegistry.VillagerCareer> getCareers(VillagerRegistry.VillagerProfession profession) {
        return (List)ReflectionHelper.getPrivateValue(VillagerRegistry.VillagerProfession.class, (Object)profession, (String[])new String[]{"careers"});
    }

    private static List<List<EntityVillager.ITradeList>> getTrades(VillagerRegistry.VillagerCareer career) {
        return (List)ReflectionHelper.getPrivateValue(VillagerRegistry.VillagerCareer.class, (Object)career, (String[])new String[]{"trades"});
    }

    private static int getId(VillagerRegistry.VillagerCareer career) {
        return (Integer)ReflectionHelper.getPrivateValue(VillagerRegistry.VillagerCareer.class, (Object)career, (String[])new String[]{"id"});
    }
}

