/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.worldgen;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jeresources.jei.JEIConfig;
import jeresources.jei.worldgen.WorldGenWrapper;
import jeresources.reference.Resources;
import jeresources.util.RenderHelper;
import jeresources.util.TranslationHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import net.minecraft.client.Minecraft;

public class WorldGenCategory
extends BlankRecipeCategory<WorldGenWrapper> {
    protected static final int X_ITEM = 5;
    protected static final int Y_ITEM = 21;
    protected static final int X_DROP_ITEM = 5;
    protected static final int Y_DROP_ITEM = 66;
    private static final int DROP_ITEM_COUNT = 8;
    private IDrawable icon = JEIConfig.getJeiHelpers().getGuiHelper().createDrawable(Resources.Gui.Jei.TABS, 32, 16, 16, 16);

    @Nonnull
    public String getUid() {
        return "jeresources.worldgen";
    }

    @Nonnull
    public String getTitle() {
        return TranslationHelper.translateToLocal("jer.worldgen.title");
    }

    @Nonnull
    public IDrawable getBackground() {
        return Resources.Gui.Jei.WORLD_GEN;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        RenderHelper.drawLine(29.0, 52.0, 157.0, 52.0, -7829368);
        RenderHelper.drawLine(29.0, 52.0, 29.0, 12.0, -7829368);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull WorldGenWrapper recipeWrapper) {
        int i;
        recipeLayout.getItemStacks().init(0, false, 5, 21);
        for (i = 0; i < 8; ++i) {
            recipeLayout.getItemStacks().init(i + 1, false, 5 + i * 18, 66);
        }
        recipeLayout.getItemStacks().addTooltipCallback((ITooltipCallback)recipeWrapper);
        recipeLayout.getItemStacks().set(0, recipeWrapper.getBlock());
        for (i = 0; i < Math.min(8, recipeWrapper.getDrops().size()); ++i) {
            recipeLayout.getItemStacks().set(i + 1, recipeWrapper.getDrops().get(i));
        }
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull WorldGenWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        int i;
        recipeLayout.getItemStacks().init(0, false, 5, 21);
        for (i = 0; i < 8; ++i) {
            recipeLayout.getItemStacks().init(i + 1, false, 5 + i * 18, 66);
        }
        recipeLayout.getItemStacks().addTooltipCallback((ITooltipCallback)recipeWrapper);
        recipeLayout.getItemStacks().set(0, recipeWrapper.getBlock());
        for (i = 0; i < Math.min(8, recipeWrapper.getDrops().size()); ++i) {
            recipeLayout.getItemStacks().set(i + 1, recipeWrapper.getDrops().get(i));
        }
    }
}

