/*
 * Decompiled with CFR 0.152.
 */
package rangedpumps.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.wrappers.BlockLiquidWrapper;
import net.minecraftforge.fluids.capability.wrappers.FluidBlockWrapper;
import rangedpumps.RangedPumps;
import rangedpumps.tile.EnumPumpState;

public class TilePump
extends TileEntity
implements ITickable,
IEnergyReceiver {
    private FluidTank tank;
    private EnergyStorage energy;
    private int ticks;
    private BlockPos currentPos;
    private BlockPos startPos;

    public TilePump() {
        this.energy = new EnergyStorage(RangedPumps.INSTANCE.energyCapacity);
        this.tank = new FluidTank(RangedPumps.INSTANCE.tankCapacity){

            protected void onContentsChanged() {
                super.onContentsChanged();
                TilePump.this.func_70296_d();
            }
        };
        this.tank.setCanFill(false);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!RangedPumps.INSTANCE.usesEnergy) {
            this.energy.setEnergyStored(this.energy.getMaxEnergyStored());
        }
        if (this.startPos == null) {
            this.startPos = this.field_174879_c.func_177982_a(-RangedPumps.INSTANCE.range / 2, -1, -RangedPumps.INSTANCE.range / 2);
        }
        boolean firstUpdate = false;
        if (this.currentPos == null) {
            this.currentPos = new BlockPos((Vec3i)this.startPos);
            firstUpdate = true;
        }
        if ((RangedPumps.INSTANCE.speed == 0 || this.ticks % RangedPumps.INSTANCE.speed == 0) && this.getState() == EnumPumpState.WORKING) {
            if (!firstUpdate) {
                this.currentPos = this.currentPos.func_177956_o() - 1 < 1 ? new BlockPos(this.currentPos.func_177958_n() + 1, this.startPos.func_177956_o(), this.currentPos.func_177952_p()) : this.currentPos.func_177982_a(0, -1, 0);
            }
            if (this.currentPos.func_177958_n() >= this.startPos.func_177958_n() + RangedPumps.INSTANCE.range) {
                this.currentPos = new BlockPos(this.startPos.func_177958_n(), this.startPos.func_177956_o(), this.currentPos.func_177952_p() + 1);
            }
            this.energy.extractEnergy(RangedPumps.INSTANCE.energyUsagePerMove, false);
            this.func_70296_d();
            if (!this.isOverLastRow()) {
                FluidStack drained;
                Block block = this.field_145850_b.func_180495_p(this.currentPos).func_177230_c();
                BlockLiquidWrapper handler = null;
                if (block instanceof BlockLiquid) {
                    handler = new BlockLiquidWrapper((BlockLiquid)block, this.field_145850_b, this.currentPos);
                } else if (block instanceof IFluidBlock) {
                    handler = new FluidBlockWrapper((IFluidBlock)block, this.field_145850_b, this.currentPos);
                }
                if (handler != null && (drained = handler.drain(RangedPumps.INSTANCE.tankCapacity, false)) != null && this.tank.fillInternal(drained, false) == drained.amount) {
                    this.tank.fillInternal(handler.drain(RangedPumps.INSTANCE.tankCapacity, true), true);
                    if (RangedPumps.INSTANCE.replaceLiquidWithStone) {
                        this.field_145850_b.func_175656_a(this.currentPos, Blocks.field_150348_b.func_176223_P());
                    }
                    this.energy.extractEnergy(RangedPumps.INSTANCE.energyUsagePerDrain, false);
                }
            }
        }
        ++this.ticks;
    }

    private boolean isOverLastRow() {
        return this.currentPos.func_177952_p() == this.startPos.func_177952_p() + RangedPumps.INSTANCE.range + 1;
    }

    public BlockPos getCurrentPosition() {
        return this.currentPos;
    }

    public EnergyStorage getEnergy() {
        return this.energy;
    }

    public EnumPumpState getState() {
        if (this.getEnergy().getEnergyStored() == 0) {
            return EnumPumpState.ENERGY;
        }
        if (this.currentPos != null && this.startPos != null) {
            if (this.isOverLastRow()) {
                return EnumPumpState.DONE;
            }
            if (!this.field_145850_b.func_175640_z(this.field_174879_c)) {
                return EnumPumpState.UNPOWERED;
            }
            if (this.tank.getFluidAmount() > this.tank.getCapacity() - 1000) {
                return EnumPumpState.FULL;
            }
            return EnumPumpState.WORKING;
        }
        return EnumPumpState.UNKNOWN;
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74772_a("CurrentPos", this.currentPos.func_177986_g());
        this.energy.writeToNBT(tag);
        this.tank.writeToNBT(tag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("CurrentPos")) {
            this.currentPos = BlockPos.func_177969_a((long)tag.func_74763_f("CurrentPos"));
        }
        this.energy.readFromNBT(tag);
        this.tank.readFromNBT(tag);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        int received = this.energy.receiveEnergy(maxReceive, simulate);
        if (received > 0 && !simulate) {
            this.func_70296_d();
        }
        return received;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.energy.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.energy.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }
}

