/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.hopperducts;

import java.util.List;
import net.fybertech.hopperducts.BlockGratedHopper;
import net.fybertech.hopperducts.HopperDuctsMod;
import net.fybertech.hopperducts.TileEntityHopperDuct;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockHopperDuct
extends BlockContainer {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final PropertyBool ENABLED = PropertyBool.func_177716_a((String)"enabled");
    public static final PropertyInteger CONNECTORS = PropertyInteger.func_177719_a((String)"connectors", (int)0, (int)63);

    protected BlockHopperDuct() {
        super(Material.field_151573_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)CONNECTORS, (Comparable)Integer.valueOf(0)));
        this.func_149647_a(CreativeTabs.field_78028_d);
        this.func_149672_a(SoundType.field_185852_e).func_149711_c(3.0f).func_149752_b(8.0f).func_149663_c("hopperduct");
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        float x1 = 0.25f;
        float x2 = 1.0f - x1;
        float y1 = 0.25f;
        float y2 = 1.0f - y1;
        float z1 = 0.25f;
        float z2 = 1.0f - z1;
        float par2 = pos.func_177958_n();
        float par3 = pos.func_177956_o();
        float par4 = pos.func_177952_p();
        if (BlockHopperDuct.isDuctConnectedTo(source, pos.func_177976_e(), EnumFacing.EAST)) {
            x1 = 0.0f;
        }
        if (BlockHopperDuct.isDuctConnectedTo(source, pos.func_177974_f(), EnumFacing.WEST)) {
            x2 = 1.0f;
        }
        if (BlockHopperDuct.isDuctConnectedTo(source, pos.func_177978_c(), EnumFacing.SOUTH)) {
            z1 = 0.0f;
        }
        if (BlockHopperDuct.isDuctConnectedTo(source, pos.func_177968_d(), EnumFacing.NORTH)) {
            z2 = 1.0f;
        }
        if (BlockHopperDuct.isDuctConnectedTo(source, pos.func_177977_b(), EnumFacing.UP)) {
            y1 = 0.0f;
        }
        if (BlockHopperDuct.isDuctConnectedTo(source, pos.func_177984_a(), EnumFacing.DOWN)) {
            y2 = 1.0f;
        }
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (facing.ordinal()) {
            case 0: {
                y1 = 0.0f;
                break;
            }
            case 1: {
                y2 = 1.0f;
                break;
            }
            case 2: {
                z1 = 0.0f;
                break;
            }
            case 3: {
                z2 = 1.0f;
                break;
            }
            case 4: {
                x1 = 0.0f;
                break;
            }
            case 5: {
                x2 = 1.0f;
            }
        }
        return new AxisAlignedBB((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    public static boolean isDuctConnectedTo(IBlockAccess blockaccess, BlockPos pos, EnumFacing dir) {
        Block block = blockaccess.func_180495_p(pos).func_177230_c();
        return block == HopperDuctsMod.blockHopperDuct ? blockaccess.func_180495_p(pos).func_177229_b((IProperty)FACING) == dir : (block == HopperDuctsMod.blockGratedHopper ? blockaccess.func_180495_p(pos).func_177229_b((IProperty)BlockGratedHopper.FACING) == dir : block == Blocks.field_150438_bZ && blockaccess.func_180495_p(pos).func_177229_b((IProperty)BlockHopper.field_176430_a) == dir);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity) {
        super.func_185477_a(state, worldIn, pos, mask, list, collidingEntity);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing enumfacing1 = facing.func_176734_d();
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing1).func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)CONNECTORS, (Comparable)Integer.valueOf(this.getNeighorConnectorsValue((IBlockAccess)worldIn, pos)));
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityHopperDuct();
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileentity;
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof TileEntityHopperDuct) {
            ((TileEntityHopperDuct)tileentity).setCustomName(stack.func_82833_r());
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.updateState(worldIn, pos, state);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        if (heldItem != null) {
            Item held = heldItem.func_77973_b();
            if (held == Item.func_150898_a((Block)this)) {
                return false;
            }
            if (held == Item.func_150898_a((Block)HopperDuctsMod.blockGratedHopper)) {
                return false;
            }
            if (held == Item.func_150898_a((Block)Blocks.field_150438_bZ)) {
                return false;
            }
            if (held == Items.field_151055_y) {
                int facing = ((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal();
                if (--facing >= 6) {
                    facing = 0;
                }
                if (facing < 0) {
                    facing = 5;
                }
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.values()[facing]), 4);
                return true;
            }
        }
        if (worldIn.func_175625_s(pos) instanceof TileEntityHopperDuct) {
            playerIn.openGui((Object)HopperDuctsMod.instance, 0, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        if (worldIn.field_72995_K) {
            return;
        }
        if (playerIn.func_184586_b(EnumHand.MAIN_HAND) != null && playerIn.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == Items.field_151055_y) {
            IBlockState state = worldIn.func_180495_p(pos);
            int facing = ((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal();
            facing = playerIn.func_70093_af() ? --facing : ++facing;
            if (facing >= 6) {
                facing = 0;
            }
            if (facing < 0) {
                facing = 5;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.values()[facing]), 6);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        this.updateState(worldIn, pos, state);
    }

    private void updateState(World worldIn, BlockPos pos, IBlockState state) {
        boolean ductEnabled = !worldIn.func_175640_z(pos);
        int flags = 0;
        boolean doUpdate = false;
        if (ductEnabled != (Boolean)state.func_177229_b((IProperty)ENABLED)) {
            state = state.func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(ductEnabled));
            flags |= 4;
            doUpdate = true;
        }
        if (doUpdate) {
            worldIn.func_180501_a(pos, state, flags);
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null) {
            boolean ductEnabled;
            World world = te.func_145831_w();
            boolean bl = ductEnabled = !world.func_175640_z(pos);
            if (ductEnabled != (Boolean)state.func_177229_b((IProperty)ENABLED)) {
                state = state.func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(ductEnabled));
            }
        }
        int newConnectors = this.getNeighorConnectorsValue(worldIn, pos);
        return state.func_177226_a((IProperty)CONNECTORS, (Comparable)Integer.valueOf(newConnectors));
    }

    public int getNeighorConnectorsValue(IBlockAccess worldIn, BlockPos pos) {
        int connectors = 0;
        for (EnumFacing facing : EnumFacing.values()) {
            BlockPos neighborpos = pos.func_177972_a(facing);
            IBlockState bs = worldIn.func_180495_p(neighborpos);
            if (bs.func_177230_c() instanceof BlockHopperDuct && neighborpos.func_177972_a((EnumFacing)bs.func_177229_b((IProperty)FACING)).equals((Object)pos)) {
                connectors |= 1 << facing.ordinal();
            }
            if (bs.func_177230_c() instanceof BlockGratedHopper && neighborpos.func_177972_a((EnumFacing)bs.func_177229_b((IProperty)BlockGratedHopper.FACING)).equals((Object)pos)) {
                connectors |= 1 << facing.ordinal();
            }
            if (!(bs.func_177230_c() instanceof BlockHopper) || !neighborpos.func_177972_a((EnumFacing)bs.func_177229_b((IProperty)BlockHopper.field_176430_a)).equals((Object)pos)) continue;
            connectors |= 1 << facing.ordinal();
        }
        return connectors;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityHopperDuct) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((TileEntityHopperDuct)tileentity));
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return true;
    }

    public static EnumFacing getFacing(int meta) {
        return EnumFacing.func_82600_a((int)(meta & 7));
    }

    public static boolean isEnabled(int meta) {
        return (meta & 8) != 8;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World worldIn, BlockPos pos) {
        return Container.func_178144_a((TileEntity)worldIn.func_175625_s(pos));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)BlockHopperDuct.getFacing(meta)).func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(BlockHopperDuct.isEnabled(meta)));
    }

    private int getConnectors(int meta) {
        return meta >> 8 & 0x3F;
    }

    public int func_176201_c(IBlockState state) {
        int b0 = 0;
        int i = b0 | ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        if (!((Boolean)state.func_177229_b((IProperty)ENABLED)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ENABLED, CONNECTORS});
    }
}

