/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.render.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mod.chiselsandbits.chiseledblock.BlockBitInfo;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.ReflectionWrapper;
import mod.chiselsandbits.helpers.DeprecationHelper;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.interfaces.ICacheClearable;
import mod.chiselsandbits.render.helpers.ModelQuadLayer;
import mod.chiselsandbits.render.helpers.ModelUVAverager;
import mod.chiselsandbits.render.helpers.ModelVertexRange;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.fluids.Fluid;

public class ModelUtil
implements ICacheClearable {
    private static final HashMap<Integer, String>[] blockToTexture;
    private static HashMap<Integer, ModelQuadLayer[]> cache;
    private static ModelUtil instance;

    @Override
    public void clearCache() {
        for (int x = 0; x < blockToTexture.length; ++x) {
            blockToTexture[x].clear();
        }
        cache.clear();
    }

    public static ModelQuadLayer[] getCachedFace(int stateID, long weight, EnumFacing face, BlockRenderLayer layer) {
        int cacheVal = stateID << 4 | face.ordinal();
        ModelQuadLayer[] mpc = cache.get(cacheVal);
        if (mpc != null) {
            return mpc;
        }
        IBlockState state = ModUtil.getStateById(stateID);
        IBakedModel model = ModelUtil.solveModel(state, weight, Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state));
        Fluid fluid = BlockBitInfo.getFluidFromBlock(state.func_177230_c());
        if (fluid != null) {
            for (EnumFacing xf : EnumFacing.field_82609_l) {
                ModelQuadLayer[] mp = new ModelQuadLayer[]{new ModelQuadLayer()};
                mp[0].color = fluid.getColor();
                mp[0].light = DeprecationHelper.getLightValue(state);
                float V = 0.5f;
                float Uf = 1.0f;
                float U = 0.5f;
                float Vf = 1.0f;
                if (xf.func_176740_k() == EnumFacing.Axis.Y) {
                    mp[0].sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluid.getStill().toString());
                    mp[0].uvs = new float[]{1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f};
                } else if (xf.func_176740_k() == EnumFacing.Axis.X) {
                    mp[0].sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluid.getFlowing().toString());
                    mp[0].uvs = new float[]{0.5f, 0.0f, 0.5f, 0.5f, 0.0f, 0.0f, 0.0f, 0.5f};
                } else {
                    mp[0].sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluid.getFlowing().toString());
                    mp[0].uvs = new float[]{0.5f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.0f, 0.5f};
                }
                mp[0].tint = 0;
                int cacheV = stateID << 4 | xf.ordinal();
                cache.put(cacheV, mp);
            }
            return cache.get(cacheVal);
        }
        HashMap<EnumFacing, ArrayList<ModelQuadLayer.ModelQuadLayerBuilder>> tmp = new HashMap<EnumFacing, ArrayList<ModelQuadLayer.ModelQuadLayerBuilder>>();
        int color = BlockBitInfo.getColorFor(state, 0);
        for (EnumFacing f : EnumFacing.field_82609_l) {
            tmp.put(f, new ArrayList());
        }
        if (model != null) {
            for (EnumFacing f : EnumFacing.field_82609_l) {
                List<BakedQuad> quads = ModelUtil.getModelQuads(model, state, f, 0L);
                ModelUtil.processFaces(tmp, quads);
            }
            ModelUtil.processFaces(tmp, ModelUtil.getModelQuads(model, state, null, 0L));
        }
        for (EnumFacing f : EnumFacing.field_82609_l) {
            int cacheV = stateID << 4 | f.ordinal();
            ArrayList<ModelQuadLayer.ModelQuadLayerBuilder> x = tmp.get(f);
            ModelQuadLayer[] mp = new ModelQuadLayer[x.size()];
            for (int z = 0; z < x.size(); ++z) {
                mp[z] = x.get(z).build(stateID, color, DeprecationHelper.getLightValue(state), state.func_177230_c() == Blocks.field_150349_c || state.func_177230_c() instanceof BlockLeaves);
            }
            cache.put(cacheV, mp);
        }
        return cache.get(cacheVal);
    }

    private static List<BakedQuad> getModelQuads(IBakedModel model, IBlockState state, EnumFacing f, long rand) {
        try {
            return model.func_188616_a(state, f, rand);
        }
        catch (Throwable throwable) {
            try {
                return model.func_188616_a(null, f, rand);
            }
            catch (Throwable throwable2) {
                IBakedModel secondModel = ModelUtil.getOverrides(model).handleItemState(model, ModUtil.getItemFromBlock(state), (World)Minecraft.func_71410_x().field_71441_e, (EntityLivingBase)Minecraft.func_71410_x().field_71439_g);
                if (secondModel != null) {
                    try {
                        return secondModel.func_188616_a(null, f, rand);
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                }
                return Collections.emptyList();
            }
        }
    }

    private static ItemOverrideList getOverrides(IBakedModel model) {
        if (model != null) {
            ItemOverrideList modelOverrides = model.func_188617_f();
            return modelOverrides == null ? ItemOverrideList.field_188022_a : modelOverrides;
        }
        return ItemOverrideList.field_188022_a;
    }

    private static void processFaces(HashMap<EnumFacing, ArrayList<ModelQuadLayer.ModelQuadLayerBuilder>> tmp, List<BakedQuad> quads) {
        for (BakedQuad q : quads) {
            EnumFacing face = q.func_178210_d();
            if (face == null) continue;
            try {
                TextureAtlasSprite sprite = ModelUtil.findQuadTexture(q);
                ArrayList<ModelQuadLayer.ModelQuadLayerBuilder> l = tmp.get(face);
                ModelQuadLayer.ModelQuadLayerBuilder b = null;
                for (ModelQuadLayer.ModelQuadLayerBuilder lx : l) {
                    if (lx.cache.sprite != sprite) continue;
                    b = lx;
                    break;
                }
                if (b == null) {
                    int uCoord = 0;
                    int vCoord = 2;
                    switch (face) {
                        case NORTH: 
                        case SOUTH: {
                            uCoord = 0;
                            vCoord = 1;
                            break;
                        }
                        case EAST: 
                        case WEST: {
                            uCoord = 1;
                            vCoord = 2;
                            break;
                        }
                    }
                    b = new ModelQuadLayer.ModelQuadLayerBuilder(sprite, uCoord, vCoord);
                    b.cache.tint = q.func_178211_c();
                    l.add(b);
                }
                q.pipe((IVertexConsumer)b.uvr);
                q.pipe((IVertexConsumer)b.lv);
            }
            catch (Exception exception) {}
        }
    }

    private ModelUtil() {
        ChiselsAndBits.getInstance().addClearable(this);
    }

    public static TextureAtlasSprite findQuadTexture(BakedQuad q) throws IllegalArgumentException, IllegalAccessException, NullPointerException {
        TextureMap map = Minecraft.func_71410_x().func_147117_R();
        Map<String, TextureAtlasSprite> mapRegisteredSprites = ReflectionWrapper.instance.getRegSprite(map);
        if (mapRegisteredSprites == null) {
            throw new RuntimeException("Unable to lookup textures.");
        }
        ModelUVAverager av = new ModelUVAverager();
        q.pipe((IVertexConsumer)av);
        float U = av.getU();
        float V = av.getV();
        for (TextureAtlasSprite sprite : mapRegisteredSprites.values()) {
            if (!(sprite.func_94209_e() <= U) || !(U <= sprite.func_94212_f()) || !(sprite.func_94206_g() <= V) || !(V <= sprite.func_94210_h())) continue;
            return sprite;
        }
        return Minecraft.func_71410_x().func_147117_R().func_174944_f();
    }

    public static IBakedModel solveModel(IBlockState state, long weight, IBakedModel originalModel) {
        ItemStack is;
        boolean hasFaces = false;
        try {
            hasFaces = ModelUtil.hasFaces(originalModel, state, null, weight);
            for (EnumFacing f : EnumFacing.field_82609_l) {
                hasFaces = hasFaces || ModelUtil.hasFaces(originalModel, state, f, weight);
            }
        }
        catch (Exception e) {
            hasFaces = false;
        }
        if (!hasFaces && (is = ModUtil.getItemFromBlock(state)) != null) {
            IBakedModel itemModel = Minecraft.func_71410_x().func_175599_af().func_184393_a(is, (World)Minecraft.func_71410_x().field_71441_e, (EntityLivingBase)Minecraft.func_71410_x().field_71439_g);
            return itemModel;
        }
        return originalModel;
    }

    private static boolean hasFaces(IBakedModel model, IBlockState state, EnumFacing f, long weight) {
        List<BakedQuad> l = ModelUtil.getModelQuads(model, state, f, weight);
        if (l == null || l.isEmpty()) {
            return false;
        }
        ModelVertexRange mvr = new ModelVertexRange();
        for (BakedQuad q : l) {
            q.pipe((IVertexConsumer)mvr);
        }
        return mvr.getLargestRange() > 0.0f;
    }

    public static TextureAtlasSprite findTexture(int BlockRef, IBakedModel model, EnumFacing myFace, BlockRenderLayer layer) {
        int blockToWork = layer.ordinal() * EnumFacing.field_82609_l.length + myFace.ordinal();
        if (blockToTexture[blockToWork].containsKey(BlockRef)) {
            String textureName = blockToTexture[blockToWork].get(BlockRef);
            return Minecraft.func_71410_x().func_147117_R().func_110572_b(textureName);
        }
        TextureAtlasSprite texture = null;
        IBlockState state = ModUtil.getStateById(BlockRef);
        if (model != null) {
            try {
                texture = ModelUtil.findTexture(texture, ModelUtil.getModelQuads(model, state, myFace, 0L), myFace);
                if (texture == null) {
                    for (EnumFacing side : EnumFacing.field_82609_l) {
                        texture = ModelUtil.findTexture(texture, ModelUtil.getModelQuads(model, state, side, 0L), side);
                    }
                    texture = ModelUtil.findTexture(texture, ModelUtil.getModelQuads(model, state, null, 0L), null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (texture == null) {
            try {
                if (texture == null) {
                    texture = model.func_177554_e();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (texture == null) {
            texture = Minecraft.func_71410_x().func_147117_R().func_174944_f();
        }
        blockToTexture[blockToWork].put(BlockRef, texture.func_94215_i());
        return texture;
    }

    private static TextureAtlasSprite findTexture(TextureAtlasSprite texture, List<BakedQuad> faceQuads, EnumFacing myFace) throws IllegalArgumentException, IllegalAccessException, NullPointerException {
        for (BakedQuad q : faceQuads) {
            if (q.func_178210_d() != myFace) continue;
            texture = ModelUtil.findQuadTexture(q);
        }
        return texture;
    }

    public static boolean isOne(float v) {
        return (double)Math.abs(v) < 0.01;
    }

    public static boolean isZero(float v) {
        return (double)Math.abs(v - 1.0f) < 0.01;
    }

    public static Integer getItemStackColor(ItemStack target, int tint) {
        return Minecraft.func_71410_x().getItemColors().func_186728_a(target, tint);
    }

    static {
        cache = new HashMap();
        instance = new ModelUtil();
        blockToTexture = new HashMap[EnumFacing.field_82609_l.length * BlockRenderLayer.values().length];
        for (int x = 0; x < blockToTexture.length; ++x) {
            ModelUtil.blockToTexture[x] = new HashMap();
        }
    }
}

