/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.render;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.interfaces.ICacheClearable;
import mod.chiselsandbits.render.bit.BitItemSmartModel;
import mod.chiselsandbits.render.chiseledblock.ChiseledBlockSmartModel;
import mod.chiselsandbits.render.chiseledblock.tesr.GfxRenderState;
import mod.chiselsandbits.render.patterns.PrintSmartModel;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class SmartModelManager {
    private final HashMap<ResourceLocation, IBakedModel> models = new HashMap();
    private final List<ModelResourceLocation> res = new ArrayList<ModelResourceLocation>();
    private final List<ICacheClearable> clearable = new ArrayList<ICacheClearable>();

    public SmartModelManager() {
        this.add(new ResourceLocation("chiselsandbits", "chiseled_iron"), new ChiseledBlockSmartModel());
        this.add(new ResourceLocation("chiselsandbits", "chiseled_clay"), new ChiseledBlockSmartModel());
        this.add(new ResourceLocation("chiselsandbits", "chiseled_cloth"), new ChiseledBlockSmartModel());
        this.add(new ResourceLocation("chiselsandbits", "chiseled_packedIce"), new ChiseledBlockSmartModel());
        this.add(new ResourceLocation("chiselsandbits", "chiseled_ice"), new ChiseledBlockSmartModel());
        this.add(new ResourceLocation("chiselsandbits", "chiseled_wood"), new ChiseledBlockSmartModel());
        this.add(new ResourceLocation("chiselsandbits", "chiseled_rock"), new ChiseledBlockSmartModel());
        this.add(new ResourceLocation("chiselsandbits", "chiseled_glass"), new ChiseledBlockSmartModel());
        this.add(new ResourceLocation("chiselsandbits", "chiseled_ground"), new ChiseledBlockSmartModel());
        this.add(new ResourceLocation("chiselsandbits", "chiseled_sand"), new ChiseledBlockSmartModel());
        this.add(new ResourceLocation("chiselsandbits", "chiseled_grass"), new ChiseledBlockSmartModel());
        this.add(new ResourceLocation("chiselsandbits", "chiseled_fluid"), new ChiseledBlockSmartModel());
        this.add(new ResourceLocation("chiselsandbits", "chiseled_snow"), new ChiseledBlockSmartModel());
        this.add(new ResourceLocation("chiselsandbits", "chiseled_leaves"), new ChiseledBlockSmartModel());
        this.add(new ResourceLocation("chiselsandbits", "models/item/block_chiseled"), new ChiseledBlockSmartModel());
        this.add(new ResourceLocation("chiselsandbits", "models/item/block_bit"), new BitItemSmartModel());
        this.add(new ResourceLocation("chiselsandbits", "models/item/positiveprint_written_preview"), new PrintSmartModel("positiveprint", ChiselsAndBits.getItems().itemPositiveprint));
        this.add(new ResourceLocation("chiselsandbits", "models/item/negativeprint_written_preview"), new PrintSmartModel("negativeprint", ChiselsAndBits.getItems().itemNegativeprint));
        this.add(new ResourceLocation("chiselsandbits", "models/item/mirrorprint_written_preview"), new PrintSmartModel("mirrorprint", ChiselsAndBits.getItems().itemMirrorprint));
    }

    private void add(ResourceLocation modelLocation, IBakedModel modelGen) {
        ResourceLocation second = new ResourceLocation(modelLocation.func_110624_b(), modelLocation.func_110623_a().substring(1 + modelLocation.func_110623_a().lastIndexOf(47)));
        if (modelGen instanceof ICacheClearable) {
            this.clearable.add((ICacheClearable)modelGen);
        }
        this.res.add(new ModelResourceLocation(modelLocation, null));
        this.res.add(new ModelResourceLocation(second, null));
        this.res.add(new ModelResourceLocation(modelLocation, "inventory"));
        this.res.add(new ModelResourceLocation(second, "inventory"));
        this.res.add(new ModelResourceLocation(modelLocation, "multipart"));
        this.res.add(new ModelResourceLocation(second, "multipart"));
        this.models.put(modelLocation, modelGen);
        this.models.put(second, modelGen);
        this.models.put((ResourceLocation)new ModelResourceLocation(modelLocation, null), modelGen);
        this.models.put((ResourceLocation)new ModelResourceLocation(second, null), modelGen);
        this.models.put((ResourceLocation)new ModelResourceLocation(modelLocation, "inventory"), modelGen);
        this.models.put((ResourceLocation)new ModelResourceLocation(second, "inventory"), modelGen);
        this.models.put((ResourceLocation)new ModelResourceLocation(modelLocation, "multipart"), modelGen);
        this.models.put((ResourceLocation)new ModelResourceLocation(second, "multipart"), modelGen);
    }

    @SubscribeEvent
    public void textureStichEvent(TextureStitchEvent.Post stitch) {
        ++GfxRenderState.gfxRefresh;
        ChiselsAndBits.getInstance().clearCache();
    }

    @SubscribeEvent
    public void onModelBakeEvent(ModelBakeEvent event) {
        for (ICacheClearable c : this.clearable) {
            c.clearCache();
        }
        for (ModelResourceLocation rl : this.res) {
            event.getModelRegistry().func_82595_a((Object)rl, (Object)this.getModel((ResourceLocation)rl));
        }
    }

    private IBakedModel getModel(ResourceLocation modelLocation) {
        try {
            return this.models.get(modelLocation);
        }
        catch (Exception e) {
            throw new RuntimeException("The Model: " + modelLocation.toString() + " was not available was requested.");
        }
    }
}

