/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.core;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import mod.chiselsandbits.api.IChiselAndBitsAPI;
import mod.chiselsandbits.chiseledblock.BlockBitInfo;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.client.CreativeClipboardTab;
import mod.chiselsandbits.client.UndoTracker;
import mod.chiselsandbits.client.gui.ModGuiRouter;
import mod.chiselsandbits.commands.SetBit;
import mod.chiselsandbits.config.ModConfig;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.core.api.ChiselAndBitsAPI;
import mod.chiselsandbits.core.api.IMCHandler;
import mod.chiselsandbits.crafting.BitSawCrafting;
import mod.chiselsandbits.crafting.ChiselCrafting;
import mod.chiselsandbits.crafting.MirrorTransferCrafting;
import mod.chiselsandbits.crafting.NegativeInversionCrafting;
import mod.chiselsandbits.crafting.StackableCrafting;
import mod.chiselsandbits.events.EventPlayerInteract;
import mod.chiselsandbits.events.VaporizeWater;
import mod.chiselsandbits.integration.Integration;
import mod.chiselsandbits.interfaces.ICacheClearable;
import mod.chiselsandbits.network.NetworkRouter;
import mod.chiselsandbits.registry.ModBlocks;
import mod.chiselsandbits.registry.ModItems;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommand;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLModIdMappingEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.RecipeSorter;

@Mod(name="Chisels & Bits", modid="chiselsandbits", version="12.12", acceptedMinecraftVersions="[1.10.2,1.11)", dependencies="required-after:Forge@[12.17.0.1909,);after:mcmultipart;after:JEI@[3.7.8.234,)", guiFactory="mod.chiselsandbits.client.gui.ModConfigGuiFactory")
public class ChiselsAndBits {
    public static final String MODNAME = "Chisels & Bits";
    public static final String MODID = "chiselsandbits";
    public static final String VERSION = "12.12";
    public static final String DEPENDENCIES = "required-after:Forge@[12.17.0.1909,);after:mcmultipart;after:JEI@[3.7.8.234,)";
    private static ChiselsAndBits instance;
    private ModConfig config;
    private ModItems items;
    private ModBlocks blocks;
    private final Integration integration = new Integration();
    private final IChiselAndBitsAPI api = new ChiselAndBitsAPI();
    List<ICacheClearable> cacheClearables = new ArrayList<ICacheClearable>();
    boolean idsHaveBeenMapped = false;

    public ChiselsAndBits() {
        instance = this;
    }

    public static ChiselsAndBits getInstance() {
        return instance;
    }

    public static ModBlocks getBlocks() {
        return ChiselsAndBits.instance.blocks;
    }

    public static ModItems getItems() {
        return ChiselsAndBits.instance.items;
    }

    public static ModConfig getConfig() {
        return ChiselsAndBits.instance.config;
    }

    public static IChiselAndBitsAPI getApi() {
        return ChiselsAndBits.instance.api;
    }

    @Mod.EventHandler
    private void handleIMCEvent(FMLInterModComms.IMCEvent event) {
        IMCHandler imcHandler = new IMCHandler();
        imcHandler.handleIMCEvent(event);
    }

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
        File configFile = event.getSuggestedConfigurationFile();
        this.config = new ModConfig(configFile);
        this.items = new ModItems(ChiselsAndBits.getConfig());
        this.blocks = new ModBlocks(ChiselsAndBits.getConfig(), event.getSide());
        this.integration.preinit(event);
        ChiselsAndBits.getApi().addEquivilantMaterial(Material.field_151583_m, Material.field_151571_B);
        ChiselsAndBits.getApi().addEquivilantMaterial(Material.field_151574_g, Material.field_151573_f);
        ChiselsAndBits.getApi().addEquivilantMaterial(Material.field_151585_k, Material.field_151577_b);
        ChiselsAndBits.getApi().addEquivilantMaterial(Material.field_151572_C, Material.field_151585_k);
        ChiselsAndBits.getApi().addEquivilantMaterial(Material.field_151570_A, Material.field_151585_k);
        ChiselsAndBits.getApi().addEquivilantMaterial(Material.field_151589_v, Material.field_151576_e);
        ChiselsAndBits.getApi().addEquivilantMaterial(Material.field_151569_G, Material.field_151585_k);
        ChiselsAndBits.getApi().addEquivilantMaterial(Material.field_151582_l, Material.field_151585_k);
        ChiselsAndBits.getApi().addEquivilantMaterial(Material.field_151590_u, Material.field_151576_e);
        if (event.getSide() == Side.CLIENT) {
            CreativeClipboardTab.load(new File(configFile.getParent(), "chiselsandbits_clipboard.cfg"));
            ClientSide.instance.preinit(this);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (event.getSide() == Side.CLIENT) {
            ClientSide.instance.init(this);
        }
        this.integration.init();
        ChiselsAndBits.registerWithBus(new EventPlayerInteract());
        ChiselsAndBits.registerWithBus(new VaporizeWater());
        ChiselsAndBits.getBlocks().addRecipes();
        ChiselsAndBits.getItems().addRecipes();
        String craftingOrder = "after:minecraft:shapeless";
        if (ChiselsAndBits.getConfig().enablePositivePrintCrafting) {
            GameRegistry.addRecipe((IRecipe)new ChiselCrafting());
            RecipeSorter.register((String)"chiselsandbits:chiselcrafting", ChiselCrafting.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        }
        if (ChiselsAndBits.getConfig().enableStackableCrafting) {
            GameRegistry.addRecipe((IRecipe)new StackableCrafting());
            RecipeSorter.register((String)"chiselsandbits:stackablecrafting", StackableCrafting.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        }
        if (ChiselsAndBits.getConfig().enableNegativePrintInversionCrafting) {
            GameRegistry.addRecipe((IRecipe)new NegativeInversionCrafting());
            RecipeSorter.register((String)"chiselsandbits:negativepatterncrafting", NegativeInversionCrafting.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        }
        if (ChiselsAndBits.getConfig().enableMirrorPrint) {
            GameRegistry.addRecipe((IRecipe)new MirrorTransferCrafting());
            RecipeSorter.register((String)"chiselsandbits:mirrorpatterncrafting", MirrorTransferCrafting.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        }
        if (ChiselsAndBits.getConfig().enableBitSaw) {
            GameRegistry.addRecipe((IRecipe)new BitSawCrafting());
            RecipeSorter.register((String)"chiselsandbits:bitsawcrafting", BitSawCrafting.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        }
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent e) {
        if (ChiselsAndBits.getConfig().enableSetBitCommand) {
            e.registerServerCommand((ICommand)new SetBit());
        }
    }

    @Mod.EventHandler
    public void postinit(FMLPostInitializationEvent event) {
        if (event.getSide() == Side.CLIENT) {
            ClientSide.instance.postinit(this);
        }
        this.integration.postinit();
        for (Fluid o : FluidRegistry.getRegisteredFluids().values()) {
            if (!o.canBePlacedInWorld()) continue;
            BlockBitInfo.addFluidBlock(o.getBlock(), o);
        }
        NetworkRouter.instance = new NetworkRouter();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new ModGuiRouter());
    }

    @Mod.EventHandler
    public void idsMapped(FMLModIdMappingEvent event) {
        this.idsHaveBeenMapped = true;
        this.clearCache();
    }

    public void clearCache() {
        if (this.idsHaveBeenMapped) {
            for (ICacheClearable clearable : this.cacheClearables) {
                clearable.clearCache();
            }
            this.addClearable(UndoTracker.getInstance());
            VoxelBlob.clearCache();
        }
    }

    public static void registerWithBus(Object obj) {
        MinecraftForge.EVENT_BUS.register(obj);
    }

    public void addClearable(ICacheClearable cache) {
        if (!this.cacheClearables.contains(cache)) {
            this.cacheClearables.add(cache);
        }
    }
}

