/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.blueprints;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.JFileChooser;
import mod.chiselsandbits.blueprints.BlueprintContainer;
import mod.chiselsandbits.blueprints.BlueprintData;
import mod.chiselsandbits.core.Log;
import mod.chiselsandbits.helpers.DeprecationHelper;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.network.ModPacket;
import mod.chiselsandbits.network.NetworkRouter;
import mod.chiselsandbits.network.packets.PacketBlueprintSet;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class BlueprintGui
extends GuiContainer {
    private static final ResourceLocation BAG_GUI_TEXTURE = new ResourceLocation("chiselsandbits", "textures/gui/container/blueprint.png");
    private GuiButton local;
    private GuiButton url;
    private GuiButton create;
    private GuiTextField urlField;

    public BlueprintGui(EntityPlayer player, World world, int x, int y, int z) {
        super((Container)new BlueprintContainer(player, world, x, y, z));
        this.field_146291_p = false;
        this.field_147000_g = 163;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int w = 156;
        this.urlField = new GuiTextField(0, this.field_146289_q, this.field_147003_i + 10, this.field_147009_r + 10, 156, 20);
        this.urlField.func_146193_g(-1);
        this.urlField.func_146204_h(-1);
        this.urlField.func_146185_a(true);
        this.urlField.func_146203_f(64);
        this.url = new GuiButton(1, this.field_147003_i + 10, this.field_147009_r + 35, 156, 20, DeprecationHelper.translateToLocal("mod.chiselsandbits.blueprint.url"));
        this.field_146292_n.add(this.url);
        this.local = new GuiButton(1, this.field_147003_i + 10, this.field_147009_r + 60, 156, 20, DeprecationHelper.translateToLocal("mod.chiselsandbits.blueprint.local"));
        this.field_146292_n.add(this.local);
        this.create = new GuiButton(1, this.field_147003_i + 10, this.field_147009_r + 85, 156, 20, DeprecationHelper.translateToLocal("mod.chiselsandbits.blueprint.create"));
        this.field_146292_n.add(this.create);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (!this.urlField.func_146201_a(typedChar, keyCode)) {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.urlField.func_146192_a(mouseX, mouseY, mouseButton);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179140_f();
        GlStateManager.func_179084_k();
        this.urlField.func_146194_f();
    }

    BlueprintContainer getBlueprintContainer() {
        return (BlueprintContainer)this.field_147002_h;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int xOffset = (this.field_146294_l - this.field_146999_f) / 2;
        int yOffset = (this.field_146295_m - this.field_147000_g) / 2;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(BAG_GUI_TEXTURE);
        this.func_73729_b(xOffset, yOffset, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        final BlueprintContainer c = (BlueprintContainer)this.field_147002_h;
        if (button == this.local) {
            c.thePlayer.func_71053_j();
            Thread picker = new Thread(new Runnable(){

                @Override
                public void run() {
                    JFileChooser fc = new JFileChooser();
                    if (fc.showOpenDialog(null) == 0) {
                        BlueprintData dat = new BlueprintData(null);
                        try {
                            dat.setLocalSource(fc.getSelectedFile().getPath());
                            dat.loadData(new FileInputStream(fc.getSelectedFile()));
                            if (dat.getState() == BlueprintData.EnumLoadState.LOADED) {
                                PacketBlueprintSet packet = new PacketBlueprintSet();
                                packet.setFrom(BlueprintGui.this.getBlueprintContainer().bluePrintSlot, dat);
                                NetworkRouter.instance.sendToServer((ModPacket)packet);
                            }
                        }
                        catch (FileNotFoundException e) {
                            c.thePlayer.func_146105_b((ITextComponent)new TextComponentTranslation(LocalStrings.ShareNoFile.toString(), new Object[0]));
                            Log.logError("Unable to read file into blueprint.", e);
                        }
                        catch (IOException e) {
                            c.thePlayer.func_146105_b((ITextComponent)new TextComponentTranslation(LocalStrings.ShareInvalidData.toString(), new Object[0]));
                            Log.logError("Invalid format or file.", e);
                        }
                    }
                }
            });
            picker.setName("Load File Picker");
            picker.start();
        } else if (button == this.url) {
            final String urlText = this.urlField.func_146179_b();
            c.thePlayer.func_71053_j();
            Thread picker = new Thread(new Runnable(){

                @Override
                public void run() {
                    InputStream in;
                    BlueprintData dat = new BlueprintData(null);
                    try {
                        URL url = new URL(urlText);
                        dat.setURLSource(url);
                        in = url.openStream();
                    }
                    catch (IOException e) {
                        c.thePlayer.func_146105_b((ITextComponent)new TextComponentTranslation(LocalStrings.ShareNoUrl.toString(), new Object[0]));
                        Log.logError("Unable to read url into blueprint.", e);
                        return;
                    }
                    try {
                        dat.loadData(in);
                        if (dat.getState() == BlueprintData.EnumLoadState.LOADED) {
                            PacketBlueprintSet packet = new PacketBlueprintSet();
                            packet.setFrom(BlueprintGui.this.getBlueprintContainer().bluePrintSlot, dat);
                            NetworkRouter.instance.sendToServer((ModPacket)packet);
                        }
                    }
                    catch (IOException e) {
                        c.thePlayer.func_146105_b((ITextComponent)new TextComponentTranslation(LocalStrings.ShareInvalidData.toString(), new Object[0]));
                        Log.logError("Invalid format or file.", e);
                    }
                }
            });
            picker.setName("Downloading blueprint - " + urlText);
            picker.start();
        } else if (button == this.create) {
            // empty if block
        }
    }
}

