/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.jei;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import mcjty.deepresonance.blocks.laser.LaserSetup;
import mcjty.deepresonance.blocks.laser.LaserTileEntity;
import mcjty.deepresonance.blocks.purifier.PurifierSetup;
import mcjty.deepresonance.blocks.smelter.SmelterSetup;
import mcjty.deepresonance.jei.laser.LaserRecipeCategory;
import mcjty.deepresonance.jei.laser.LaserRecipeHandler;
import mcjty.deepresonance.jei.laser.LaserRecipeWrapper;
import mcjty.deepresonance.jei.purifier.PurifierRecipeCategory;
import mcjty.deepresonance.jei.purifier.PurifierRecipeHandler;
import mcjty.deepresonance.jei.purifier.PurifierRecipeWrapper;
import mcjty.deepresonance.jei.smelter.SmelterRecipeCategory;
import mcjty.deepresonance.jei.smelter.SmelterRecipeHandler;
import mcjty.deepresonance.jei.smelter.SmelterRecipeWrapper;
import mcjty.lib.jei.JeiCompatTools;
import mezz.jei.api.BlankModPlugin;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@JEIPlugin
public class DeepResonanceJeiPlugin
extends BlankModPlugin {
    public void register(@Nonnull IModRegistry registry) {
        IJeiHelpers helpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = helpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new LaserRecipeCategory(guiHelper), new SmelterRecipeCategory(guiHelper), new PurifierRecipeCategory(guiHelper)});
        registry.addRecipeHandlers(new IRecipeHandler[]{new LaserRecipeHandler(), new SmelterRecipeHandler(), new PurifierRecipeHandler()});
        ArrayList<BlankRecipeWrapper> recipes = new ArrayList<BlankRecipeWrapper>();
        for (String registryName : LaserTileEntity.infusingBonusMap.keySet()) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(registryName));
            recipes.add(new LaserRecipeWrapper(item));
        }
        recipes.add(new SmelterRecipeWrapper());
        recipes.add(new PurifierRecipeWrapper());
        JeiCompatTools.addRecipes((IModRegistry)registry, recipes);
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)LaserSetup.laserBlock), new String[]{"DRLaser"});
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)SmelterSetup.smelter), new String[]{"DRSmelter"});
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)PurifierSetup.purifierBlock), new String[]{"DRPurifier"});
    }
}

