/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.integration.computers;

import java.util.HashMap;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.prefab.ManagedEnvironment;
import mcjty.deepresonance.blocks.smelter.SmelterTileEntity;
import mcjty.lib.integration.computers.AbstractOCDriver;
import mcjty.lib.network.Argument;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SmelterDriver {

    public static class OCDriver
    extends AbstractOCDriver {
        public OCDriver() {
            super("deepresonance_smelter", SmelterTileEntity.class);
        }

        public ManagedEnvironment createEnvironment(World world, BlockPos pos, EnumFacing side, TileEntity tile) {
            return new InternalManagedEnvironment((SmelterTileEntity)tile);
        }

        public static class InternalManagedEnvironment
        extends AbstractOCDriver.InternalManagedEnvironment<SmelterTileEntity> {
            public InternalManagedEnvironment(SmelterTileEntity tile) {
                super((Object)tile, "deepresonance_smelter");
            }

            @Callback(doc="function():number; Get the currently stored energy")
            public Object[] getEnergy(Context c, Arguments a) {
                return new Object[]{((SmelterTileEntity)this.tile).getEnergyStored(EnumFacing.DOWN)};
            }

            @Callback(doc="function():number; Get the maximum stored energy")
            public Object[] getMaxEnergy(Context c, Arguments a) {
                return new Object[]{((SmelterTileEntity)this.tile).getMaxEnergyStored(EnumFacing.DOWN)};
            }

            @Callback(doc="function():number; Get the current progress in percent")
            public Object[] getProgress(Context c, Arguments a) {
                Integer progress = ((SmelterTileEntity)this.tile).executeWithResultInteger("getProgress", new HashMap<String, Argument>());
                return new Object[]{(int)progress};
            }

            public int priority() {
                return 4;
            }
        }
    }
}

