/*
 * Decompiled with CFR 0.152.
 */
package techreborn.world;

import com.google.common.base.Predicate;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;
import org.hjson.JsonValue;
import org.hjson.Stringify;
import reborncore.common.misc.ChunkCoord;
import techreborn.Core;
import techreborn.init.ModBlocks;
import techreborn.world.RubberTreeGenerator;
import techreborn.world.TechRebornRetroGen;
import techreborn.world.config.OreConfig;
import techreborn.world.config.WorldGenConfig;

public class TechRebornWorldGen
implements IWorldGenerator {
    public static RubberTreeGenerator treeGenerator = new RubberTreeGenerator();
    public final TechRebornRetroGen retroGen = new TechRebornRetroGen();
    public File configFile;
    public File hConfigFile;
    public boolean jsonInvalid = false;
    public WorldGenConfig config;
    WorldGenConfig defaultConfig;

    private void init() {
        this.defaultConfig = new WorldGenConfig();
        this.defaultConfig.overworldOres = new ArrayList<OreConfig>();
        this.defaultConfig.endOres = new ArrayList<OreConfig>();
        this.defaultConfig.neatherOres = new ArrayList<OreConfig>();
        this.defaultConfig.overworldOres.add(new OreConfig(ModBlocks.ORE.getBlockStateFromName("Galena"), 8, 16, 10, 60));
        this.defaultConfig.overworldOres.add(new OreConfig(ModBlocks.ORE.getBlockStateFromName("Iridium"), 3, 3, 5, 60));
        this.defaultConfig.overworldOres.add(new OreConfig(ModBlocks.ORE.getBlockStateFromName("Ruby"), 6, 3, 10, 60));
        this.defaultConfig.overworldOres.add(new OreConfig(ModBlocks.ORE.getBlockStateFromName("Sapphire"), 6, 3, 10, 60));
        this.defaultConfig.overworldOres.add(new OreConfig(ModBlocks.ORE.getBlockStateFromName("Bauxite"), 6, 10, 10, 60));
        this.defaultConfig.overworldOres.add(new OreConfig(ModBlocks.ORE.getBlockStateFromName("Lead"), 6, 16, 20, 60));
        this.defaultConfig.overworldOres.add(new OreConfig(ModBlocks.ORE.getBlockStateFromName("Silver"), 6, 16, 20, 60));
        this.defaultConfig.overworldOres.add(new OreConfig(ModBlocks.ORE.getBlockStateFromName("copper"), 8, 16, 20, 60));
        this.defaultConfig.overworldOres.add(new OreConfig(ModBlocks.ORE.getBlockStateFromName("tin"), 8, 16, 20, 60));
        this.defaultConfig.overworldOres.add(new OreConfig(ModBlocks.ORE.getBlockStateFromName("garnierite"), 10, 2, 32, 128));
        this.defaultConfig.neatherOres.add(new OreConfig(ModBlocks.ORE.getBlockStateFromName("Pyrite"), 6, 3, 10, 126));
        this.defaultConfig.neatherOres.add(new OreConfig(ModBlocks.ORE.getBlockStateFromName("Cinnabar"), 6, 3, 10, 126));
        this.defaultConfig.neatherOres.add(new OreConfig(ModBlocks.ORE.getBlockStateFromName("Sphalerite"), 6, 3, 10, 126));
        this.defaultConfig.endOres.add(new OreConfig(ModBlocks.ORE.getBlockStateFromName("Tungsten"), 6, 3, 10, 250));
        this.defaultConfig.endOres.add(new OreConfig(ModBlocks.ORE.getBlockStateFromName("Sheldonite"), 6, 3, 10, 250));
        this.defaultConfig.endOres.add(new OreConfig(ModBlocks.ORE.getBlockStateFromName("Peridot"), 6, 3, 10, 250));
        this.defaultConfig.endOres.add(new OreConfig(ModBlocks.ORE.getBlockStateFromName("Sodalite"), 6, 3, 10, 250));
    }

    public void load() {
        this.init();
        if (this.configFile.exists() && !this.hConfigFile.exists()) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(this.configFile));
                String hJson = JsonValue.readHjson((Reader)reader).toString(Stringify.HJSON);
                FileWriter writer = new FileWriter(this.hConfigFile);
                writer.write(hJson);
                writer.close();
                reader.close();
                this.configFile.delete();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.hConfigFile.exists()) {
            this.loadFromJson();
        } else {
            this.config = this.defaultConfig;
            this.jsonInvalid = true;
        }
        this.config.overworldOres.addAll(this.getMissingOres(this.config.overworldOres, this.defaultConfig.overworldOres));
        this.config.neatherOres.addAll(this.getMissingOres(this.config.neatherOres, this.defaultConfig.neatherOres));
        this.config.endOres.addAll(this.getMissingOres(this.config.endOres, this.defaultConfig.endOres));
        if (this.jsonInvalid) {
            this.save();
        }
    }

    private List<OreConfig> getMissingOres(List<OreConfig> config, List<OreConfig> defaultOres) {
        ArrayList<OreConfig> missingOres = new ArrayList<OreConfig>();
        for (OreConfig defaultOre : defaultOres) {
            boolean hasFoundOre = false;
            for (OreConfig ore : config) {
                if (!ore.blockName.equals(defaultOre.blockName) || ore.meta != defaultOre.meta) continue;
                hasFoundOre = true;
                ore.state = defaultOre.state;
            }
            if (hasFoundOre) continue;
            this.jsonInvalid = true;
            missingOres.add(defaultOre);
        }
        return missingOres;
    }

    private void loadFromJson() {
        try {
            Gson gson = new Gson();
            BufferedReader reader = new BufferedReader(new FileReader(this.hConfigFile));
            String jsonString = JsonValue.readHjson((Reader)reader).toString();
            Type typeOfHashMap = new TypeToken<WorldGenConfig>(){}.getType();
            this.config = (WorldGenConfig)gson.fromJson(jsonString, typeOfHashMap);
        }
        catch (Exception e) {
            Core.logHelper.error((Object)"The ores.json file was invalid, bad things are about to happen, I will try and save the world now :");
            this.config = this.defaultConfig;
            this.jsonInvalid = true;
            Core.logHelper.error((Object)"The ores.json file was ignored and the default values loaded, you file will NOT be over written");
            e.printStackTrace();
        }
    }

    public void printError(String string) {
        Core.logHelper.error((Object)"###############-ERROR-####################");
        Core.logHelper.error((Object)"");
        Core.logHelper.error((Object)string);
        Core.logHelper.error((Object)"");
        Core.logHelper.error((Object)"###############-ERROR-####################");
    }

    private void save() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((Object)this.config);
        String hJson = JsonValue.readHjson((String)json).toString(Stringify.HJSON);
        try {
            FileWriter writer = new FileWriter(this.hConfigFile);
            writer.write(hJson);
            writer.close();
        }
        catch (IOException e) {
            Core.logHelper.error((Object)"The ores.json file was invalid, something bad happened");
            e.printStackTrace();
        }
    }

    public List<OreConfig> getAllGenOresFromList(List<OreConfig> configList) {
        ArrayList<OreConfig> list = new ArrayList<OreConfig>();
        for (OreConfig config : configList) {
            if (config.veinSize == 0 || config.veinsPerChunk == 0 || !config.shouldSpawn) continue;
            list.add(config);
        }
        return list;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (!this.config.generateTechRebornFeatures) {
            return;
        }
        boolean genTree = false;
        ArrayList<OreConfig> list = new ArrayList<OreConfig>();
        BlockMatcher predicate = BlockMatcher.func_177642_a((Block)Blocks.field_150348_b);
        if (world.field_73011_w.func_76569_d()) {
            list.addAll(this.getAllGenOresFromList(this.config.overworldOres));
            genTree = true;
        } else if (world.field_73011_w.getDimension() == -1) {
            list.addAll(this.getAllGenOresFromList(this.config.neatherOres));
            predicate = BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL);
        } else if (world.field_73011_w.getDimension() == 1) {
            list.addAll(this.getAllGenOresFromList(this.config.endOres));
            predicate = BlockMatcher.func_177642_a((Block)Blocks.field_150377_bs);
        }
        if (!list.isEmpty() && this.config.generateOres) {
            for (OreConfig ore : list) {
                WorldGenMinable worldGenMinable = new WorldGenMinable(ore.state, ore.veinSize, (Predicate)predicate);
                if (ore.state == null) continue;
                for (int i = 0; i < ore.veinsPerChunk; ++i) {
                    int xPos = chunkX * 16 + random.nextInt(16);
                    if (ore.maxYHeight == -1 || ore.minYHeight == -1) continue;
                    int yPos = ore.minYHeight + random.nextInt(ore.maxYHeight - ore.minYHeight);
                    int zPos = chunkZ * 16 + random.nextInt(16);
                    BlockPos pos = new BlockPos(xPos, yPos, zPos);
                    if (ore.blockNiceName.equalsIgnoreCase("iridium")) {
                        BlockPos iridiumPos = pos.func_177982_a(8, 0, 8);
                        IBlockState blockState = world.func_180495_p(iridiumPos);
                        if (!blockState.func_177230_c().isReplaceableOreGen(blockState, (IBlockAccess)world, iridiumPos, (Predicate)predicate)) continue;
                        world.func_180501_a(iridiumPos, ore.state, 2);
                        continue;
                    }
                    try {
                        worldGenMinable.func_180709_b(world, random, pos);
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        Core.logHelper.error((Object)("Something bad is happening during world gen the ore " + ore.blockNiceName + " caused a crash when generating. Report this to the TechReborn devs with a log"));
                    }
                }
            }
        }
        if (genTree && this.config.rubberTreeConfig.shouldSpawn) {
            int chance = this.config.rubberTreeConfig.chance;
            boolean isValidSpawn = false;
            Biome biomeGenBase = world.getBiomeForCoordsBody(new BlockPos(chunkX * 16, 72, chunkZ * 16));
            if (BiomeDictionary.isBiomeOfType((Biome)biomeGenBase, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
                chance -= random.nextInt(10) + 10;
                isValidSpawn = true;
            }
            if (BiomeDictionary.isBiomeOfType((Biome)biomeGenBase, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || BiomeDictionary.isBiomeOfType((Biome)biomeGenBase, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
                chance -= random.nextInt(5) + 3;
                isValidSpawn = true;
            }
            if (!isValidSpawn) {
                return;
            }
            if (chance <= 0) {
                chance = 1;
            }
            if (random.nextInt(chance) == 0) {
                int x = chunkX * 16;
                int z = chunkZ * 16;
                for (int i = 0; i < this.config.rubberTreeConfig.clusterSize; ++i) {
                    treeGenerator.func_180709_b(world, random, new BlockPos(x, 72, z));
                }
            }
            this.retroGen.markChunk(ChunkCoord.of((int)chunkX, (int)chunkZ));
        }
    }
}

