/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.generator;

import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import reborncore.api.power.EnumPowerTier;
import reborncore.common.IWrenchable;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.TilePowerAcceptor;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModBlocks;

public class TileHeatGenerator
extends TilePowerAcceptor
implements IWrenchable {
    public static final int euTick = ConfigTechReborn.HeatGeneratorOutput;
    private long lastOutput = 0L;

    public TileHeatGenerator() {
        super(1);
    }

    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            for (EnumFacing direction : EnumFacing.values()) {
                if (direction.equals((Object)EnumFacing.UP) || this.field_145850_b.func_180495_p(new BlockPos(this.func_174877_v().func_177958_n() + direction.func_82601_c(), this.func_174877_v().func_177956_o() + direction.func_96559_d(), this.func_174877_v().func_177952_p() + direction.func_82599_e())).func_177230_c() != Blocks.field_150353_l || !this.tryAddingEnergy(euTick)) continue;
                this.lastOutput = this.field_145850_b.func_82737_E();
            }
            if (this.field_145850_b.func_82737_E() - this.lastOutput < 30L && !this.isActive()) {
                this.field_145850_b.func_175656_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()).func_177226_a((IProperty)BlockMachineBase.ACTIVE, (Comparable)Boolean.valueOf(true)));
            } else if (this.field_145850_b.func_82737_E() - this.lastOutput > 30L && this.isActive()) {
                this.field_145850_b.func_175656_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()).func_177226_a((IProperty)BlockMachineBase.ACTIVE, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    private boolean tryAddingEnergy(int amount) {
        if (this.getMaxPower() - this.getEnergy() >= (double)amount) {
            this.addEnergy(amount);
            return true;
        }
        if (this.getMaxPower() - this.getEnergy() > 0.0) {
            this.addEnergy(this.getMaxPower() - this.getEnergy());
            return true;
        }
        return false;
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.func_70093_af();
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.HEAT_GENERATOR, 1);
    }

    public boolean isComplete() {
        return false;
    }

    public double getMaxPower() {
        return 10000.0;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return false;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return true;
    }

    public double getMaxOutput() {
        return 64.0;
    }

    public double getMaxInput() {
        return 0.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.LOW;
    }
}

