/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;
import reborncore.api.IListInfoProvider;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;

public class TileTechStorageBase
extends TileLegacyMachineBase
implements IInventoryProvider,
IWrenchable,
IListInfoProvider,
IDeepStorageUnit {
    public final int maxCapacity;
    public final Inventory inventory;
    public InvWrapper invWrapper;
    public ItemStack storedItem;

    public TileTechStorageBase(String name, int maxCapacity) {
        this.maxCapacity = maxCapacity;
        this.storedItem = null;
        this.inventory = new Inventory(3, name, maxCapacity, (TileEntity)this);
    }

    public void updateEntity() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.func_70301_a(0) != null) {
                if (this.getStoredItemType() == null || this.getStoredItemType() == null && ItemUtils.isItemEqual((ItemStack)this.func_70301_a(0), (ItemStack)this.func_70301_a(1), (boolean)true, (boolean)true)) {
                    this.storedItem = this.func_70301_a(0);
                    this.func_70299_a(0, null);
                    this.syncWithAll();
                } else if (ItemUtils.isItemEqual((ItemStack)this.getStoredItemType(), (ItemStack)this.func_70301_a(0), (boolean)true, (boolean)true)) {
                    this.setStoredItemCount(this.func_70301_a((int)0).field_77994_a);
                    this.func_70299_a(0, null);
                    this.syncWithAll();
                }
            }
            if (this.storedItem != null) {
                if (this.func_70301_a(1) == null) {
                    ItemStack delivered = this.storedItem.func_77946_l();
                    delivered.field_77994_a = Math.min(this.storedItem.field_77994_a, delivered.func_77976_d());
                    this.storedItem.field_77994_a -= delivered.field_77994_a;
                    if (this.storedItem.field_77994_a == 0) {
                        this.storedItem = null;
                    }
                    this.func_70299_a(1, delivered);
                    this.syncWithAll();
                } else if (ItemUtils.isItemEqual((ItemStack)this.storedItem, (ItemStack)this.func_70301_a(1), (boolean)true, (boolean)true) && this.func_70301_a((int)1).field_77994_a < this.func_70301_a(1).func_77976_d()) {
                    int wanted = Math.min(this.storedItem.field_77994_a, this.func_70301_a(1).func_77976_d() - this.func_70301_a((int)1).field_77994_a);
                    this.func_70301_a((int)1).field_77994_a += wanted;
                    this.storedItem.field_77994_a -= wanted;
                    if (this.storedItem.field_77994_a == 0) {
                        this.storedItem = null;
                    }
                    this.syncWithAll();
                }
            }
        }
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.field_145850_b.func_147458_c(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.readFromNBTWithoutCoords(tagCompound);
    }

    public void readFromNBTWithoutCoords(NBTTagCompound tagCompound) {
        this.storedItem = null;
        if (tagCompound.func_74764_b("storedStack")) {
            this.storedItem = ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)tagCompound.func_74781_a("storedStack")));
        }
        if (this.storedItem != null) {
            this.storedItem.field_77994_a = tagCompound.func_74762_e("storedQuantity");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        this.writeToNBTWithoutCoords(tagCompound);
        return tagCompound;
    }

    public NBTTagCompound writeToNBTWithoutCoords(NBTTagCompound tagCompound) {
        if (this.storedItem != null) {
            tagCompound.func_74782_a("storedStack", (NBTBase)this.storedItem.func_77955_b(new NBTTagCompound()));
            tagCompound.func_74768_a("storedQuantity", this.storedItem.field_77994_a);
        } else {
            tagCompound.func_74768_a("storedQuantity", 0);
        }
        return tagCompound;
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.func_70093_af();
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return this.getDropWithNBT();
    }

    public ItemStack getDropWithNBT() {
        NBTTagCompound tileEntity = new NBTTagCompound();
        ItemStack dropStack = new ItemStack(this.func_145838_q(), 1);
        this.writeToNBTWithoutCoords(tileEntity);
        dropStack.func_77982_d(new NBTTagCompound());
        dropStack.func_77978_p().func_74782_a("tileEntity", (NBTBase)tileEntity);
        return dropStack;
    }

    public List<ItemStack> getContentDrops() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (this.getStoredItemType() != null) {
            if (this.func_70301_a(1) != null) {
                stacks.add(this.func_70301_a(1));
            }
            for (int i = 0; i < this.getStoredCount() / 64; ++i) {
                ItemStack droped = this.storedItem.func_77946_l();
                droped.field_77994_a = 64;
                stacks.add(droped);
            }
            if (this.getStoredCount() % 64 != 0) {
                ItemStack droped = this.storedItem.func_77946_l();
                droped.field_77994_a = this.getStoredCount() % 64;
                stacks.add(droped);
            }
        }
        return stacks;
    }

    public ItemStack getStoredItemType() {
        return this.storedItem == null ? this.func_70301_a(1) : this.storedItem;
    }

    public void setStoredItemCount(int amount) {
        this.storedItem.field_77994_a += amount;
        this.func_70296_d();
    }

    public void setStoredItemType(ItemStack type, int amount) {
        this.storedItem = type;
        this.storedItem.field_77994_a = amount;
        this.func_70296_d();
    }

    public int getMaxStoredCount() {
        return this.maxCapacity;
    }

    public int getStoredCount() {
        return this.storedItem.field_77994_a;
    }

    public void addInfo(List<String> info, boolean isRealTile) {
        if (isRealTile) {
            int size = 0;
            String name = "of nothing";
            if (this.storedItem != null) {
                name = this.storedItem.func_82833_r();
                size += this.storedItem.field_77994_a;
            }
            if (this.func_70301_a(1) != null) {
                name = this.func_70301_a(1).func_82833_r();
                size += this.func_70301_a((int)1).field_77994_a;
            }
            info.add(size + " " + name);
        }
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.getInvWrapper();
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public InvWrapper getInvWrapper() {
        if (this.invWrapper == null) {
            this.invWrapper = new InvWrapper((IInventory)this);
        }
        return this.invWrapper;
    }
}

