/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.block.EnumBlock;
import slimeknights.tconstruct.smeltery.block.BlockEnumSmeltery;
import slimeknights.tconstruct.smeltery.tileentity.TileTank;

public class BlockTank
extends BlockEnumSmeltery<TankType> {
    public static final PropertyEnum<TankType> TYPE = PropertyEnum.func_177709_a((String)"type", TankType.class);
    public static final PropertyBool KNOB = PropertyBool.func_177716_a((String)"has_knob");

    public BlockTank() {
        super(TYPE, TankType.class);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)KNOB, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    @Nonnull
    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        return new TileTank();
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, KNOB});
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        boolean hasKnob = state.func_177229_b(TYPE) == TankType.TANK && worldIn.func_175623_d(pos.func_177984_a());
        return super.func_176221_a(state, worldIn, pos).func_177226_a((IProperty)KNOB, (Comparable)Boolean.valueOf(hasKnob));
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        IBlockState state = super.func_176203_a(meta);
        if (meta == TankType.TANK.getMeta()) {
            state = state.func_177226_a((IProperty)KNOB, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te == null || !te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)) {
            return false;
        }
        IFluidHandler fluidHandler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
        FluidUtil.interactWithFluidHandler((ItemStack)heldItem, (IFluidHandler)fluidHandler, (EntityPlayer)playerIn);
        return heldItem != null && !(heldItem.func_77973_b() instanceof ItemBlock);
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileTank && stack != null && stack.func_77942_o()) {
            ((TileTank)te).readTankFromNBT(stack.func_77978_p());
        }
    }

    @Nonnull
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        TileEntity te;
        ArrayList ret = Lists.newArrayList();
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        Item item = this.func_180660_a(state, rand, fortune);
        ItemStack stack = null;
        if (item != null) {
            stack = new ItemStack(item, 1, this.func_180651_a(state));
            ret.add(stack);
        }
        if ((te = world.func_175625_s(pos)) instanceof TileTank && stack != null && ((TileTank)te).containsFluid()) {
            NBTTagCompound tag = new NBTTagCompound();
            ((TileTank)te).writeTankToNBT(tag);
            stack.func_77982_d(tag);
        }
        return ret;
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        this.func_176206_d(world, pos, state);
        if (willHarvest) {
            this.func_180657_a(world, player, pos, state, world.func_175625_s(pos), player.func_184614_ca());
        }
        world.func_175698_g(pos);
        return false;
    }

    public int getLightValue(@Nonnull IBlockState state, IBlockAccess world, @Nonnull BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof TileTank)) {
            return 0;
        }
        TileTank tank = (TileTank)te;
        return tank.getBrightness();
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof TileTank)) {
            return 0;
        }
        return ((TileTank)te).comparatorStrength();
    }

    public static enum TankType implements IStringSerializable,
    EnumBlock.IEnumMeta
    {
        TANK,
        GAUGE,
        WINDOW;

        public final int meta = this.ordinal();

        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.US);
        }

        public int getMeta() {
            return this.meta;
        }
    }
}

