/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.debug;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.Material;

public class LocalizationCheckCommand
extends CommandBase {
    public int func_82362_a() {
        return 0;
    }

    @Nonnull
    public String func_71517_b() {
        return "checkLocalizationStrings";
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "/" + this.func_71517_b() + " [Material-Identifier]";
    }

    @Nonnull
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        if (args.length != 1) {
            return null;
        }
        LinkedList completions = Lists.newLinkedList();
        String matName = args[0].toLowerCase();
        for (Material mat : TinkerRegistry.getAllMaterials()) {
            if (!mat.identifier.toLowerCase().startsWith(matName)) continue;
            completions.add(mat.identifier);
        }
        return completions;
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        if (args.length > 1) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if (args.length > 0) {
            Material mat = TinkerRegistry.getMaterial(args[0]);
            if (mat == Material.UNKNOWN) {
                throw new CommandException("Unknown material: " + args[0], new Object[0]);
            }
            this.scanMaterial(mat, sender);
        } else {
            for (Material mat : TinkerRegistry.getAllMaterials()) {
                this.scanMaterial(mat, sender);
            }
        }
    }

    private void scanMaterial(Material material, ICommandSender sender) {
        this.checkStr(String.format("material.%s.name", material.identifier), sender);
    }

    private void checkStr(String str, ICommandSender sender) {
        if (!I18n.func_94522_b((String)str)) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Missing localization for name: " + str));
        }
    }
}

