/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.EnumSet;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.Range4D;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Mekanism;
import mekanism.common.SideData;
import mekanism.common.Tier;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.ITierUpgradeable;
import mekanism.common.integration.IComputerIntegration;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.util.CableUtils;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityEnergyCube
extends TileEntityElectricBlock
implements IComputerIntegration,
IRedstoneControl,
ISideConfiguration,
ISecurityTile,
ITierUpgradeable {
    public Tier.EnergyCubeTier tier = Tier.EnergyCubeTier.BASIC;
    public int currentRedstoneLevel;
    public IRedstoneControl.RedstoneControl controlType;
    public int prevScale;
    public TileComponentEjector ejectorComponent;
    public TileComponentConfig configComponent = new TileComponentConfig(this, TransmissionType.ENERGY, TransmissionType.ITEM);
    public TileComponentSecurity securityComponent;
    private static final String[] methods = new String[]{"getEnergy", "getOutput", "getMaxEnergy", "getEnergyNeeded"};

    public TileEntityEnergyCube() {
        super("EnergyCube", 0.0);
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("None", EnumColor.GREY, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Charge", EnumColor.DARK_BLUE, new int[]{0}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Discharge", EnumColor.DARK_RED, new int[]{1}));
        this.configComponent.setConfig(TransmissionType.ITEM, new byte[]{0, 0, 0, 0, 2, 1});
        this.configComponent.setCanEject(TransmissionType.ITEM, false);
        this.configComponent.setIOConfig(TransmissionType.ENERGY);
        this.configComponent.setEjecting(TransmissionType.ENERGY, true);
        this.inventory = new ItemStack[2];
        this.controlType = IRedstoneControl.RedstoneControl.DISABLED;
        this.ejectorComponent = new TileComponentEjector(this);
        this.securityComponent = new TileComponentSecurity(this);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            int newScale;
            ChargeUtils.charge(0, this);
            ChargeUtils.discharge(1, this);
            if (MekanismUtils.canFunction(this) && this.configComponent.isEjecting(TransmissionType.ENERGY)) {
                CableUtils.emit(this);
            }
            if ((newScale = this.getScaledEnergyLevel(20)) != this.prevScale) {
                Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList<Object>())), new Range4D(Coord4D.get(this)));
            }
            this.prevScale = newScale;
        }
    }

    @Override
    public boolean upgrade(Tier.BaseTier upgradeTier) {
        if (upgradeTier.ordinal() != this.tier.ordinal() + 1) {
            return false;
        }
        this.tier = Tier.EnergyCubeTier.values()[upgradeTier.ordinal()];
        Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList<Object>())), new Range4D(Coord4D.get(this)));
        this.func_70296_d();
        return true;
    }

    @Override
    public String func_70005_c_() {
        return LangUtils.localize("tile.EnergyCube" + this.tier.getBaseTier().getSimpleName() + ".name");
    }

    @Override
    public double getMaxOutput() {
        if (this.tier == Tier.EnergyCubeTier.CREATIVE) {
            return 2.147483647E9;
        }
        return this.tier.output;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return ChargeUtils.canBeCharged(itemstack);
        }
        if (slotID == 1) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return true;
    }

    @Override
    public EnumSet<EnumFacing> getConsumingSides() {
        return this.configComponent.getSidesForData(TransmissionType.ENERGY, this.facing, 1);
    }

    @Override
    public EnumSet<EnumFacing> getOutputtingSides() {
        return this.configComponent.getSidesForData(TransmissionType.ENERGY, this.facing, 2);
    }

    @Override
    public boolean canSetFacing(int side) {
        return true;
    }

    @Override
    public double getMaxEnergy() {
        return this.tier.maxEnergy;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return this.configComponent.getOutput((TransmissionType)TransmissionType.ITEM, (EnumFacing)side, (EnumFacing)this.facing).availableSlots;
    }

    @Override
    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        if (slotID == 1) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        if (slotID == 0) {
            return ChargeUtils.canBeOutputted(itemstack, true);
        }
        return false;
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.getEnergy()};
            }
            case 1: {
                return new Object[]{this.tier.output};
            }
            case 2: {
                return new Object[]{this.getMaxEnergy()};
            }
            case 3: {
                return new Object[]{this.getMaxEnergy() - this.getEnergy()};
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            Tier.EnergyCubeTier prevTier = this.tier;
            this.tier = Tier.EnergyCubeTier.values()[dataStream.readInt()];
            this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
            if (prevTier != this.tier) {
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
            }
        }
    }

    @Override
    public ArrayList<Object> getNetworkedData(ArrayList<Object> data) {
        super.getNetworkedData(data);
        data.add(this.tier.ordinal());
        data.add(this.controlType.ordinal());
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.tier = Tier.EnergyCubeTier.values()[nbtTags.func_74762_e("tier")];
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("tier", this.tier.ordinal());
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        return nbtTags;
    }

    @Override
    public void setEnergy(double energy) {
        if (this.tier == Tier.EnergyCubeTier.CREATIVE && energy != Double.MAX_VALUE) {
            return;
        }
        super.setEnergy(energy);
        int newRedstoneLevel = this.getRedstoneLevel();
        if (newRedstoneLevel != this.currentRedstoneLevel) {
            this.func_70296_d();
            this.currentRedstoneLevel = newRedstoneLevel;
        }
    }

    public int getRedstoneLevel() {
        double fractionFull = this.getEnergy() / this.getMaxEnergy();
        return MathHelper.func_76141_d((float)((float)(fractionFull * 14.0))) + (fractionFull > 0.0 ? 1 : 0);
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
    }

    @Override
    public boolean canPulse() {
        return false;
    }

    @Override
    public TileComponentEjector getEjector() {
        return this.ejectorComponent;
    }

    @Override
    public TileComponentConfig getConfig() {
        return this.configComponent;
    }

    @Override
    public EnumFacing getOrientation() {
        return this.facing;
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }
}

