/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multipart;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import java.util.Collection;
import java.util.List;
import mekanism.api.MekanismConfig;
import mekanism.api.energy.EnergyStack;
import mekanism.api.energy.IStrictEnergyAcceptor;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.api.transmitters.TransmissionType;
import mekanism.api.util.CapabilityUtils;
import mekanism.common.EnergyNetwork;
import mekanism.common.Tier;
import mekanism.common.base.EnergyAcceptorWrapper;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.multipart.PartSidedPipe;
import mekanism.common.multipart.PartTransmitter;
import mekanism.common.multipart.TransmitterType;
import mekanism.common.util.CableUtils;
import mekanism.common.util.MekanismUtils;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaProducer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="net.darkhax.tesla.api.ITeslaConsumer", modid="tesla")})
public class PartUniversalCable
extends PartTransmitter<EnergyAcceptorWrapper, EnergyNetwork>
implements IStrictEnergyAcceptor,
IEnergyReceiver,
IEnergyProvider,
ITeslaConsumer {
    public Tier.CableTier tier;
    public double currentPower = 0.0;
    public double lastWrite = 0.0;
    public EnergyStack buffer = new EnergyStack(0.0);

    public PartUniversalCable(Tier.CableTier cableTier) {
        this.tier = cableTier;
    }

    @Override
    public void func_73660_a() {
        if (this.getWorld().field_72995_K) {
            double targetPower;
            double d = targetPower = this.getTransmitter().hasTransmitterNetwork() ? ((EnergyNetwork)this.getTransmitter().getTransmitterNetwork()).clientEnergyScale : 0.0;
            if (Math.abs(this.currentPower - targetPower) > 0.01) {
                this.currentPower = (9.0 * this.currentPower + targetPower) / 10.0;
            }
        } else {
            this.updateShare();
            List<EnumFacing> sides = this.getConnections(PartSidedPipe.ConnectionType.PULL);
            if (!sides.isEmpty()) {
                TileEntity[] connectedOutputters = CableUtils.getConnectedOutputters(this.getPos(), this.getWorld());
                double canDraw = (float)this.tier.cableCapacity / 10.0f;
                for (EnumFacing side : sides) {
                    IEnergyTile tile;
                    double toDraw;
                    double received;
                    if (connectedOutputters[side.ordinal()] == null) continue;
                    TileEntity outputter = connectedOutputters[side.ordinal()];
                    if (CapabilityUtils.hasCapability((ICapabilityProvider)outputter, Capabilities.CABLE_OUTPUTTER_CAPABILITY, side.func_176734_d()) && CapabilityUtils.hasCapability((ICapabilityProvider)outputter, Capabilities.ENERGY_STORAGE_CAPABILITY, side.func_176734_d())) {
                        IStrictEnergyStorage storage = CapabilityUtils.getCapability((ICapabilityProvider)outputter, Capabilities.ENERGY_STORAGE_CAPABILITY, side.func_176734_d());
                        toDraw = received = Math.min(storage.getEnergy(), canDraw);
                        if (received > 0.0) {
                            toDraw -= this.takeEnergy(received, true);
                        }
                        storage.setEnergy(storage.getEnergy() - toDraw);
                        continue;
                    }
                    if (MekanismUtils.useTesla() && CapabilityUtils.hasCapability((ICapabilityProvider)outputter, Capabilities.TESLA_PRODUCER_CAPABILITY, side.func_176734_d())) {
                        ITeslaProducer producer = CapabilityUtils.getCapability((ICapabilityProvider)outputter, Capabilities.TESLA_PRODUCER_CAPABILITY, side.func_176734_d());
                        toDraw = received = (double)producer.takePower((long)(canDraw * MekanismConfig.general.TO_TESLA), true) * MekanismConfig.general.FROM_TESLA;
                        if (received > 0.0) {
                            toDraw -= this.takeEnergy(received, true);
                        }
                        producer.takePower((long)(toDraw * MekanismConfig.general.TO_TESLA), false);
                        continue;
                    }
                    if (MekanismUtils.useRF() && outputter instanceof IEnergyProvider) {
                        double received2;
                        double toDraw2 = received2 = (double)((IEnergyProvider)outputter).extractEnergy(side.func_176734_d(), (int)(canDraw * MekanismConfig.general.TO_RF), true) * MekanismConfig.general.FROM_RF;
                        if (received2 > 0.0) {
                            toDraw2 -= this.takeEnergy(received2, true);
                        }
                        ((IEnergyProvider)outputter).extractEnergy(side.func_176734_d(), (int)(toDraw2 * MekanismConfig.general.TO_RF), false);
                        continue;
                    }
                    if (!MekanismUtils.useIC2() || !((tile = EnergyNet.instance.getSubTile(outputter.func_145831_w(), outputter.func_174877_v())) instanceof IEnergySource)) continue;
                    toDraw = received = Math.min(((IEnergySource)tile).getOfferedEnergy() * MekanismConfig.general.FROM_IC2, canDraw);
                    if (received > 0.0) {
                        toDraw -= this.takeEnergy(received, true);
                    }
                    ((IEnergySource)tile).drawEnergy(toDraw * MekanismConfig.general.TO_IC2);
                }
            }
        }
        super.func_73660_a();
    }

    @Override
    public void updateShare() {
        double last;
        if (this.getTransmitter().hasTransmitterNetwork() && this.getTransmitter().getTransmitterNetworkSize() > 0 && (last = this.getSaveShare()) != this.lastWrite) {
            this.lastWrite = last;
            this.markDirty();
        }
    }

    private double getSaveShare() {
        if (this.getTransmitter().hasTransmitterNetwork()) {
            return EnergyNetwork.round(((EnergyNetwork)this.getTransmitter().getTransmitterNetwork()).buffer.amount * (double)(1.0f / (float)((EnergyNetwork)this.getTransmitter().getTransmitterNetwork()).transmitters.size()));
        }
        return this.buffer.amount;
    }

    @Override
    public TransmitterType getTransmitterType() {
        return this.tier.type;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTags) {
        super.readFromNBT(nbtTags);
        this.buffer.amount = nbtTags.func_74769_h("cacheEnergy");
        if (this.buffer.amount < 0.0) {
            this.buffer.amount = 0.0;
        }
        if (nbtTags.func_74764_b("tier")) {
            this.tier = Tier.CableTier.values()[nbtTags.func_74762_e("tier")];
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbtTags) {
        super.writeToNBT(nbtTags);
        nbtTags.func_74780_a("cacheEnergy", this.lastWrite);
        nbtTags.func_74768_a("tier", this.tier.ordinal());
        return nbtTags;
    }

    public ResourceLocation getType() {
        return new ResourceLocation("mekanism:universal_cable_" + this.tier.name().toLowerCase());
    }

    @Override
    public TransmissionType getTransmissionType() {
        return TransmissionType.ENERGY;
    }

    @Override
    public EnergyNetwork createNetworkByMerging(Collection<EnergyNetwork> networks) {
        return new EnergyNetwork(networks);
    }

    @Override
    public boolean isValidAcceptor(TileEntity acceptor, EnumFacing side) {
        return CableUtils.isValidAcceptorOnSide(this.getWorld().func_175625_s(this.getPos()), acceptor, side);
    }

    @Override
    public EnergyNetwork createNewNetwork() {
        return new EnergyNetwork();
    }

    @Override
    public Object getBuffer() {
        return this.buffer;
    }

    @Override
    public void takeShare() {
        if (this.getTransmitter().hasTransmitterNetwork()) {
            ((EnergyNetwork)this.getTransmitter().getTransmitterNetwork()).buffer.amount -= this.lastWrite;
            this.buffer.amount = this.lastWrite;
        }
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return maxReceive - (int)Math.round(this.takeEnergy((double)maxReceive * MekanismConfig.general.FROM_RF, !simulate) * MekanismConfig.general.TO_RF);
    }

    @Override
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return this.canConnect(from);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return (int)Math.round(this.getEnergy() * MekanismConfig.general.TO_RF);
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return (int)Math.round(this.getMaxEnergy() * MekanismConfig.general.TO_RF);
    }

    @Override
    public int getCapacity() {
        return this.tier.cableCapacity;
    }

    @Override
    public double transferEnergyToAcceptor(EnumFacing side, double amount) {
        if (!this.canReceiveEnergy(side)) {
            return 0.0;
        }
        double toUse = Math.min(this.getMaxEnergy() - this.getEnergy(), amount);
        this.setEnergy(this.getEnergy() + toUse);
        return toUse;
    }

    @Override
    public boolean canReceiveEnergy(EnumFacing side) {
        return this.getConnectionType(side) == PartSidedPipe.ConnectionType.NORMAL;
    }

    @Override
    public double getMaxEnergy() {
        if (this.getTransmitter().hasTransmitterNetwork()) {
            return ((EnergyNetwork)this.getTransmitter().getTransmitterNetwork()).getCapacity();
        }
        return this.getCapacity();
    }

    @Override
    public double getEnergy() {
        if (this.getTransmitter().hasTransmitterNetwork()) {
            return ((EnergyNetwork)this.getTransmitter().getTransmitterNetwork()).buffer.amount;
        }
        return this.buffer.amount;
    }

    @Override
    public void setEnergy(double energy) {
        if (this.getTransmitter().hasTransmitterNetwork()) {
            ((EnergyNetwork)this.getTransmitter().getTransmitterNetwork()).buffer.amount = energy;
        } else {
            this.buffer.amount = energy;
        }
    }

    @Optional.Method(modid="tesla")
    public long givePower(long power, boolean simulated) {
        return power - Math.round(this.takeEnergy((double)power * MekanismConfig.general.FROM_TESLA, !simulated) * MekanismConfig.general.TO_TESLA);
    }

    public double takeEnergy(double energy, boolean doEmit) {
        if (this.getTransmitter().hasTransmitterNetwork()) {
            return ((EnergyNetwork)this.getTransmitter().getTransmitterNetwork()).emit(energy, doEmit);
        }
        double used = Math.min((double)this.getCapacity() - this.buffer.amount, energy);
        if (doEmit) {
            this.buffer.amount += used;
        }
        return energy - used;
    }

    @Override
    public EnergyAcceptorWrapper getCachedAcceptor(EnumFacing side) {
        return EnergyAcceptorWrapper.get(this.getCachedTile(side), side.func_176734_d());
    }

    @Override
    public boolean upgrade(int tierOrdinal) {
        if (this.tier.ordinal() < Tier.BaseTier.ULTIMATE.ordinal() && tierOrdinal == this.tier.ordinal() + 1) {
            this.tier = Tier.CableTier.values()[this.tier.ordinal() + 1];
            this.markDirtyTransmitters();
            this.sendDesc = true;
            return true;
        }
        return false;
    }

    @Override
    public void readUpdatePacket(PacketBuffer packet) {
        this.tier = Tier.CableTier.values()[packet.readInt()];
        super.readUpdatePacket(packet);
    }

    @Override
    public void writeUpdatePacket(PacketBuffer packet) {
        packet.writeInt(this.tier.ordinal());
        super.writeUpdatePacket(packet);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == Capabilities.ENERGY_STORAGE_CAPABILITY || capability == Capabilities.ENERGY_ACCEPTOR_CAPABILITY || capability == Capabilities.TESLA_CONSUMER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == Capabilities.ENERGY_STORAGE_CAPABILITY || capability == Capabilities.ENERGY_ACCEPTOR_CAPABILITY || capability == Capabilities.TESLA_CONSUMER_CAPABILITY) {
            return (T)this;
        }
        return super.getCapability(capability, facing);
    }
}

