/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities;

import mekanism.api.energy.IStrictEnergyAcceptor;
import mekanism.common.capabilities.DefaultStorageHelper;
import mekanism.common.capabilities.DefaultStrictEnergyStorage;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.util.INBTSerializable;

public class DefaultStrictEnergyAcceptor
extends DefaultStrictEnergyStorage
implements IStrictEnergyAcceptor,
INBTSerializable<NBTTagCompound> {
    public DefaultStrictEnergyAcceptor() {
        this(0.0);
    }

    public DefaultStrictEnergyAcceptor(double capacity) {
        super(capacity);
    }

    @Override
    public double transferEnergyToAcceptor(EnumFacing side, double amount) {
        double used = Math.min(amount, Math.max(0.0, this.getMaxEnergy() - this.getEnergy()));
        this.setEnergy(this.getEnergy() + used);
        return used;
    }

    @Override
    public boolean canReceiveEnergy(EnumFacing side) {
        return true;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        return super.serializeNBT();
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(IStrictEnergyAcceptor.class, new DefaultStorageHelper.DefaultStorage(), DefaultStrictEnergyAcceptor.class);
    }
}

