/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import mekanism.client.render.FluidRenderer;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.content.tank.SynchronizedTankData;
import mekanism.common.tile.TileEntityDynamicTank;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderDynamicTank
extends TileEntitySpecialRenderer<TileEntityDynamicTank> {
    public void renderTileEntityAt(TileEntityDynamicTank tileEntity, double x, double y, double z, float partialTick, int destroyStage) {
        if (tileEntity.clientHasStructure && tileEntity.isRendering && tileEntity.structure != null && ((SynchronizedTankData)tileEntity.structure).fluidStored != null && ((SynchronizedTankData)tileEntity.structure).fluidStored.amount != 0) {
            FluidRenderer.RenderData data = new FluidRenderer.RenderData();
            data.location = ((SynchronizedTankData)tileEntity.structure).renderLocation;
            data.height = ((SynchronizedTankData)tileEntity.structure).volHeight - 2;
            data.length = ((SynchronizedTankData)tileEntity.structure).volLength;
            data.width = ((SynchronizedTankData)tileEntity.structure).volWidth;
            data.fluidType = ((SynchronizedTankData)tileEntity.structure).fluidStored.getFluid();
            this.func_147499_a(MekanismRenderer.getBlocksTexture());
            if (data.location != null && data.height >= 1) {
                FluidRenderer.push();
                FluidRenderer.translateToOrigin(data.location);
                MekanismRenderer.glowOn(((SynchronizedTankData)tileEntity.structure).fluidStored.getFluid().getLuminosity());
                MekanismRenderer.colorFluid(((SynchronizedTankData)tileEntity.structure).fluidStored.getFluid());
                if (((SynchronizedTankData)tileEntity.structure).fluidStored.getFluid().isGaseous()) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.min(1.0f, (float)((SynchronizedTankData)tileEntity.structure).fluidStored.amount / (float)tileEntity.clientCapacity + MekanismRenderer.GAS_RENDER_BASE));
                    FluidRenderer.getTankDisplay(data).render();
                } else {
                    FluidRenderer.getTankDisplay(data, tileEntity.prevScale).render();
                }
                MekanismRenderer.glowOff();
                MekanismRenderer.resetColor();
                FluidRenderer.pop();
                for (SynchronizedTankData.ValveData valveData : tileEntity.valveViewing) {
                    FluidRenderer.push();
                    FluidRenderer.translateToOrigin(valveData.location);
                    MekanismRenderer.glowOn(((SynchronizedTankData)tileEntity.structure).fluidStored.getFluid().getLuminosity());
                    MekanismRenderer.colorFluid(((SynchronizedTankData)tileEntity.structure).fluidStored.getFluid());
                    FluidRenderer.getValveDisplay(FluidRenderer.ValveRenderData.get(data, valveData)).render();
                    MekanismRenderer.glowOff();
                    MekanismRenderer.resetColor();
                    FluidRenderer.pop();
                }
            }
        }
    }
}

