/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.element.GuiScrollList;
import mekanism.client.gui.element.GuiSideConfigurationTab;
import mekanism.client.gui.element.GuiTransporterConfigTab;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.frequency.Frequency;
import mekanism.common.frequency.FrequencyManager;
import mekanism.common.inventory.container.ContainerQuantumEntangloporter;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityQuantumEntangloporter;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiQuantumEntangloporter
extends GuiMekanism {
    public ResourceLocation resource;
    public TileEntityQuantumEntangloporter tileEntity;
    public EntityPlayer entityPlayer;
    public GuiButton publicButton;
    public GuiButton privateButton;
    public GuiButton setButton;
    public GuiButton deleteButton;
    public GuiScrollList scrollList;
    public GuiTextField frequencyField;
    public boolean privateMode;

    public GuiQuantumEntangloporter(InventoryPlayer inventory, TileEntityQuantumEntangloporter tentity) {
        super(tentity, new ContainerQuantumEntangloporter(inventory, tentity));
        this.tileEntity = tentity;
        this.resource = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiTeleporter.png");
        this.scrollList = new GuiScrollList(this, this.resource, 28, 37, 120, 4);
        this.guiElements.add(this.scrollList);
        this.guiElements.add(new GuiSideConfigurationTab(this, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiTeleporter.png")));
        this.guiElements.add(new GuiTransporterConfigTab(this, 34, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiTeleporter.png")));
        if (this.tileEntity.frequency != null) {
            this.privateMode = !this.tileEntity.frequency.publicFreq;
        }
        this.field_147000_g += 64;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.clear();
        this.publicButton = new GuiButton(0, guiWidth + 27, guiHeight + 14, 60, 20, LangUtils.localize("gui.public"));
        this.privateButton = new GuiButton(1, guiWidth + 89, guiHeight + 14, 60, 20, LangUtils.localize("gui.private"));
        this.setButton = new GuiButton(2, guiWidth + 27, guiHeight + 116, 60, 20, LangUtils.localize("gui.set"));
        this.deleteButton = new GuiButton(3, guiWidth + 89, guiHeight + 116, 60, 20, LangUtils.localize("gui.delete"));
        this.frequencyField = new GuiTextField(4, this.field_146289_q, guiWidth + 50, guiHeight + 104, 86, 11);
        this.frequencyField.func_146203_f(16);
        this.frequencyField.func_146185_a(false);
        this.updateButtons();
        this.field_146292_n.add(this.publicButton);
        this.field_146292_n.add(this.privateButton);
        this.field_146292_n.add(this.setButton);
        this.field_146292_n.add(this.deleteButton);
    }

    public void setFrequency(String freq) {
        if (freq.isEmpty()) {
            return;
        }
        ArrayList<Object> data = new ArrayList<Object>();
        data.add(0);
        data.add(freq);
        data.add(!this.privateMode);
        Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
    }

    public String getSecurity(Frequency freq) {
        return !freq.publicFreq ? (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.private") : LangUtils.localize("gui.public");
    }

    public void updateButtons() {
        if (this.tileEntity.getSecurity().getOwner() == null) {
            return;
        }
        ArrayList<String> text = new ArrayList<String>();
        if (this.privateMode) {
            for (Frequency freq : this.tileEntity.privateCache) {
                text.add(freq.name);
            }
        } else {
            for (Frequency freq : this.tileEntity.publicCache) {
                text.add(freq.name + " (" + freq.owner + ")");
            }
        }
        this.scrollList.setText(text);
        if (this.privateMode) {
            this.publicButton.field_146124_l = true;
            this.privateButton.field_146124_l = false;
        } else {
            this.publicButton.field_146124_l = false;
            this.privateButton.field_146124_l = true;
        }
        if (this.scrollList.hasSelection()) {
            Frequency freq = this.privateMode ? this.tileEntity.privateCache.get(this.scrollList.selected) : this.tileEntity.publicCache.get(this.scrollList.selected);
            this.setButton.field_146124_l = this.tileEntity.getFrequency(null) == null || !this.tileEntity.getFrequency(null).equals(freq);
            this.deleteButton.field_146124_l = this.tileEntity.getSecurity().getOwner().equals(freq.owner);
        } else {
            this.setButton.field_146124_l = false;
            this.deleteButton.field_146124_l = false;
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.updateButtons();
        this.frequencyField.func_146178_a();
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        this.updateButtons();
        this.frequencyField.func_146192_a(mouseX, mouseY, button);
        if (button == 0) {
            int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
            int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
            if (xAxis >= 137 && xAxis <= 148 && yAxis >= 103 && yAxis <= 114) {
                this.setFrequency(this.frequencyField.func_146179_b());
                this.frequencyField.func_146180_a("");
                SoundHandler.playSound(SoundEvents.field_187909_gi);
            }
        }
    }

    public void func_73869_a(char c, int i) throws IOException {
        if (!this.frequencyField.func_146206_l() || i == 1) {
            super.func_73869_a(c, i);
        }
        if (i == 28 && this.frequencyField.func_146206_l()) {
            this.setFrequency(this.frequencyField.func_146179_b());
            this.frequencyField.func_146180_a("");
        }
        if (Character.isDigit(c) || Character.isLetter(c) || GuiQuantumEntangloporter.isTextboxKey(c, i) || FrequencyManager.SPECIAL_CHARS.contains(Character.valueOf(c))) {
            this.frequencyField.func_146201_a(c, i);
        }
        this.updateButtons();
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        int selection;
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == 0) {
            this.privateMode = false;
        } else if (guibutton.field_146127_k == 1) {
            this.privateMode = true;
        } else if (guibutton.field_146127_k == 2) {
            int selection2 = this.scrollList.getSelection();
            if (selection2 != -1) {
                Frequency freq = this.privateMode ? this.tileEntity.privateCache.get(selection2) : this.tileEntity.publicCache.get(selection2);
                this.setFrequency(freq.name);
            }
        } else if (guibutton.field_146127_k == 3 && (selection = this.scrollList.getSelection()) != -1) {
            Frequency freq = this.privateMode ? this.tileEntity.privateCache.get(selection) : this.tileEntity.publicCache.get(selection);
            ArrayList<Object> data = new ArrayList<Object>();
            data.add(1);
            data.add(freq.name);
            data.add(freq.publicFreq);
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
            this.scrollList.selected = -1;
        }
        this.updateButtons();
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146289_q.func_78276_b(this.tileEntity.func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(this.tileEntity.func_70005_c_()) / 2, 4, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.owner") + ": " + (this.tileEntity.getSecurity().getOwner() != null ? this.tileEntity.getSecurity().getOwner() : LangUtils.localize("gui.none")), 8, this.field_147000_g - 96 + 4, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.freq") + ":", 32, 81, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.security") + ":", 32, 91, 0x404040);
        this.field_146289_q.func_78276_b(" " + (this.tileEntity.getFrequency(null) != null ? this.tileEntity.getFrequency(null).name : (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.none")), 32 + this.field_146289_q.func_78256_a(LangUtils.localize("gui.freq") + ":"), 81, 0x797979);
        this.field_146289_q.func_78276_b(" " + (this.tileEntity.getFrequency(null) != null ? this.getSecurity(this.tileEntity.getFrequency(null)) : (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.none")), 32 + this.field_146289_q.func_78256_a(LangUtils.localize("gui.security") + ":"), 91, 0x797979);
        String str = LangUtils.localize("gui.set") + ":";
        this.renderScaledText(str, 27, 104, 0x404040, 20);
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(this.resource);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        if (xAxis >= 137 && xAxis <= 148 && yAxis >= 103 && yAxis <= 114) {
            this.func_73729_b(guiWidth + 137, guiHeight + 103, this.field_146999_f, 0, 11, 11);
        } else {
            this.func_73729_b(guiWidth + 137, guiHeight + 103, this.field_146999_f, 11, 11, 11);
        }
        super.func_146976_a(partialTick, mouseX, mouseY);
        this.frequencyField.func_146194_f();
    }
}

