/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import java.util.HashMap;
import java.util.Map;
import mekanism.api.util.UnitDisplayUtils;

public class MekanismConfig {

    public static class tools {
        public static double armorSpawnRate;
    }

    public static class generators {
        public static double advancedSolarGeneration;
        public static double bioGeneration;
        public static double heatGeneration;
        public static double heatGenerationLava;
        public static double heatGenerationNether;
        public static double solarGeneration;
        public static double windGenerationMin;
        public static double windGenerationMax;
        public static int windGenerationMinY;
        public static int windGenerationMaxY;
        public static int turbineBladesPerCoil;
        public static double turbineVentGasFlow;
        public static double turbineDisperserGasFlow;
        public static int condenserRate;
    }

    public static class usage {
        public static double enrichmentChamberUsage;
        public static double osmiumCompressorUsage;
        public static double combinerUsage;
        public static double crusherUsage;
        public static double factoryUsage;
        public static double metallurgicInfuserUsage;
        public static double purificationChamberUsage;
        public static double energizedSmelterUsage;
        public static double digitalMinerUsage;
        public static double electricPumpUsage;
        public static double rotaryCondensentratorUsage;
        public static double oxidationChamberUsage;
        public static double chemicalInfuserUsage;
        public static double chemicalInjectionChamberUsage;
        public static double precisionSawmillUsage;
        public static double chemicalDissolutionChamberUsage;
        public static double chemicalWasherUsage;
        public static double chemicalCrystallizerUsage;
        public static double seismicVibratorUsage;
        public static double pressurizedReactionBaseUsage;
        public static double fluidicPlenisherUsage;
        public static double laserUsage;
        public static double gasCentrifugeUsage;
        public static double heavyWaterElectrolysisUsage;
        public static double formulaicAssemblicatorUsage;
    }

    public static class machines {
        private static Map<String, Boolean> config = new HashMap<String, Boolean>();

        public static boolean isEnabled(String type) {
            return config.get(type) != null && config.get(type) != false;
        }

        public static void setEntry(String type, boolean enabled) {
            config.put(type, enabled);
        }
    }

    public static class client {
        public static boolean enablePlayerSounds = true;
        public static boolean enableMachineSounds = true;
        public static boolean holidays = true;
        public static float baseSoundVolume = 1.0f;
        public static boolean machineEffects = true;
        public static boolean oldTransmitterRender = false;
        public static boolean replaceSoundsWhenResuming = true;
        public static boolean renderCTM = true;
        public static boolean enableAmbientLighting;
        public static int ambientLightingLevel;
        public static boolean opaqueTransmitters;

        static {
            opaqueTransmitters = false;
        }
    }

    public static class general {
        public static boolean updateNotifications = true;
        public static boolean controlCircuitOreDict = true;
        public static boolean logPackets = false;
        public static boolean dynamicTankEasterEgg = false;
        public static boolean voiceServerEnabled = true;
        public static boolean cardboardSpawners = true;
        public static boolean enableWorldRegeneration = true;
        public static boolean spawnBabySkeletons = true;
        public static int obsidianTNTBlastRadius = 12;
        public static int osmiumPerChunk = 12;
        public static int copperPerChunk = 16;
        public static int tinPerChunk = 14;
        public static int saltPerChunk = 2;
        public static int obsidianTNTDelay = 100;
        public static int UPDATE_DELAY = 10;
        public static int VOICE_PORT = 36123;
        public static int maxUpgradeMultiplier = 10;
        public static int userWorldGenVersion = 0;
        public static double ENERGY_PER_REDSTONE = 10000.0;
        public static int ETHENE_BURN_TIME = 40;
        public static double DISASSEMBLER_USAGE = 10.0;
        public static UnitDisplayUtils.EnergyType energyUnit = UnitDisplayUtils.EnergyType.J;
        public static UnitDisplayUtils.TempType tempUnit = UnitDisplayUtils.TempType.K;
        public static double TO_IC2;
        public static double TO_RF;
        public static double TO_TESLA;
        public static double FROM_H2;
        public static double FROM_IC2;
        public static double FROM_RF;
        public static double FROM_TESLA;
        public static int laserRange;
        public static double laserEnergyNeededPerHardness;
        public static double minerSilkMultiplier;
        public static boolean blacklistIC2;
        public static boolean blacklistRF;
        public static boolean blacklistTesla;
        public static boolean destroyDisabledBlocks;
        public static boolean prefilledGasTanks;
        public static double armoredJetpackDamageRatio;
        public static int armoredJetpackDamageMax;
        public static boolean aestheticWorldDamage;
        public static boolean opsBypassRestrictions;
        public static double thermalEvaporationSpeed;
        public static int maxJetpackGas;
        public static int maxScubaGas;
        public static int maxFlamethrowerGas;
        public static int maxPumpRange;
        public static boolean pumpWaterSources;
        public static int maxPlenisherNodes;
        public static double evaporationHeatDissipation;
        public static double evaporationTempMultiplier;
        public static double evaporationSolarMultiplier;
        public static double evaporationMaxTemp;
        public static double energyPerHeat;
        public static double maxEnergyPerSteam;
        public static double superheatingHeatTransfer;
        public static double heatPerFuelTick;
        public static boolean allowTransmitterAlloyUpgrade;
        public static boolean allowChunkloading;

        static {
            minerSilkMultiplier = 6.0;
            evaporationHeatDissipation = 0.02;
            evaporationTempMultiplier = 0.1;
            evaporationSolarMultiplier = 0.2;
            evaporationMaxTemp = 3000.0;
            energyPerHeat = 1000.0;
            maxEnergyPerSteam = 100.0;
            superheatingHeatTransfer = 10000.0;
            heatPerFuelTick = 4.0;
        }
    }
}

