/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import mekanism.api.Coord4D;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class Chunk3D {
    public int dimensionId;
    public int xCoord;
    public int zCoord;

    public Chunk3D(int x, int z, int dimension) {
        this.xCoord = x;
        this.zCoord = z;
        this.dimensionId = dimension;
    }

    public Chunk3D(Entity entity) {
        this.xCoord = (int)entity.field_70165_t >> 4;
        this.zCoord = (int)entity.field_70161_v >> 4;
        this.dimensionId = entity.field_71093_bK;
    }

    public Chunk3D(Coord4D coord) {
        this.xCoord = coord.xCoord >> 4;
        this.zCoord = coord.zCoord >> 4;
        this.dimensionId = coord.dimensionId;
    }

    public boolean exists(World world) {
        return world.func_72863_F().func_186026_b(this.xCoord, this.zCoord) != null;
    }

    public Chunk getChunk(World world) {
        return world.func_72964_e(this.xCoord, this.zCoord);
    }

    public ChunkPos getPos() {
        return new ChunkPos(this.xCoord, this.zCoord);
    }

    public Chunk3D clone() {
        return new Chunk3D(this.xCoord, this.zCoord, this.dimensionId);
    }

    public String toString() {
        return "[Chunk3D: " + this.xCoord + ", " + this.zCoord + ", dim=" + this.dimensionId + "]";
    }

    public boolean equals(Object obj) {
        return obj instanceof Chunk3D && ((Chunk3D)obj).xCoord == this.xCoord && ((Chunk3D)obj).zCoord == this.zCoord && ((Chunk3D)obj).dimensionId == this.dimensionId;
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + this.xCoord;
        code = 31 * code + this.zCoord;
        code = 31 * code + this.dimensionId;
        return code;
    }
}

