/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.util;

import com.amadornes.rscircuits.api.IItemWrapper;
import com.amadornes.rscircuits.api.component.EnumCircuitSide;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import org.apache.commons.lang3.tuple.Pair;

public class RedstoneUtils {
    private static final EnumFacing[][] CONVERT_CIRCUIT_FACING = new EnumFacing[][]{{EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.SOUTH, EnumFacing.NORTH, EnumFacing.WEST, EnumFacing.EAST}, {EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.WEST, EnumFacing.UP, EnumFacing.DOWN}, {EnumFacing.SOUTH, EnumFacing.NORTH, EnumFacing.WEST, EnumFacing.EAST, EnumFacing.UP, EnumFacing.DOWN}, {EnumFacing.WEST, EnumFacing.EAST, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.UP, EnumFacing.DOWN}, {EnumFacing.EAST, EnumFacing.WEST, EnumFacing.SOUTH, EnumFacing.NORTH, EnumFacing.UP, EnumFacing.DOWN}};
    private static final EnumCircuitSide[][] CONVERT_FACING_CIRCUIT = new EnumCircuitSide[][]{{EnumCircuitSide.BOTTOM, EnumCircuitSide.TOP, EnumCircuitSide.BACK, EnumCircuitSide.FRONT, EnumCircuitSide.RIGHT, EnumCircuitSide.LEFT}, {EnumCircuitSide.TOP, EnumCircuitSide.BOTTOM, EnumCircuitSide.FRONT, EnumCircuitSide.BACK, EnumCircuitSide.RIGHT, EnumCircuitSide.LEFT}, {EnumCircuitSide.LEFT, EnumCircuitSide.RIGHT, EnumCircuitSide.BOTTOM, EnumCircuitSide.TOP, EnumCircuitSide.FRONT, EnumCircuitSide.BACK}, {EnumCircuitSide.LEFT, EnumCircuitSide.RIGHT, EnumCircuitSide.TOP, EnumCircuitSide.BOTTOM, EnumCircuitSide.BACK, EnumCircuitSide.FRONT}, {EnumCircuitSide.LEFT, EnumCircuitSide.RIGHT, EnumCircuitSide.BACK, EnumCircuitSide.FRONT, EnumCircuitSide.BOTTOM, EnumCircuitSide.TOP}, {EnumCircuitSide.LEFT, EnumCircuitSide.RIGHT, EnumCircuitSide.FRONT, EnumCircuitSide.BACK, EnumCircuitSide.TOP, EnumCircuitSide.BOTTOM}};

    public static BlockPos limitPositionToBounds(BlockPos pos) {
        return new BlockPos((pos.func_177958_n() % 8 + 8) % 8, (pos.func_177956_o() % 5 + 5) % 5, (pos.func_177952_p() % 8 + 8) % 8);
    }

    public static Vec3d limitPositionToBounds(Vec3d pos) {
        return new Vec3d((pos.field_72450_a % 8.0 + 8.0) % 8.0, (pos.field_72448_b % 5.0 + 5.0) % 5.0, (pos.field_72449_c % 8.0 + 8.0) % 8.0);
    }

    public static ItemStack unwrap(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof IItemWrapper) {
            return ((IItemWrapper)stack.func_77973_b()).getWrappedStack(stack);
        }
        return stack;
    }

    public static BlockPos packCoords(BlockPos pos, EnumFacing face, BlockPos component) {
        Pair<BlockPos, BlockPos> p = RedstoneUtils.correctCoords(pos, face, component);
        return new BlockPos(((BlockPos)p.getKey()).func_177958_n() * 8 + ((BlockPos)p.getValue()).func_177958_n(), ((BlockPos)p.getKey()).func_177956_o() * 8 + ((BlockPos)p.getValue()).func_177956_o(), ((BlockPos)p.getKey()).func_177952_p() * 8 + ((BlockPos)p.getValue()).func_177952_p());
    }

    public static Pair<BlockPos, BlockPos> unpackCoords(BlockPos packed) {
        BlockPos pos = RedstoneUtils.limitPositionToBounds(packed);
        BlockPos circPos = new BlockPos((packed.func_177958_n() - pos.func_177958_n()) / 8, (packed.func_177956_o() - pos.func_177956_o()) / 8, (packed.func_177952_p() - pos.func_177952_p()) / 8);
        return Pair.of((Object)circPos, (Object)pos);
    }

    public static BlockPos correctOffset(BlockPos off, EnumFacing face) {
        switch (face) {
            case DOWN: {
                return off;
            }
            case UP: {
                return new BlockPos(off.func_177958_n(), off.func_177956_o(), -off.func_177952_p());
            }
            case NORTH: {
                return new BlockPos(-off.func_177952_p(), -off.func_177958_n(), off.func_177956_o());
            }
            case SOUTH: {
                return new BlockPos(off.func_177952_p(), -off.func_177958_n(), off.func_177956_o());
            }
            case WEST: {
                return new BlockPos(-off.func_177956_o(), -off.func_177958_n(), off.func_177952_p());
            }
            case EAST: {
                return new BlockPos(-off.func_177956_o(), -off.func_177958_n(), -off.func_177952_p());
            }
        }
        return off;
    }

    public static Vec3d projectComponent(Vec3d pos, EnumFacing face, BlockPos compPos) {
        return RedstoneUtils.project(pos, face).func_178786_a(0.0625, 0.125, 0.0625).func_186678_a(8.0).func_178788_d(new Vec3d((Vec3i)compPos));
    }

    public static Vec3d project(Vec3d pos, EnumFacing face) {
        switch (face) {
            case DOWN: {
                return pos;
            }
            case UP: {
                return new Vec3d(pos.field_72450_a, 1.0 - pos.field_72448_b, 1.0 - pos.field_72449_c);
            }
            case NORTH: {
                return new Vec3d(1.0 - pos.field_72448_b, pos.field_72449_c, 1.0 - pos.field_72450_a);
            }
            case SOUTH: {
                return new Vec3d(1.0 - pos.field_72448_b, 1.0 - pos.field_72449_c, pos.field_72450_a);
            }
            case WEST: {
                return new Vec3d(1.0 - pos.field_72448_b, pos.field_72450_a, pos.field_72449_c);
            }
            case EAST: {
                return new Vec3d(1.0 - pos.field_72448_b, 1.0 - pos.field_72450_a, 1.0 - pos.field_72449_c);
            }
        }
        return pos;
    }

    public static Vec3d unproject(Vec3d pos, EnumFacing face) {
        switch (face) {
            case DOWN: {
                return pos;
            }
            case UP: {
                return new Vec3d(pos.field_72450_a, 1.0 - pos.field_72448_b, 1.0 - pos.field_72449_c);
            }
            case NORTH: {
                return new Vec3d(1.0 - pos.field_72449_c, 1.0 - pos.field_72450_a, pos.field_72448_b);
            }
            case SOUTH: {
                return new Vec3d(pos.field_72449_c, 1.0 - pos.field_72450_a, 1.0 - pos.field_72448_b);
            }
            case WEST: {
                return new Vec3d(pos.field_72448_b, 1.0 - pos.field_72450_a, pos.field_72449_c);
            }
            case EAST: {
                return new Vec3d(1.0 - pos.field_72448_b, 1.0 - pos.field_72450_a, 1.0 - pos.field_72449_c);
            }
        }
        return pos;
    }

    public static Pair<BlockPos, BlockPos> correctCoords(BlockPos pos, EnumFacing face, BlockPos component) {
        Pair<BlockPos, BlockPos> up = RedstoneUtils.unpackCoords(component);
        BlockPos off = RedstoneUtils.correctOffset((BlockPos)up.getKey(), face);
        return Pair.of((Object)pos.func_177971_a((Vec3i)off), (Object)up.getValue());
    }

    public static EnumFacing convert(EnumFacing face, EnumCircuitSide side) {
        return CONVERT_CIRCUIT_FACING[face.ordinal()][side.ordinal()];
    }

    public static EnumCircuitSide convert(EnumFacing face, EnumFacing side) {
        return CONVERT_FACING_CIRCUIT[face.ordinal()][side.ordinal()];
    }
}

